/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.entity.AdornEntities;
import juuxel.adorn.entity.SeatEntity;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+J#\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J?\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0016\u0010\"\u001a\u0004\u0018\u00010\u001f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010$\u001a\u00020#8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Ljuuxel/adorn/block/SeatBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/Level;", "world", "state", "Lnet/minecraft/core/BlockPos;", "pos", "getActualSeatPos", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "", "isSittingEnabled", "()Z", "newState", "moved", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/resources/ResourceLocation;", "getSittingStat", "()Lnet/minecraft/resources/ResourceLocation;", "sittingStat", "", "sittingYOffset", "D", "getSittingYOffset", "()D", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Companion", "Adorn"})
@SourceDebugExtension(value={"SMAP\nSeatBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeatBlock.kt\njuuxel/adorn/block/SeatBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1855#3,2:103\n*S KotlinDebug\n*F\n+ 1 SeatBlock.kt\njuuxel/adorn/block/SeatBlock\n*L\n81#1:103,2\n*E\n"})
public abstract class SeatBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double sittingYOffset;
    @JvmField
    @NotNull
    public static final BooleanProperty OCCUPIED;

    public SeatBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        if (this.isSittingEnabled()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public double getSittingYOffset() {
        return this.sittingYOffset;
    }

    @Nullable
    public abstract ResourceLocation getSittingStat();

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        InteractionResult interactionResult;
        BlockState actualState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!this.isSittingEnabled()) {
            InteractionResult interactionResult2 = super.m_6227_(state, world, pos, player, hand, hit);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"super.onUse(state, world, pos, player, hand, hit)");
            return interactionResult2;
        }
        BlockPos actualPos = this.getActualSeatPos(world, state, pos);
        BlockState blockState = actualState = Intrinsics.areEqual((Object)pos, (Object)actualPos) ? state : world.m_8055_(actualPos);
        if (state != actualState && !(actualState.m_60734_() instanceof SeatBlock)) {
            return InteractionResult.PASS;
        }
        Boolean occupied = (Boolean)actualState.m_61143_((Property)OCCUPIED);
        if (!occupied.booleanValue()) {
            if (world instanceof ServerLevel) {
                SeatEntity entity;
                SeatEntity seatEntity = entity = (SeatEntity)AdornEntities.INSTANCE.getSEAT().m_20615_(world);
                if (seatEntity != null) {
                    seatEntity.setPos(actualPos, this.getSittingYOffset());
                }
                world.m_7967_((Entity)entity);
                world.m_46597_(actualPos, (BlockState)actualState.m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)));
                player.m_7998_((Entity)entity, true);
                ResourceLocation resourceLocation = this.getSittingStat();
                if (resourceLocation != null) {
                    ResourceLocation it = resourceLocation;
                    boolean bl = false;
                    player.m_36220_(it);
                }
                if (player instanceof ServerPlayer) {
                    AdornCriteria.INSTANCE.getSIT_ON_BLOCK().trigger((ServerPlayer)player, pos);
                }
            }
            interactionResult = InteractionResult.SUCCESS;
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    /*
     * WARNING - void declaration
     */
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.m_6810_(state, world, pos, newState, moved);
        if (!state.m_60713_(newState.m_60734_())) {
            void $this$forEach$iv;
            if (world.f_46443_ || !this.isSittingEnabled()) {
                return;
            }
            List list = world.m_142425_((EntityTypeTest)AdornEntities.INSTANCE.getSEAT(), new AABB(this.getActualSeatPos(world, state, pos)), (Predicate)Predicates.alwaysTrue());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"world.getEntitiesByType(\u2026lwaysTrue()\n            )");
            Iterable iterable = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SeatEntity it = (SeatEntity)((Object)element$iv);
                boolean bl = false;
                it.m_20153_();
                it.m_6074_();
            }
        }
    }

    @NotNull
    protected BlockPos getActualSeatPos(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.m_7926_(builder);
        if (this.isSittingEnabled()) {
            Property[] propertyArray = new Property[]{(Property)OCCUPIED};
            builder.m_61104_(propertyArray);
        }
    }

    protected boolean isSittingEnabled() {
        return true;
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.f_61445_;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"OCCUPIED");
        OCCUPIED = booleanProperty;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Ljuuxel/adorn/block/SeatBlock$Companion;", "", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "OCCUPIED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

