/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.server.message;

import java.util.function.Supplier;
import net.mathimomos.wormhole_artifact.server.item.custom.WormholeArtifactItem;
import net.mathimomos.wormhole_artifact.server.item.custom.WormholeRemoteItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class TeleportToTargetMessage {
    private final String pTargetName;

    public TeleportToTargetMessage(String pTargetName) {
        this.pTargetName = pTargetName;
    }

    public static void write(TeleportToTargetMessage pMessage, FriendlyByteBuf pBuffer) {
        pBuffer.m_130070_(pMessage.pTargetName);
    }

    public static TeleportToTargetMessage read(FriendlyByteBuf pBuffer) {
        return new TeleportToTargetMessage(pBuffer.m_130277_());
    }

    public static void handle(TeleportToTargetMessage pMessage, Supplier<NetworkEvent.Context> pContextSupplier) {
        NetworkEvent.Context pContext = pContextSupplier.get();
        pContext.enqueueWork(() -> {
            ServerPlayer pPlayer = pContext.getSender();
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer pServerPlayer = pPlayer;
                ServerPlayer pTargetPlayer = pServerPlayer.m_20194_().m_6846_().m_11314_().stream().filter(player -> player.m_5446_().getString().equals(pMessage.pTargetName)).findFirst().orElse(null);
                if (pTargetPlayer != null) {
                    if (pServerPlayer.m_21205_().m_41720_() instanceof WormholeArtifactItem) {
                        ((WormholeArtifactItem)pServerPlayer.m_21205_().m_41720_()).teleportToTarget(pServerPlayer, pTargetPlayer, pServerPlayer.m_21205_(), pServerPlayer.m_9236_());
                    } else if (pServerPlayer.m_21205_().m_41720_() instanceof WormholeRemoteItem) {
                        ((WormholeRemoteItem)pServerPlayer.m_21205_().m_41720_()).teleportToTarget(pServerPlayer, pTargetPlayer, pServerPlayer.m_21205_(), pServerPlayer.m_9236_());
                    }
                } else {
                    pServerPlayer.m_5661_((Component)Component.m_237115_((String)"text.wormhole_artifact.player_not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            }
        });
        pContext.setPacketHandled(true);
    }
}

