/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.server.message;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mathimomos.wormhole_artifact.client.screen.WormholeArtifactScreen;
import net.mathimomos.wormhole_artifact.server.message.PlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PlayerListResponseMessage {
    private final List<PlayerData> playerData;

    public PlayerListResponseMessage(List<PlayerData> playerData) {
        this.playerData = playerData;
    }

    public static void write(PlayerListResponseMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerData.size());
        for (PlayerData data : message.playerData) {
            buffer.m_130070_(data.getPlayerName());
            buffer.m_130070_(data.getPlayerDimension());
            buffer.writeInt(data.getPlayerDistance());
        }
    }

    public static PlayerListResponseMessage read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<PlayerData> playerData = new ArrayList<PlayerData>();
        for (int i = 0; i < size; ++i) {
            String name = buffer.m_130277_();
            String dimension = buffer.m_130277_();
            int distance = buffer.readInt();
            playerData.add(new PlayerData(name, dimension, distance));
        }
        return new PlayerListResponseMessage(playerData);
    }

    public static void handle(PlayerListResponseMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Screen patt1776$temp = minecraft.f_91080_;
            if (patt1776$temp instanceof WormholeArtifactScreen) {
                WormholeArtifactScreen screen = (WormholeArtifactScreen)patt1776$temp;
                screen.updatePlayerData(message.getPlayerData());
            }
        });
        context.setPacketHandled(true);
    }

    public List<PlayerData> getPlayerData() {
        return this.playerData;
    }
}

