/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WormholeArtifactButton
extends Button {
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("wormhole_artifact", "textures/gui/wormhole_artifact_button.png");
    private static final ResourceLocation BUTTON_TEXTURE_HOVERED = new ResourceLocation("wormhole_artifact", "textures/gui/wormhole_artifact_button_hovered.png");
    private final String playerName;
    private final String dimension;
    private final String distance;

    protected WormholeArtifactButton(int pX, int pY, int pWidth, int pHeight, String playerName, String dimension, String distance, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237113_((String)playerName), pOnPress, Button.f_252438_);
        this.playerName = playerName;
        this.dimension = dimension;
        this.distance = distance;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        ResourceLocation texture = this.m_274382_() ? BUTTON_TEXTURE_HOVERED : BUTTON_TEXTURE;
        pGuiGraphics.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), 160, 30);
        Font font = Minecraft.m_91087_().f_91062_;
        int textNameX = this.m_252754_() + (26 + this.m_5711_() - font.m_92895_(this.playerName)) / 2;
        int textNameY = this.m_252907_() + (this.m_93694_() - 18) / 2;
        pGuiGraphics.m_280488_(font, this.playerName, textNameX, textNameY, 0xFFFFFF);
        String dimensionAndDistance = this.getDimensionName(this.dimension) + this.getDistanceNumber(this.distance);
        int textDimensionAndDistanceX = this.m_252754_() + (26 + this.m_5711_() - font.m_92895_(dimensionAndDistance)) / 2;
        int textDimensionAndDistanceY = textNameY + 10;
        int dimensionColor = this.getDimensionColor(this.dimension);
        pGuiGraphics.m_280488_(font, dimensionAndDistance, textDimensionAndDistanceX, textDimensionAndDistanceY, dimensionColor);
    }

    private int getDimensionColor(String dimension) {
        if (dimension.equals("minecraft:overworld")) {
            return 43520;
        }
        if (dimension.equals("minecraft:the_nether")) {
            return 0xAA0000;
        }
        if (dimension.equals("minecraft:the_end")) {
            return 0xAA00AA;
        }
        if (dimension.equals("aether:the_aether")) {
            return 0x55FFFF;
        }
        if (dimension.equals("twilightforest:twilight_forest")) {
            return 0xFFFF55;
        }
        if (dimension.equals("deeperdarker:otherside")) {
            return 43690;
        }
        if (dimension.equals("the_bumblezone:the_bumblezone")) {
            return 0xFFAA00;
        }
        if (dimension.equals("undergarden:undergarden")) {
            return 4694070;
        }
        return 0xFFFFFF;
    }

    private String getDimensionName(String dimension) {
        if (dimension.equals("minecraft:overworld")) {
            return "Overworld";
        }
        if (dimension.equals("minecraft:the_nether")) {
            return "The Nether";
        }
        if (dimension.equals("minecraft:the_end")) {
            return "The End";
        }
        if (dimension.equals("aether:the_aether")) {
            return "The Aether";
        }
        if (dimension.equals("twilightforest:twilight_forest")) {
            return "Twilight Forest";
        }
        if (dimension.equals("deeperdarker:otherside")) {
            return "Otherside";
        }
        if (dimension.equals("the_bumblezone:the_bumblezone")) {
            return "The Bumblezone";
        }
        if (dimension.equals("undergarden:undergarden")) {
            return "Undergarden";
        }
        return "???";
    }

    private String getDistanceNumber(String distance) {
        if (distance.equals("-1")) {
            return "";
        }
        return " - " + distance + " m";
    }
}

