/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.generator.MineLP;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public enum Locomotion {
    NONE,
    BIPED(() -> new TerrestrialStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED(() -> new TerrestrialStepSoundGenerator(new QuadrupedModifier())),
    FLYING(() -> new WingedStepSoundGenerator(new QuadrupedModifier())),
    FLYING_BIPED(() -> new WingedStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final Supplier<Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase();

    private Locomotion() {
        this.constructor = Optional::empty;
    }

    private Locomotion(Supplier<StepSoundGenerator> gen) {
        this.constructor = () -> Optional.of((StepSoundGenerator)gen.get());
    }

    public Optional<StepSoundGenerator> supplyGenerator() {
        return this.constructor.get();
    }

    public Component getOptionName() {
        return Component.m_237110_((String)"menu.pf.stance", (Object[])new Object[]{Component.m_237115_((String)(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey))});
    }

    public Component getOptionTooltip() {
        return Component.m_237115_((String)(this.translationKey + ".tooltip"));
    }

    public String getDisplayName() {
        return I18n.m_118938_((String)"pf.stance", (Object[])new Object[]{I18n.m_118938_((String)this.translationKey, (Object[])new Object[0])});
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(Entity entity, Locomotion fallback) {
        if (MineLP.hasPonies()) {
            return MineLP.getLocomotion(entity, fallback);
        }
        return fallback;
    }

    public static Locomotion forPlayer(Player ply, Locomotion preference) {
        if (preference == NONE) {
            if (ply instanceof LocalPlayer && MineLP.hasPonies()) {
                return MineLP.getLocomotion(ply);
            }
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new Object2ObjectOpenHashMap();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

