/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetChanceConfig;
import java.util.BitSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureBreakage
extends Feature<StructureTargetChanceConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.m_204336_(BlockTags.f_13061_) || blockState.m_204336_(BlockTags.f_13091_) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_60713_(Blocks.f_50179_) || blockState.m_60713_(Blocks.f_50178_) || blockState.m_60713_(Blocks.f_50176_) || blockState.m_60713_(Blocks.f_50177_) || blockState.m_60713_(Blocks.f_50183_) || blockState.m_60713_(Blocks.f_49994_) || blockState.m_60713_(Blocks.f_276445_) || blockState.m_204336_(BlockTags.f_13045_);
    };

    public StructureBreakage(Codec<StructureTargetChanceConfig> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<StructureTargetChanceConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (context.m_225041_().m_188501_() < ((StructureTargetChanceConfig)context.m_159778_()).chance) {
            mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_(context.m_225041_().m_188503_(7) - 3, 0, context.m_225041_().m_188503_(7) - 3);
            boolean foundSurface = this.findSurface(context.m_159774_(), mutable, Direction.UP);
            if (!foundSurface) {
                mutable.m_122175_(Direction.DOWN, 5);
                foundSurface = this.findSurface(context.m_159774_(), mutable, Direction.DOWN);
            }
            if (!foundSurface) {
                return false;
            }
            mutable.m_122175_(Direction.UP, 2);
            float f = context.m_225041_().m_188501_() * (float)Math.PI;
            float g = 3.0f;
            int i = 2;
            double d = (float)mutable.m_123341_() + Mth.m_14031_((float)f) * g;
            double e = (float)mutable.m_123341_() - Mth.m_14031_((float)f) * g;
            double h = (float)mutable.m_123343_() + Mth.m_14089_((float)f) * g;
            double j = (float)mutable.m_123343_() - Mth.m_14089_((float)f) * g;
            double l = mutable.m_123342_() + context.m_225041_().m_188503_(3) - 2;
            double m = mutable.m_123342_() + context.m_225041_().m_188503_(3) - 2;
            int n = mutable.m_123341_() - Mth.m_14167_((float)g) - i;
            int o = mutable.m_123342_() - 4;
            int p = mutable.m_123343_() - Mth.m_14167_((float)g) - i;
            int q = 2 * (Mth.m_14167_((float)g) + i);
            int r = 8;
            for (int s = n; s <= n + q; ++s) {
                int t = p;
                if (t > p + q) continue;
                return this.generateVeinPart(context, d, e, h, j, l, m, n, o, p, q, r, context.m_159775_());
            }
        }
        return true;
    }

    private boolean findSurface(WorldGenLevel world, BlockPos.MutableBlockPos mutable, Direction direction) {
        for (int i = 0; i <= 5; ++i) {
            if (FORTRESS_BLOCKS.test(world.m_8055_((BlockPos)mutable))) {
                return true;
            }
            mutable.m_122173_(direction);
        }
        return false;
    }

    protected boolean generateVeinPart(FeaturePlaceContext<StructureTargetChanceConfig> context, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i, ChunkGenerator chunkGenerator) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double[] ds = new double[96];
        for (m = 0; m < 24; ++m) {
            float f = (float)m / 24.0f;
            o = Mth.m_14139_((double)f, (double)startX, (double)endX);
            p = Mth.m_14139_((double)f, (double)startY, (double)endY);
            q = Mth.m_14139_((double)f, (double)startZ, (double)endZ);
            r = context.m_225041_().m_188500_() * 24.0 / 16.0;
            double l = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < 23; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < 24; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4] - ds[n * 4]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < 24; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(Mth.m_14107_((double)(u - t)), x);
            int ab = Math.max(Mth.m_14107_((double)(v - t)), y);
            int ac = Math.max(Mth.m_14107_((double)(w - t)), z);
            int ad = Math.max(Mth.m_14107_((double)(u + t)), aa);
            int ae = Math.max(Mth.m_14107_((double)(v + t)), ab);
            int af = Math.max(Mth.m_14107_((double)(w + t)), ac);
            for (int ag = aa; ag <= ad; ++ag) {
                double ah = ((double)ag + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int ai = ab; ai <= ae; ++ai) {
                    double aj = ((double)ai + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int ak = ac; ak <= af; ++ak) {
                        boolean isBelowSealevel;
                        int am;
                        double al = ((double)ak + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = ag - x + (ai - y) * size + (ak - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.m_122178_(ag, ai, ak);
                        BlockState state = context.m_159774_().m_8055_((BlockPos)mutable);
                        if (!FORTRESS_BLOCKS.test(state)) continue;
                        ChunkPos currentChunkPos = new ChunkPos((BlockPos)mutable);
                        ChunkAccess currentChunk = context.m_159774_().m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                        boolean bl = isBelowSealevel = mutable.m_123342_() < chunkGenerator.m_6337_();
                        if (isBelowSealevel && this.isBorderingAir((ServerLevelAccessor)context.m_159774_(), mutable)) continue;
                        currentChunk.m_6978_((BlockPos)mutable, isBelowSealevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50627_.m_49966_(), false);
                        ++j;
                        state = currentChunk.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN));
                        while (mutable.m_123342_() > currentChunk.m_141937_() && mutable.m_123342_() < currentChunk.m_151558_() && (state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13041_))) {
                            currentChunk.m_6978_((BlockPos)mutable, isBelowSealevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50627_.m_49966_(), false);
                            state = currentChunk.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN));
                        }
                        state = currentChunk.m_8055_((BlockPos)mutable.m_122173_(Direction.UP));
                        boolean bl2 = isBelowSealevel = mutable.m_123342_() < chunkGenerator.m_6337_();
                        if (state.m_204336_(BlockTags.f_13045_)) {
                            currentChunk.m_6978_((BlockPos)mutable, isBelowSealevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), false);
                        } else {
                            while (mutable.m_123342_() > currentChunk.m_141937_() && mutable.m_123342_() < currentChunk.m_151558_() && (state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13041_))) {
                                currentChunk.m_6978_((BlockPos)mutable, isBelowSealevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), false);
                                state = currentChunk.m_8055_((BlockPos)mutable.m_122173_(Direction.UP));
                            }
                        }
                        BlockPos.MutableBlockPos mutableVineCheck = new BlockPos.MutableBlockPos();
                        for (Direction direction : Direction.values()) {
                            BlockState neighboringBlock;
                            if (direction == Direction.UP) continue;
                            mutableVineCheck.m_122190_((Vec3i)mutable).m_122173_(direction);
                            if (currentChunkPos.f_45578_ != mutableVineCheck.m_123341_() >> 4 || currentChunkPos.f_45579_ != mutableVineCheck.m_123343_() >> 4) {
                                currentChunk = context.m_159774_().m_46865_((BlockPos)mutableVineCheck);
                                currentChunkPos = new ChunkPos((BlockPos)mutableVineCheck);
                            }
                            if (!(neighboringBlock = currentChunk.m_8055_((BlockPos)mutableVineCheck)).m_60713_(Blocks.f_50191_) || !((Boolean)neighboringBlock.m_61143_((Property)VineBlock.m_57883_((Direction)direction.m_122424_()))).booleanValue()) continue;
                            while (mutable.m_123342_() > currentChunk.m_141937_() && mutable.m_123342_() < currentChunk.m_151558_() && (neighboringBlock.m_204336_(BlockTags.f_278411_) || neighboringBlock.m_204336_(BlockTags.f_13041_))) {
                                currentChunk.m_6978_((BlockPos)mutableVineCheck, isBelowSealevel ? Blocks.f_49990_.m_49966_() : Blocks.f_50627_.m_49966_(), false);
                                neighboringBlock = currentChunk.m_8055_((BlockPos)mutableVineCheck.m_122173_(Direction.DOWN));
                            }
                        }
                    }
                }
            }
        }
        return j > 0;
    }

    private boolean isBorderingAir(ServerLevelAccessor world, BlockPos.MutableBlockPos mutable) {
        BlockPos.MutableBlockPos mutableWaterCheck = new BlockPos.MutableBlockPos();
        ChunkPos currentChunkPos2 = new ChunkPos((BlockPos)mutable);
        ChunkAccess currentChunk2 = world.m_6325_(currentChunkPos2.f_45578_, currentChunkPos2.f_45579_);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP) continue;
            mutableWaterCheck.m_122190_((Vec3i)mutable).m_122173_(direction);
            if (currentChunkPos2.f_45578_ != mutableWaterCheck.m_123341_() >> 4 || currentChunkPos2.f_45579_ != mutableWaterCheck.m_123343_() >> 4) {
                currentChunk2 = world.m_46865_((BlockPos)mutableWaterCheck);
                currentChunkPos2 = new ChunkPos((BlockPos)mutableWaterCheck);
            }
            if (!currentChunk2.m_8055_((BlockPos)mutableWaterCheck).m_60795_()) continue;
            return true;
        }
        return false;
    }
}

