/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.storage;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.IStorageProvider;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.IStorageScreen;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.FluidStorageCache;
import com.refinedmods.refinedstorage.blockentity.FluidStorageBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.util.AccessTypeUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidStorageNetworkNode
extends NetworkNode
implements IStorageScreen,
IStorageProvider,
IComparable,
IWhitelistBlacklist,
IPrioritizable,
IAccessType,
IStorageDiskContainerContext {
    public static final ResourceLocation SIXTY_FOUR_K_FLUID_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "64k_fluid_storage_block");
    public static final ResourceLocation TWO_HUNDRED_FIFTY_SIX_K_FLUID_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "256k_fluid_storage_block");
    public static final ResourceLocation THOUSAND_TWENTY_FOUR_K_FLUID_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "1024k_fluid_storage_block");
    public static final ResourceLocation FOUR_THOUSAND_NINETY_SIX_K_FLUID_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "4096k_fluid_storage_block");
    public static final ResourceLocation CREATIVE_FLUID_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "creative_fluid_storage_block");
    public static final String NBT_ID = "Id";
    private static final Logger LOGGER = LogManager.getLogger(FluidStorageNetworkNode.class);
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_FILTERS = "Filters";
    private final FluidInventory filters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final FluidStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 1;
    private int mode = 1;
    private UUID storageId = UUID.randomUUID();
    private IStorageDisk<FluidStack> storage;

    public FluidStorageNetworkNode(Level level, BlockPos pos, FluidStorageType type) {
        super(level, pos);
        this.type = type;
    }

    public static ResourceLocation getId(FluidStorageType type) {
        switch (type) {
            case SIXTY_FOUR_K: {
                return SIXTY_FOUR_K_FLUID_STORAGE_BLOCK_ID;
            }
            case TWO_HUNDRED_FIFTY_SIX_K: {
                return TWO_HUNDRED_FIFTY_SIX_K_FLUID_STORAGE_BLOCK_ID;
            }
            case THOUSAND_TWENTY_FOUR_K: {
                return THOUSAND_TWENTY_FOUR_K_FLUID_STORAGE_BLOCK_ID;
            }
            case FOUR_THOUSAND_NINETY_SIX_K: {
                return FOUR_THOUSAND_NINETY_SIX_K_FLUID_STORAGE_BLOCK_ID;
            }
            case CREATIVE: {
                return CREATIVE_FLUID_STORAGE_BLOCK_ID;
            }
        }
        throw new IllegalArgumentException("Unknown storage type " + type);
    }

    @Override
    public int getEnergyUsage() {
        switch (this.type) {
            case SIXTY_FOUR_K: {
                return RS.SERVER_CONFIG.getFluidStorageBlock().getSixtyFourKUsage();
            }
            case TWO_HUNDRED_FIFTY_SIX_K: {
                return RS.SERVER_CONFIG.getFluidStorageBlock().getTwoHundredFiftySixKUsage();
            }
            case THOUSAND_TWENTY_FOUR_K: {
                return RS.SERVER_CONFIG.getFluidStorageBlock().getThousandTwentyFourKUsage();
            }
            case FOUR_THOUSAND_NINETY_SIX_K: {
                return RS.SERVER_CONFIG.getFluidStorageBlock().getFourThousandNinetySixKUsage();
            }
            case CREATIVE: {
                return RS.SERVER_CONFIG.getFluidStorageBlock().getCreativeUsage();
            }
        }
        return 0;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        LOGGER.debug("Connectivity state of fluid storage block at {} changed to {} due to {}", (Object)this.pos, (Object)state, (Object)cause);
        network.getNodeGraph().runActionWhenPossible(FluidStorageCache.INVALIDATE_ACTION.apply(InvalidateCause.CONNECTED_STATE_CHANGED));
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add(this.storage);
    }

    @Override
    public ResourceLocation getId() {
        return FluidStorageNetworkNode.getId(this.type);
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128362_(NBT_ID, this.storageId);
        return tag;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128403_(NBT_ID)) {
            this.storageId = tag.m_128342_(NBT_ID);
            this.loadStorage(null);
        }
    }

    public void loadStorage(@Nullable Player owner) {
        IStorageDisk<FluidStack> disk = API.instance().getStorageDiskManager((ServerLevel)this.level).get(this.storageId);
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk((ServerLevel)this.level, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerLevel)this.level).set(this.storageId, disk);
            API.instance().getStorageDiskManager((ServerLevel)this.level).markForSaving();
        }
        this.storage = new FluidStorageWrapperStorageDisk(this, disk);
    }

    public UUID getStorageId() {
        return this.storageId;
    }

    public void setStorageId(UUID id) {
        this.storageId = id;
        this.markDirty();
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128365_(NBT_FILTERS, (Tag)this.filters.writeToNbt());
        tag.m_128405_(NBT_PRIORITY, this.priority);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_FILTERS)) {
            this.filters.readFromNbt(tag.m_128469_(NBT_FILTERS));
        }
        if (tag.m_128441_(NBT_PRIORITY)) {
            this.priority = tag.m_128451_(NBT_PRIORITY);
        }
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public FluidInventory getFilters() {
        return this.filters;
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)("block.refinedstorage." + this.type.getName() + "_fluid_storage_block"));
    }

    @Override
    public long getStored() {
        return FluidStorageBlockEntity.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return this.type.getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getFluidStorageCache().sort();
        }
    }
}

