/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkManager;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.apiimpl.util.RSSavedData;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends RSSavedData
implements INetworkManager {
    public static final String NAME = "refinedstorage_networks";
    private static final String NBT_NETWORKS = "Networks";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DATA = "Data";
    private static final String NBT_POS = "Pos";
    private final Level level;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ConcurrentHashMap<BlockPos, INetwork> networks = new ConcurrentHashMap();

    public NetworkManager(Level level) {
        this.level = level;
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.m_128441_(NBT_NETWORKS)) {
            ListTag networksTag = tag.m_128437_(NBT_NETWORKS, 10);
            this.networks.clear();
            for (int i = 0; i < networksTag.size(); ++i) {
                CompoundTag networkTag = networksTag.m_128728_(i);
                CompoundTag data = networkTag.m_128469_(NBT_DATA);
                BlockPos pos = BlockPos.m_122022_((long)networkTag.m_128454_(NBT_POS));
                int type = networkTag.m_128451_(NBT_TYPE);
                INetwork network = new Network(this.level, pos, NetworkType.values()[type]);
                try {
                    network = network.readFromNbt(data);
                }
                catch (Throwable t) {
                    this.logger.error("Error while reading network", t);
                }
                this.networks.put(pos, network);
            }
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (INetwork network : this.all()) {
            try {
                CompoundTag networkTag = new CompoundTag();
                networkTag.m_128356_(NBT_POS, network.getPosition().m_121878_());
                networkTag.m_128365_(NBT_DATA, (Tag)network.writeToNbt(new CompoundTag()));
                networkTag.m_128405_(NBT_TYPE, network.getType().ordinal());
                list.add((Object)networkTag);
            }
            catch (Throwable t) {
                this.logger.error("Error while saving network", t);
            }
        }
        tag.m_128365_(NBT_NETWORKS, (Tag)list);
        return tag;
    }

    @Override
    @Nullable
    public INetwork getNetwork(BlockPos pos) {
        return this.networks.get(pos);
    }

    @Override
    public void removeNetwork(BlockPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        this.networks.remove(pos);
    }

    @Override
    public void setNetwork(BlockPos pos, INetwork network) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        if (network == null) {
            throw new IllegalArgumentException("Network cannot be null");
        }
        this.networks.put(pos, network);
    }

    @Override
    public Collection<INetwork> all() {
        return this.networks.values();
    }

    @Override
    public void markForSaving() {
        this.m_77762_();
    }
}

