/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.IoUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingState;
import com.refinedmods.refinedstorage.apiimpl.util.FluidStackList;
import com.refinedmods.refinedstorage.apiimpl.util.ItemStackList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingNode
extends Node {
    private static final String NBT_ITEMS_RECEIVED = "ItemsReceived";
    private static final String NBT_FLUIDS_RECEIVED = "FluidsReceived";
    private static final String NBT_SINGLE_ITEM_SET_TO_REQUIRE = "SingleItemSetToRequire";
    private static final String NBT_SINGLE_FLUID_SET_TO_REQUIRE = "SingleFluidSetToRequire";
    private static final String NBT_STATE = "State";
    private final IStackList<ItemStack> singleItemSetToReceive = API.instance().createItemStackList();
    private final IStackList<FluidStack> singleFluidSetToReceive = API.instance().createFluidStackList();
    private IStackList<ItemStack> singleItemSetToRequire;
    private IStackList<FluidStack> singleFluidSetToRequire;
    private IStackList<ItemStack> itemsReceived = API.instance().createItemStackList();
    private IStackList<FluidStack> fluidsReceived = API.instance().createFluidStackList();
    private ProcessingState state = ProcessingState.READY;
    private int quantityFinished;

    public ProcessingNode(ICraftingPattern pattern, boolean root) {
        super(pattern, root);
        this.initSetsToReceive();
    }

    public ProcessingNode(INetwork network, CompoundTag tag) throws CraftingTaskReadException {
        super(network, tag);
        this.itemsReceived = SerializationUtil.readItemStackList(tag.m_128437_(NBT_ITEMS_RECEIVED, 10));
        this.fluidsReceived = SerializationUtil.readFluidStackList(tag.m_128437_(NBT_FLUIDS_RECEIVED, 10));
        this.singleItemSetToRequire = SerializationUtil.readItemStackList(tag.m_128437_(NBT_SINGLE_ITEM_SET_TO_REQUIRE, 10));
        this.singleFluidSetToRequire = SerializationUtil.readFluidStackList(tag.m_128437_(NBT_SINGLE_FLUID_SET_TO_REQUIRE, 10));
        this.state = ProcessingState.values()[tag.m_128451_(NBT_STATE)];
        this.initSetsToReceive();
    }

    private void initSetsToReceive() {
        for (ItemStack output : this.getPattern().getOutputs()) {
            this.singleItemSetToReceive.add(output, output.m_41613_());
        }
        for (ItemStack output : this.getPattern().getFluidOutputs()) {
            this.singleFluidSetToReceive.add((FluidStack)output, output.getAmount());
        }
    }

    @Override
    public void update(INetwork network, int ticks, NodeList nodes, IStorageDisk<ItemStack> internalStorage, IStorageDisk<FluidStack> internalFluidStorage, NodeListener listener) {
        if (this.getQuantity() <= 0) {
            if (this.totalQuantity == this.quantityFinished) {
                listener.onAllDone(this);
            }
            return;
        }
        boolean allLocked = true;
        boolean allMissingMachine = true;
        boolean allRejected = true;
        ProcessingState originalState = this.state;
        block0: for (ICraftingPatternContainer container : network.getCraftingManager().getAllContainers(this.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates(); ++i) {
                if (this.getQuantity() <= 0) {
                    return;
                }
                if (container.isLocked()) {
                    if (!allLocked) continue block0;
                    this.state = ProcessingState.LOCKED;
                    continue block0;
                }
                allLocked = false;
                if (!this.singleItemSetToRequire.isEmpty() && !container.hasConnectedInventory() || !this.singleFluidSetToRequire.isEmpty() && !container.hasConnectedFluidInventory()) {
                    if (!allMissingMachine) continue block0;
                    this.state = ProcessingState.MACHINE_NONE;
                    continue block0;
                }
                allMissingMachine = false;
                boolean hasAllRequirements = false;
                List<ItemStack> simulatedRequirements = this.requirements.getSingleItemRequirementSet(true);
                if (simulatedRequirements == null) {
                    return;
                }
                List<ItemStack> extractedItems = IoUtil.extractFromInternalItemStorage(simulatedRequirements, internalStorage, Action.SIMULATE);
                List<FluidStack> extractedFluids = null;
                if (extractedItems != null) {
                    List<FluidStack> simulatedFluidRequirements = this.requirements.getSingleFluidRequirementSet(true);
                    if (simulatedFluidRequirements == null) {
                        return;
                    }
                    extractedFluids = IoUtil.extractFromInternalFluidStorage(simulatedFluidRequirements, internalFluidStorage, Action.SIMULATE);
                    if (extractedFluids != null) {
                        hasAllRequirements = true;
                    }
                }
                boolean canInsertFullAmount = false;
                if (!hasAllRequirements) continue block0;
                canInsertFullAmount = container.insertItemsIntoInventory(extractedItems, Action.SIMULATE);
                if (canInsertFullAmount) {
                    canInsertFullAmount = container.insertFluidsIntoInventory(extractedFluids, Action.SIMULATE);
                }
                if (!canInsertFullAmount) {
                    if (!allRejected) continue block0;
                    this.state = ProcessingState.MACHINE_DOES_NOT_ACCEPT;
                    continue block0;
                }
                allRejected = false;
                this.state = ProcessingState.READY;
                List<ItemStack> actualRequirements = this.requirements.getSingleItemRequirementSet(false);
                if (actualRequirements == null) {
                    return;
                }
                extractedItems = IoUtil.extractFromInternalItemStorage(actualRequirements, internalStorage, Action.PERFORM);
                List<FluidStack> actualFluidRequirements = this.requirements.getSingleFluidRequirementSet(false);
                if (actualFluidRequirements == null) {
                    return;
                }
                extractedFluids = IoUtil.extractFromInternalFluidStorage(actualFluidRequirements, internalFluidStorage, Action.PERFORM);
                container.insertItemsIntoInventory(extractedItems, Action.PERFORM);
                container.insertFluidsIntoInventory(extractedFluids, Action.PERFORM);
                this.next();
                listener.onSingleDone(this);
                container.onUsedForProcessing();
            }
        }
        if (originalState != this.state) {
            network.getCraftingManager().onTaskChanged();
        }
    }

    public ProcessingState getState() {
        return this.state;
    }

    public IStackList<ItemStack> getSingleItemSetToReceive() {
        return this.singleItemSetToReceive;
    }

    public IStackList<FluidStack> getSingleFluidSetToReceive() {
        return this.singleFluidSetToReceive;
    }

    public IStackList<ItemStack> getSingleItemSetToRequire() {
        return this.singleItemSetToRequire;
    }

    public IStackList<FluidStack> getSingleFluidSetToRequire() {
        return this.singleFluidSetToRequire;
    }

    public int getNeeded(ItemStack stack) {
        return this.singleItemSetToReceive.getCount(stack) * this.totalQuantity - this.itemsReceived.getCount(stack);
    }

    public int getNeeded(FluidStack stack) {
        return this.singleFluidSetToReceive.getCount(stack) * this.totalQuantity - this.fluidsReceived.getCount(stack);
    }

    public int getCurrentlyProcessing() {
        int unprocessed = this.totalQuantity - this.quantity;
        return unprocessed - this.quantityFinished;
    }

    public void markReceived(ItemStack stack, int count) {
        this.itemsReceived.add(stack, count);
        this.updateFinishedQuantity();
    }

    public void markReceived(FluidStack stack, int count) {
        this.fluidsReceived.add(stack, count);
        this.updateFinishedQuantity();
    }

    public void updateFinishedQuantity() {
        int ratioReceived;
        int tempQuantityFinished = this.totalQuantity;
        for (StackListEntry<ItemStack> stackListEntry : this.singleItemSetToReceive.getStacks()) {
            if (this.itemsReceived.get(stackListEntry.getStack()) != null) {
                ratioReceived = this.itemsReceived.get(stackListEntry.getStack()).m_41613_() / stackListEntry.getStack().m_41613_();
                if (tempQuantityFinished <= ratioReceived) continue;
                tempQuantityFinished = ratioReceived;
                continue;
            }
            tempQuantityFinished = 0;
        }
        for (StackListEntry<ItemStack> stackListEntry : this.singleFluidSetToReceive.getStacks()) {
            if (this.fluidsReceived.get((FluidStack)stackListEntry.getStack()) != null) {
                ratioReceived = this.fluidsReceived.get((FluidStack)stackListEntry.getStack()).getAmount() / ((FluidStack)stackListEntry.getStack()).getAmount();
                if (tempQuantityFinished <= ratioReceived) continue;
                tempQuantityFinished = ratioReceived;
                continue;
            }
            tempQuantityFinished = 0;
        }
        this.quantityFinished = tempQuantityFinished;
    }

    @Override
    public void onCalculationFinished() {
        super.onCalculationFinished();
        this.singleItemSetToRequire = new ItemStackList(this.requirements.getSingleItemRequirementSet(true));
        this.singleFluidSetToRequire = new FluidStackList(this.requirements.getSingleFluidRequirementSet(true));
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = super.writeToNbt();
        tag.m_128365_(NBT_ITEMS_RECEIVED, (Tag)SerializationUtil.writeItemStackList(this.itemsReceived));
        tag.m_128365_(NBT_FLUIDS_RECEIVED, (Tag)SerializationUtil.writeFluidStackList(this.fluidsReceived));
        tag.m_128365_(NBT_SINGLE_ITEM_SET_TO_REQUIRE, (Tag)SerializationUtil.writeItemStackList(this.singleItemSetToRequire));
        tag.m_128365_(NBT_SINGLE_FLUID_SET_TO_REQUIRE, (Tag)SerializationUtil.writeFluidStackList(this.singleFluidSetToRequire));
        tag.m_128405_(NBT_STATE, this.state.ordinal());
        return tag;
    }
}

