/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class CommonConfig
implements ConfigCore {
    public double mutantCreeperSpawnWeight;
    public double mutantEndermanSpawnWeight;
    public double mutantSkeletonSpawnWeight;
    public double mutantZombieSpawnWeight;
    @Config(name="mutant_x_conversions", description={"When infested with a Mutant X potion, what mutant mob should the target transform into. Otherwise the target will ony explode and take damage.", "Format for every entry is \"<namespace>:<path>,<namespace>:<path>\" with the second id representing the mutant. Namespace may be omitted to use \"minecraft\" by default."})
    List<String> mutantXConversionsRaw = Lists.newArrayList((Object[])new String[]{"minecraft:creeper,mutantmonsters:mutant_creeper", "minecraft:enderman,mutantmonsters:mutant_enderman", "minecraft:skeleton,mutantmonsters:mutant_skeleton", "minecraft:snow_golem,mutantmonsters:mutant_snow_golem", "minecraft:zombie,mutantmonsters:mutant_zombie", "minecraft:pig,mutantmonsters:spider_pig"});
    public Map<EntityType<?>, EntityType<?>> mutantXConversions;

    public void addToBuilder(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Weight for mutant creeper spawns as a percentage of the vanilla creeper spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_creeper_spawn_weight", 0.05, 0.0, 20.0), v -> {
            this.mutantCreeperSpawnWeight = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Weight for mutant enderman spawns as a percentage of the vanilla enderman spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_enderman_spawn_weight", 0.05, 0.0, 20.0), v -> {
            this.mutantEndermanSpawnWeight = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Weight for mutant skeleton spawns as a percentage of the vanilla skeleton spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_skeleton_spawn_weight", 0.05, 0.0, 20.0), v -> {
            this.mutantSkeletonSpawnWeight = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Weight for mutant zombie spawns as a percentage of the vanilla zombie spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_zombie_spawn_weight", 0.05, 0.0, 20.0), v -> {
            this.mutantZombieSpawnWeight = v;
        });
    }

    public void afterConfigReload() {
        ConfigDataSet configDataSet = ConfigDataSet.from((ResourceKey)Registries.f_256939_, this.mutantXConversionsRaw, (integer, o) -> true, (Class[])new Class[]{String.class});
        record MutantXConversion(EntityType<?> entityType, @Nullable ResourceLocation convertsTo) {
            public boolean isValid() {
                if (this.convertsTo != null && BuiltInRegistries.f_256780_.m_7804_(this.convertsTo)) {
                    return true;
                }
                MutantMonsters.LOGGER.warn("Unable to parse mutated variant for entry {}", (Object)BuiltInRegistries.f_256780_.m_7981_(this.entityType));
                return false;
            }

            public EntityType<?> convertsToType() {
                return (EntityType)BuiltInRegistries.f_256780_.m_7745_(this.convertsTo);
            }
        }
        this.mutantXConversions = (Map)configDataSet.toMap().entrySet().stream().map(data -> new MutantXConversion((EntityType)data.getKey(), ResourceLocation.m_135820_((String)((String)((Object[])data.getValue())[0])))).filter(MutantXConversion::isValid).collect(ImmutableMap.toImmutableMap(MutantXConversion::entityType, MutantXConversion::convertsToType));
    }
}

