/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.google.common.base.Objects;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulCompass
extends ItemBase
implements ICursed {
    @OnlyIn(value=Dist.CLIENT)
    private CompassWobble wobble;
    @OnlyIn(value=Dist.CLIENT)
    private CompassWobble wobbleRandom;
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private BlockPos nearestCrystal;

    public SoulCompass() {
        super(SoulCompass.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41486_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setNearestCrystal(BlockPos nearestCrystal) {
        if (!Objects.equal((Object)this.nearestCrystal, (Object)nearestCrystal)) {
            if (nearestCrystal != null && this.nearestCrystal != null) {
                this.wobble.rotation = 1.0;
                this.wobble.deltaRotation = 0.3;
            } else {
                this.wobble.rotation = this.wobbleRandom.rotation;
                this.wobble.deltaRotation = this.wobbleRandom.deltaRotation;
            }
            this.nearestCrystal = nearestCrystal;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAngle(BlockPos one, BlockPos two) {
        float angle = (float)Math.toDegrees(Math.atan2(one.m_123343_() - two.m_123343_(), one.m_123341_() - two.m_123341_()));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.soulCompass1");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerVariants() {
        this.wobble = new CompassWobble(0.1);
        this.wobbleRandom = new CompassWobble(0.6);
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private final CompassWobble wobble;
            private final CompassWobble wobbleRandom;
            {
                this.wobble = SoulCompass.this.wobble;
                this.wobbleRandom = SoulCompass.this.wobbleRandom;
            }

            public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity living, int seed) {
                LivingEntity entity;
                Object object = entity = living != null ? living : stack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (level == null && entity.m_9236_() instanceof ClientLevel) {
                    level = (ClientLevel)entity.m_9236_();
                }
                assert (level != null);
                BlockPos target = this.getTargetPosition();
                long gameTime = level.m_46467_();
                if (target != null && !(entity.m_20182_().m_82531_((double)target.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)target.m_123343_() + 0.5) < (double)1.0E-5f)) {
                    boolean isLocalPlayer = living instanceof Player && ((Player)living).m_7578_();
                    double bodyRotation = 0.0;
                    if (isLocalPlayer) {
                        assert (living != null);
                    } else {
                        return this.randomAngle(gameTime, seed);
                    }
                    bodyRotation = living.m_146908_();
                    if (!SuperpositionHandler.isTheCursedOne((Player)living) || !SuperpositionHandler.hasExactStack((Player)living, stack) || level.m_204166_(living.m_20183_()).m_203565_(Biomes.f_48199_)) {
                        return this.randomAngle(gameTime, seed);
                    }
                    bodyRotation = Mth.m_14109_((double)(bodyRotation / 360.0), (double)1.0);
                    double angle = SoulCompass.this.getAngleTo(Vec3.m_82512_((Vec3i)target), (Entity)entity) / 6.2831854820251465;
                    if (this.wobble.shouldUpdate(gameTime)) {
                        this.wobble.update(gameTime, 0.5 - (bodyRotation - 0.25));
                    }
                    double otherAngle = angle + this.wobble.rotation;
                    return Mth.m_14091_((float)((float)otherAngle), (float)1.0f);
                }
                return this.randomAngle(gameTime, seed);
            }

            private float randomAngle(long gameTime, int seed) {
                if (this.wobbleRandom.shouldUpdate(gameTime)) {
                    this.wobbleRandom.update(gameTime, Math.random());
                }
                double randomAngle = this.wobbleRandom.rotation + (double)((float)this.hash(seed) / 2.1474836E9f);
                return Mth.m_14091_((float)((float)randomAngle), (float)1.0f);
            }

            private int hash(int value) {
                return value * 1327217883;
            }

            @Nullable
            private BlockPos getTargetPosition() {
                return SoulCompass.this.nearestCrystal;
            }

            @Nullable
            private BlockPos getSpawnPosition(ClientLevel level) {
                return level.m_6042_().f_63858_() ? level.m_220360_() : null;
            }

            @Nullable
            private BlockPos getLodestonePosition(Level level, CompoundTag tag) {
                Optional optional;
                boolean flag = tag.m_128441_("LodestonePos");
                boolean flag1 = tag.m_128441_("LodestoneDimension");
                if (flag && flag1 && (optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("LodestoneDimension")).result()).isPresent() && level.m_46472_() == optional.get()) {
                    return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LodestonePos"));
                }
                return null;
            }

            private double getFrameRotation(ItemFrame frame) {
                Direction direction = frame.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + frame.m_31823_() * 45 + i));
            }
        });
    }

    private double getAngleTo(Vec3 pos, Entity entity) {
        return Math.atan2(pos.m_7094_() - entity.m_20189_(), pos.m_7096_() - entity.m_20185_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CompassWobble {
        double needleMobility;
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble(double needleMobility) {
            this.needleMobility = needleMobility;
        }

        boolean shouldUpdate(long pGameTime) {
            return this.lastUpdateTick != pGameTime;
        }

        void update(long gameTime, double wobbleAmount) {
            this.lastUpdateTick = gameTime;
            double var = wobbleAmount - this.rotation;
            var = Mth.m_14109_((double)(var + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += var * this.needleMobility;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

