/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonConfigHandler {
    @Nullable
    public static File getConfigFile() {
        try {
            return new File(FMLPaths.CONFIGDIR.get().toFile().getCanonicalFile(), "config.json");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getInt(String key) {
        return (int)JsonConfigHandler.getFloat(key);
    }

    public static float getFloat(String key) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)Objects.requireNonNull(new FileInputStream(JsonConfigHandler.getConfigFile())), StandardCharsets.UTF_8);
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            HashMap panelsParameters = (HashMap)gson.fromJson((Reader)reader, HashMap.class);
            if (panelsParameters.containsKey(key)) {
                return (float)((Double)panelsParameters.get(key)).doubleValue();
            }
            return 0.0f;
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    public static String getString(String key) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)Objects.requireNonNull(new FileInputStream(JsonConfigHandler.getConfigFile())), StandardCharsets.UTF_8);
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            HashMap panelsParameters = (HashMap)gson.fromJson((Reader)reader, HashMap.class);
            if (panelsParameters.containsKey(key)) {
                return (String)panelsParameters.get(key);
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }
}

