/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.util.Pools;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DirectedAcyclicGraph<T> {
    private final Pools.Pool<ArrayList<T>> mListPool = Pools.newSimplePool(10);
    private final Object2ObjectOpenHashMap<T, ArrayList<T>> mGraph = new Object2ObjectOpenHashMap();
    private final ArrayList<T> mSortResult = new ArrayList();
    private final HashSet<T> mSortTmpMarked = new HashSet();

    DirectedAcyclicGraph() {
    }

    public void addNode(@Nonnull T node) {
        if (!this.mGraph.containsKey(node)) {
            this.mGraph.put(node, null);
        }
    }

    public boolean contains(@Nonnull T node) {
        return this.mGraph.containsKey(node);
    }

    public void addEdge(@Nonnull T node, @Nonnull T incomingEdge) {
        if (!this.mGraph.containsKey(node) || !this.mGraph.containsKey(incomingEdge)) {
            throw new IllegalArgumentException("All nodes must be present in the graph before being added as an edge");
        }
        ArrayList<T> edges = (ArrayList<T>)this.mGraph.get(node);
        if (edges == null) {
            edges = this.getEmptyList();
            this.mGraph.put(node, edges);
        }
        edges.add(incomingEdge);
    }

    @Nullable
    public List<T> getIncomingEdges(@Nonnull T node) {
        ArrayList<T> result = this.getIncomingEdgesInternal(node);
        if (result == null) {
            return null;
        }
        return new ArrayList<T>(result);
    }

    @Nullable
    ArrayList<T> getIncomingEdgesInternal(@Nonnull T node) {
        return (ArrayList)this.mGraph.get(node);
    }

    @Nullable
    public List<T> getOutgoingEdges(@Nonnull T node) {
        ArrayList<Object> result = null;
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.mGraph)) {
            ArrayList edges = (ArrayList)entry.getValue();
            if (edges == null || !edges.contains(node)) continue;
            if (result == null) {
                result = new ArrayList<Object>();
            }
            result.add(entry.getKey());
        }
        return result;
    }

    public boolean hasOutgoingEdges(@Nonnull T node) {
        for (ArrayList edges : this.mGraph.values()) {
            if (edges == null || !edges.contains(node)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (ArrayList edges : this.mGraph.values()) {
            if (edges == null) continue;
            this.poolList(edges);
        }
        this.mGraph.clear();
    }

    @Nonnull
    public ArrayList<T> getSortedList() {
        this.mSortResult.clear();
        this.mSortTmpMarked.clear();
        for (Object key : this.mGraph.keySet()) {
            this.dfs(key, this.mSortResult, this.mSortTmpMarked);
        }
        return this.mSortResult;
    }

    private void dfs(T node, @Nonnull ArrayList<T> result, HashSet<T> tmpMarked) {
        if (result.contains(node)) {
            return;
        }
        if (tmpMarked.contains(node)) {
            throw new RuntimeException("This graph contains cyclic dependencies");
        }
        tmpMarked.add(node);
        ArrayList edges = (ArrayList)this.mGraph.get(node);
        if (edges != null) {
            for (Object edge : edges) {
                this.dfs(edge, result, tmpMarked);
            }
        }
        tmpMarked.remove(node);
        result.add(node);
    }

    int size() {
        return this.mGraph.size();
    }

    @Nonnull
    private ArrayList<T> getEmptyList() {
        ArrayList<Object> list = this.mListPool.acquire();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private void poolList(@Nonnull ArrayList<T> list) {
        list.clear();
        this.mListPool.release(list);
    }
}

