/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.util.Pools;
import icyllis.modernui.view.MotionEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VelocityTracker {
    private static final Pools.Pool<VelocityTracker> sPool = Pools.newSynchronizedPool(2);
    private static final long ASSUME_POINTER_STOPPED_TIME = 40000000L;
    public static final int VELOCITY_TRACKER_STRATEGY_DEFAULT = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_IMPULSE = 0;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ1 = 1;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ2 = 2;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ3 = 3;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_DELTA = 4;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_CENTRAL = 5;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_RECENT = 6;
    private final int mStrategyId;
    private long mLastEventTime;
    private float mVelocityX;
    private float mVelocityY;
    private final Strategy mStrategy;
    private final Estimator mEstimator = new Estimator();

    private VelocityTracker(int strategy) {
        this.mStrategyId = strategy;
        if (strategy == -1) {
            strategy = 2;
        }
        this.mStrategy = switch (strategy) {
            case 0 -> new ImpulseStrategy();
            case 1 -> new LeastSquaresStrategy(1);
            case 2 -> new LeastSquaresStrategy(2);
            case 3 -> new LeastSquaresStrategy(3);
            case 4 -> new LeastSquaresStrategy(2, LeastSquaresStrategy.Weighting.WEIGHTING_DELTA);
            case 5 -> new LeastSquaresStrategy(2, LeastSquaresStrategy.Weighting.WEIGHTING_CENTRAL);
            case 6 -> new LeastSquaresStrategy(2, LeastSquaresStrategy.Weighting.WEIGHTING_RECENT);
            default -> throw new IllegalStateException("Unexpected value: " + strategy);
        };
    }

    @NonNull
    public static VelocityTracker obtain() {
        VelocityTracker instance = sPool.acquire();
        return instance != null ? instance : new VelocityTracker(-1);
    }

    @NonNull
    public static VelocityTracker obtain(int strategy) {
        return new VelocityTracker(strategy);
    }

    public void recycle() {
        if (this.mStrategyId == -1) {
            this.clear();
            sPool.release(this);
        }
    }

    public int getStrategyId() {
        return this.mStrategyId;
    }

    public void clear() {
        this.mVelocityX = 0.0f;
        this.mVelocityY = 0.0f;
        this.mStrategy.clear();
        this.mEstimator.clear();
    }

    public void addMovement(@NonNull MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 9: {
                this.clear();
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            default: {
                return;
            }
        }
        long eventTime = event.getEventTimeNano();
        if (eventTime - this.mLastEventTime >= 40000000L) {
            this.mStrategy.clear();
        }
        this.mLastEventTime = eventTime;
        this.mStrategy.addMovement(eventTime, event.getX(), event.getY());
    }

    public boolean computeCurrentVelocity(int units) {
        if (this.mStrategy.getEstimator(this.mEstimator) && this.mEstimator.degree >= 1) {
            float vx = this.mEstimator.xCoeff[1];
            float vy = this.mEstimator.yCoeff[1];
            this.mVelocityX = vx * (float)units / 1000.0f;
            this.mVelocityY = vy * (float)units / 1000.0f;
            return true;
        }
        this.mVelocityX = 0.0f;
        this.mVelocityY = 0.0f;
        return false;
    }

    public boolean computeCurrentVelocity(int units, float maxVelocity) {
        if (this.mStrategy.getEstimator(this.mEstimator) && this.mEstimator.degree >= 1) {
            float vx = this.mEstimator.xCoeff[1];
            float vy = this.mEstimator.yCoeff[1];
            this.mVelocityX = Math.max(Math.min(vx * (float)units / 1000.0f, maxVelocity), -maxVelocity);
            this.mVelocityY = Math.max(Math.min(vy * (float)units / 1000.0f, maxVelocity), -maxVelocity);
            return true;
        }
        this.mVelocityX = 0.0f;
        this.mVelocityY = 0.0f;
        return false;
    }

    public float getXVelocity() {
        return this.mVelocityX;
    }

    public float getYVelocity() {
        return this.mVelocityY;
    }

    @ApiStatus.Internal
    public boolean getEstimator(@NonNull Estimator outEstimator) {
        return this.mStrategy.getEstimator(outEstimator);
    }

    @ApiStatus.Internal
    public static final class Estimator {
        private static final int MAX_DEGREE = 4;
        public long time;
        public final float[] xCoeff = new float[5];
        public final float[] yCoeff = new float[5];
        public int degree;
        public float confidence;

        public float estimateX(float time) {
            return this.estimate(time, this.xCoeff);
        }

        public float estimateY(float time) {
            return this.estimate(time, this.yCoeff);
        }

        public float getXCoeff(int index) {
            return index <= this.degree ? this.xCoeff[index] : 0.0f;
        }

        public float getYCoeff(int index) {
            return index <= this.degree ? this.yCoeff[index] : 0.0f;
        }

        public void clear() {
            this.time = 0L;
            this.degree = 0;
            this.confidence = 0.0f;
            for (int i = 0; i <= 4; ++i) {
                this.xCoeff[i] = 0.0f;
                this.yCoeff[i] = 0.0f;
            }
        }

        private float estimate(float time, float[] c) {
            float a = 0.0f;
            float scale = 1.0f;
            for (int i = 0; i <= this.degree; ++i) {
                a += c[i] * scale;
                scale *= time;
            }
            return a;
        }
    }

    public static class ImpulseStrategy
    extends CommonStrategy {
        final long[] mTmpTime = new long[20];

        static float kineticEnergyToVelocity(float work) {
            return (float)((work < 0.0f ? -1.0 : 1.0) * Math.sqrt(Math.abs(work)) * 1.41421356237);
        }

        static float calculateImpulseVelocity(long[] t, float[] v, int count) {
            if (count < 2) {
                return 0.0f;
            }
            assert (t[1] <= t[0]);
            if (count == 2) {
                if (t[1] == t[0]) {
                    return 0.0f;
                }
                return (v[1] - v[0]) / (1.0E-9f * (float)(t[1] - t[0]));
            }
            float work = 0.0f;
            for (int i = count - 1; i > 0; --i) {
                if (t[i] == t[i - 1]) continue;
                float vPrev = ImpulseStrategy.kineticEnergyToVelocity(work);
                float vCurr = (v[i] - v[i - 1]) / (1.0E-9f * (float)(t[i] - t[i - 1]));
                work += (vCurr - vPrev) * Math.abs(vCurr);
                if (i != count - 1) continue;
                work = (float)((double)work * 0.5);
            }
            return ImpulseStrategy.kineticEnergyToVelocity(work);
        }

        @Override
        public boolean getEstimator(@NonNull Estimator outEstimator) {
            long time;
            long age;
            outEstimator.clear();
            int m = 0;
            int index = this.mIndex;
            long newestTime = this.mEventTime[this.mIndex];
            while ((age = newestTime - (time = this.mEventTime[index])) <= 100000000L) {
                this.mTmpX[m] = this.mX[index];
                this.mTmpY[m] = this.mY[index];
                this.mTmpTime[m] = time;
                index = (index == 0 ? 20 : index) - 1;
                if (++m < 20) continue;
            }
            if (m == 0) {
                return false;
            }
            outEstimator.xCoeff[0] = 0.0f;
            outEstimator.yCoeff[0] = 0.0f;
            outEstimator.xCoeff[1] = ImpulseStrategy.calculateImpulseVelocity(this.mTmpTime, this.mTmpX, m);
            outEstimator.yCoeff[1] = ImpulseStrategy.calculateImpulseVelocity(this.mTmpTime, this.mTmpY, m);
            outEstimator.xCoeff[2] = 0.0f;
            outEstimator.yCoeff[2] = 0.0f;
            outEstimator.time = newestTime;
            outEstimator.degree = 2;
            outEstimator.confidence = 1.0f;
            return true;
        }
    }

    public static class LeastSquaresStrategy
    extends CommonStrategy {
        final int mDegree;
        final Weighting mWeighting;
        final float[] mTmpW = new float[20];
        final float[] mTmpTime = new float[20];
        final float[] mTmpXCoeff = new float[3];
        final float[] mTmpYCoeff = new float[3];

        public LeastSquaresStrategy(int degree) {
            this(degree, Weighting.WEIGHTING_NONE);
        }

        public LeastSquaresStrategy(int degree, Weighting weighting) {
            this.mDegree = degree;
            this.mWeighting = weighting;
        }

        static float vectorDot(float[] a, float[] b, int m) {
            float r = 0.0f;
            for (int i = 0; i < m; ++i) {
                r += a[i] * b[i];
            }
            return r;
        }

        static float vectorNorm(float[] a, int m) {
            float r = 0.0f;
            for (int i = 0; i < m; ++i) {
                float t = a[i];
                r += t * t;
            }
            return (float)Math.sqrt(r);
        }

        @ApiStatus.Experimental
        static float solveLeastSquares(float[] t, float[] v, float[] w, int m, int n, float[] outB) {
            float[][] a = new float[n][m];
            for (int h = 0; h < m; ++h) {
                a[0][h] = w[h];
                for (int i = 1; i < n; ++i) {
                    a[i][h] = a[i - 1][h] * t[h];
                }
            }
            float[][] q = new float[n][m];
            float[][] r = new float[n][n];
            for (int j = 0; j < n; ++j) {
                int h;
                System.arraycopy(a[j], 0, q[j], 0, m);
                for (int i = 0; i < j; ++i) {
                    float dot = LeastSquaresStrategy.vectorDot(q[j], q[i], m);
                    for (h = 0; h < m; ++h) {
                        float[] fArray = q[j];
                        int n2 = h;
                        fArray[n2] = fArray[n2] - dot * q[i][h];
                    }
                }
                float norm = LeastSquaresStrategy.vectorNorm(q[j], m);
                if (norm < 1.0E-6f) {
                    return Float.NaN;
                }
                float invNorm = 1.0f / norm;
                h = 0;
                while (h < m) {
                    float[] fArray = q[j];
                    int n3 = h++;
                    fArray[n3] = fArray[n3] * invNorm;
                }
                for (int i = 0; i < n; ++i) {
                    r[j][i] = i < j ? 0.0f : LeastSquaresStrategy.vectorDot(q[j], a[i], m);
                }
            }
            float[] wy = new float[m];
            for (int h = 0; h < m; ++h) {
                wy[h] = v[h] * w[h];
            }
            int i = n;
            while (i != 0) {
                outB[--i] = LeastSquaresStrategy.vectorDot(q[i], wy, m);
                for (int j = n - 1; j > i; --j) {
                    int n4 = i;
                    outB[n4] = outB[n4] - r[i][j] * outB[j];
                }
                int n5 = i;
                outB[n5] = outB[n5] / r[i][i];
            }
            float ymean = 0.0f;
            for (int h = 0; h < m; ++h) {
                ymean += v[h];
            }
            ymean /= (float)m;
            float sserr = 0.0f;
            float sstot = 0.0f;
            for (int h = 0; h < m; ++h) {
                float err = v[h] - outB[0];
                float term = 1.0f;
                for (int i2 = 1; i2 < n; ++i2) {
                    err -= (term *= t[h]) * outB[i2];
                }
                sserr += w[h] * w[h] * err * err;
                float var = v[h] - ymean;
                sstot += w[h] * w[h] * var * var;
            }
            return sstot > 1.0E-6f ? 1.0f - sserr / sstot : 1.0f;
        }

        static boolean solveUnweightedLeastSquaresDeg2(float[] t, float[] v, int count, float[] out) {
            float c;
            float sxi = 0.0f;
            float sxiyi = 0.0f;
            float syi = 0.0f;
            float sxi2 = 0.0f;
            float sxi3 = 0.0f;
            float sxi2yi = 0.0f;
            float sxi4 = 0.0f;
            for (int i = 0; i < count; ++i) {
                float xi = t[i];
                float yi = v[i];
                float xi2 = xi * xi;
                float xi3 = xi2 * xi;
                float xi4 = xi3 * xi;
                float xiyi = xi * yi;
                float xi2yi = xi2 * yi;
                sxi += xi;
                sxi2 += xi2;
                sxiyi += xiyi;
                sxi2yi += xi2yi;
                syi += yi;
                sxi3 += xi3;
                sxi4 += xi4;
            }
            float Sxx = sxi2 - sxi * sxi / (float)count;
            float Sxy = sxiyi - sxi * syi / (float)count;
            float Sxx2 = sxi3 - sxi * sxi2 / (float)count;
            float Sx2y = sxi2yi - sxi2 * syi / (float)count;
            float Sx2x2 = sxi4 - sxi2 * sxi2 / (float)count;
            float denominator = Sxx * Sx2x2 - Sxx2 * Sxx2;
            if (denominator == 0.0f) {
                return false;
            }
            float numerator = Sx2y * Sxx - Sxy * Sxx2;
            float a = numerator / denominator;
            numerator = Sxy * Sx2x2 - Sx2y * Sxx2;
            float b = numerator / denominator;
            out[0] = c = syi / (float)count - b * sxi / (float)count - a * sxi2 / (float)count;
            out[1] = b;
            out[2] = a;
            return true;
        }

        @Override
        public boolean getEstimator(@NonNull Estimator outEstimator) {
            long time;
            long age;
            outEstimator.clear();
            int m = 0;
            int index = this.mIndex;
            long newestTime = this.mEventTime[this.mIndex];
            while ((age = newestTime - (time = this.mEventTime[index])) <= 100000000L) {
                this.mTmpX[m] = this.mX[index];
                this.mTmpY[m] = this.mY[index];
                this.mTmpW[m] = this.chooseWeight(index);
                this.mTmpTime[m] = (float)(-age) * 1.0E-9f;
                index = (index == 0 ? 20 : index) - 1;
                if (++m < 20) continue;
            }
            if (m == 0) {
                return false;
            }
            int degree = this.mDegree;
            if (degree > m - 1) {
                degree = m - 1;
            }
            if (degree == 2 && this.mWeighting == Weighting.WEIGHTING_NONE) {
                boolean xCoeff = LeastSquaresStrategy.solveUnweightedLeastSquaresDeg2(this.mTmpTime, this.mTmpX, m, this.mTmpXCoeff);
                boolean yCoeff = LeastSquaresStrategy.solveUnweightedLeastSquaresDeg2(this.mTmpTime, this.mTmpY, m, this.mTmpYCoeff);
                if (xCoeff && yCoeff) {
                    outEstimator.time = newestTime;
                    outEstimator.degree = 2;
                    outEstimator.confidence = 1.0f;
                    for (int i = 0; i <= outEstimator.degree; ++i) {
                        outEstimator.xCoeff[i] = this.mTmpXCoeff[i];
                        outEstimator.yCoeff[i] = this.mTmpYCoeff[i];
                    }
                    return true;
                }
            } else if (degree >= 1) {
                int n = degree + 1;
                float xDet = LeastSquaresStrategy.solveLeastSquares(this.mTmpTime, this.mTmpX, this.mTmpW, m, n, outEstimator.xCoeff);
                float yDet = LeastSquaresStrategy.solveLeastSquares(this.mTmpTime, this.mTmpY, this.mTmpW, m, n, outEstimator.yCoeff);
                if (!Float.isNaN(xDet) && !Float.isNaN(yDet)) {
                    outEstimator.time = newestTime;
                    outEstimator.degree = degree;
                    outEstimator.confidence = xDet * yDet;
                    return true;
                }
            }
            outEstimator.xCoeff[0] = this.mTmpX[0];
            outEstimator.yCoeff[0] = this.mTmpY[0];
            outEstimator.time = newestTime;
            outEstimator.degree = 0;
            outEstimator.confidence = 1.0f;
            return true;
        }

        private float chooseWeight(int index) {
            return switch (this.mWeighting) {
                case Weighting.WEIGHTING_DELTA -> {
                    if (index == this.mIndex) {
                        yield 1.0f;
                    }
                    int nextIndex = (index + 1) % 20;
                    float deltaMillis = (float)(this.mEventTime[nextIndex] - this.mEventTime[index]) * 1.0E-6f;
                    if (deltaMillis < 0.0f) {
                        yield 0.5f;
                    }
                    if (deltaMillis < 10.0f) {
                        yield 0.5f + deltaMillis * 0.05f;
                    }
                    yield 1.0f;
                }
                case Weighting.WEIGHTING_CENTRAL -> {
                    float ageMillis = (float)(this.mEventTime[this.mIndex] - this.mEventTime[index]) * 1.0E-6f;
                    if (ageMillis < 0.0f) {
                        yield 0.5f;
                    }
                    if (ageMillis < 10.0f) {
                        yield 0.5f + ageMillis * 0.05f;
                    }
                    if (ageMillis < 50.0f) {
                        yield 1.0f;
                    }
                    if (ageMillis < 60.0f) {
                        yield 0.5f + (60.0f - ageMillis) * 0.05f;
                    }
                    yield 0.5f;
                }
                case Weighting.WEIGHTING_RECENT -> {
                    float ageMillis = (float)(this.mEventTime[this.mIndex] - this.mEventTime[index]) * 1.0E-6f;
                    if (ageMillis < 50.0f) {
                        yield 1.0f;
                    }
                    if (ageMillis < 100.0f) {
                        yield 0.5f + (100.0f - ageMillis) * 0.01f;
                    }
                    yield 0.5f;
                }
                default -> 1.0f;
            };
        }

        public static enum Weighting {
            WEIGHTING_NONE,
            WEIGHTING_DELTA,
            WEIGHTING_CENTRAL,
            WEIGHTING_RECENT;

        }
    }

    public static interface Strategy {
        public void clear();

        public void addMovement(long var1, float var3, float var4);

        public boolean getEstimator(@NonNull Estimator var1);
    }

    static abstract class CommonStrategy
    implements Strategy {
        static final int HORIZON = 100000000;
        static final int HISTORY_SIZE = 20;
        int mIndex;
        final long[] mEventTime = new long[20];
        final float[] mX = new float[20];
        final float[] mY = new float[20];
        final float[] mTmpX = new float[20];
        final float[] mTmpY = new float[20];

        CommonStrategy() {
            this.clear();
        }

        @Override
        public void clear() {
            this.mIndex = 0;
        }

        @Override
        public void addMovement(long eventTime, float x, float y) {
            if (this.mEventTime[this.mIndex] != eventTime) {
                ++this.mIndex;
            }
            if (this.mIndex == 20) {
                this.mIndex = 0;
            }
            this.mEventTime[this.mIndex] = eventTime;
            this.mX[this.mIndex] = x;
            this.mY[this.mIndex] = y;
        }
    }
}

