/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import java.util.Objects;

public final class Pools {
    private Pools() {
    }

    @NonNull
    public static <T> Pool<T> newSimplePool(int maxPoolSize) {
        return new SimplePool(maxPoolSize);
    }

    @NonNull
    public static <T> Pool<T> newSynchronizedPool(int maxPoolSize) {
        return new SynchronizedPool(maxPoolSize);
    }

    @NonNull
    public static <T> Pool<T> newSynchronizedPool(int maxPoolSize, @NonNull Object lock) {
        return new SynchronizedPool(maxPoolSize, lock);
    }

    public static class SimplePool<T>
    implements Pool<T> {
        private final T[] mPool;
        private int mPoolSize;

        public SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        @Nullable
        public T acquire() {
            if (this.mPoolSize == 0) {
                return null;
            }
            int i = --this.mPoolSize;
            T instance = this.mPool[i];
            this.mPool[i] = null;
            return instance;
        }

        @Override
        public boolean release(@NonNull T instance) {
            if (this.mPoolSize == this.mPool.length) {
                return false;
            }
            for (int i = this.mPoolSize - 1; i >= 0; --i) {
                if (this.mPool[i] != instance) continue;
                throw new IllegalStateException("Already in the pool!");
            }
            this.mPool[this.mPoolSize++] = instance;
            return true;
        }
    }

    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock;

        public SynchronizedPool(int maxPoolSize) {
            super(maxPoolSize);
            this.mLock = this;
        }

        public SynchronizedPool(int maxPoolSize, @NonNull Object lock) {
            super(maxPoolSize);
            this.mLock = Objects.requireNonNull(lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(@NonNull T element) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(element);
            }
        }
    }

    public static interface Pool<T> {
        @Nullable
        public T acquire();

        public boolean release(@NonNull T var1);
    }
}

