/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.util.HeadPadding;
import icyllis.modernui.util.L2Padding;
import icyllis.modernui.util.Pools;
import icyllis.modernui.util.TailPadding;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MpmcArrayQueue<E>
extends L2Padding<E>
implements Pools.Pool<E> {
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle SEQ;
    private static final long MAX_SEQ = 0x4000000000000000L;
    private final long mask;
    private final E[] buf;
    private final long[] seq;

    public MpmcArrayQueue(int capacity) {
        if (capacity <= 0 || capacity > 0x40000000) {
            throw new IllegalArgumentException();
        }
        int n = MathUtil.ceilPow2(capacity);
        this.mask = n - 1;
        this.buf = new Object[n];
        this.seq = new long[n];
        for (int i = 0; i < n; ++i) {
            SEQ.setVolatile(this.seq, i, i);
        }
    }

    public int size() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        long size = MpmcArrayQueue.safeDiff(currentTail, after);
        return (int)MathUtil.clamp(size, 0L, 0x80000000L);
    }

    public boolean isEmpty() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        return currentTail == after;
    }

    public boolean isFull() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        return currentTail == MpmcArrayQueue.safeNext(after + this.mask);
    }

    @Override
    @Nullable
    public E acquire() {
        int curPos;
        long mask = this.mask;
        long[] seq = this.seq;
        long curHead = HEAD.getVolatile(this);
        while (true) {
            long curSeq;
            long diff;
            if ((diff = MpmcArrayQueue.safeDiff(curSeq = SEQ.getVolatile(seq, curPos = (int)(curHead & mask)), curHead)) <= 0L) {
                long curTail = TAIL.getVolatile(this);
                if (MpmcArrayQueue.safeDiff(curHead, curTail) < 0L) continue;
                return null;
            }
            if (diff == 1L) {
                if (HEAD.compareAndSet(this, curHead, MpmcArrayQueue.safeNext(curHead))) break;
                curHead = MpmcArrayQueue.safeNext(curHead);
                continue;
            }
            curHead = HEAD.getVolatile(this);
        }
        E instance = this.buf[curPos];
        this.buf[curPos] = null;
        SEQ.setRelease(seq, curPos, MpmcArrayQueue.safeNext(curHead + mask));
        return instance;
    }

    @Override
    public boolean release(@NonNull E instance) {
        int curPos;
        Objects.requireNonNull(instance);
        long mask = this.mask;
        long[] seq = this.seq;
        long curTail = TAIL.getVolatile(this);
        while (true) {
            long curSeq;
            long diff;
            if ((diff = MpmcArrayQueue.safeDiff(curSeq = SEQ.getVolatile(seq, curPos = (int)(curTail & mask)), curTail)) < 0L) {
                long curHead = HEAD.getVolatile(this);
                if (MpmcArrayQueue.safeDiff(curTail, MpmcArrayQueue.safeNext(curHead + mask)) < 0L) continue;
                return false;
            }
            if (diff == 0L) {
                if (TAIL.compareAndSet(this, curTail, MpmcArrayQueue.safeNext(curTail))) break;
                curTail = MpmcArrayQueue.safeNext(curTail);
                continue;
            }
            curTail = TAIL.getVolatile(this);
        }
        this.buf[curPos] = instance;
        SEQ.setRelease(seq, curPos, MpmcArrayQueue.safeNext(curTail));
        return true;
    }

    private static long safeNext(long v) {
        return v + 1L & 0x3FFFFFFFFFFFFFFFL;
    }

    private static long safeDiff(long a, long b) {
        long d = a - b;
        if (d >= 0x2000000000000000L) {
            return d - 0x4000000000000000L;
        }
        if (d <= -2305843009213693952L) {
            return d + 0x4000000000000000L;
        }
        return d;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            HEAD = lookup.findVarHandle(HeadPadding.class, "head", Long.TYPE);
            TAIL = lookup.findVarHandle(TailPadding.class, "tail", Long.TYPE);
            SEQ = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

