/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.transition;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.transition.Transition;
import icyllis.modernui.transition.TransitionListener;
import icyllis.modernui.transition.TransitionValues;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Visibility
extends Transition {
    static final String PROPNAME_VISIBILITY = "modernui:visibility:visibility";
    private static final String PROPNAME_PARENT = "modernui:visibility:parent";
    private static final String PROPNAME_SCREEN_LOCATION = "modernui:visibility:screenLocation";
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    private static final String[] sTransitionProperties = new String[]{"modernui:visibility:visibility", "modernui:visibility:parent"};
    private int mMode = 3;

    public void setMode(int mode) {
        if ((mode & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = mode;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    @Nullable
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    private void captureValues(@Nonnull TransitionValues transitionValues) {
        int visibility = transitionValues.view.getVisibility();
        transitionValues.values.put(PROPNAME_VISIBILITY, visibility);
        transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
        int[] loc = new int[2];
        transitionValues.view.getLocationInWindow(loc);
        transitionValues.values.put(PROPNAME_SCREEN_LOCATION, loc);
    }

    @Override
    public void captureStartValues(@Nonnull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@Nonnull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public boolean isVisible(TransitionValues values) {
        if (values == null) {
            return false;
        }
        int visibility = (Integer)values.values.get(PROPNAME_VISIBILITY);
        View parent = (View)values.values.get(PROPNAME_PARENT);
        return visibility == 0 && parent != null;
    }

    private VisibilityInfo getVisibilityChangeInfo(TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = new VisibilityInfo();
        visInfo.mVisibilityChange = false;
        visInfo.mFadeIn = false;
        if (startValues != null && startValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.mStartVisibility = (Integer)startValues.values.get(PROPNAME_VISIBILITY);
            visInfo.mStartParent = (ViewGroup)startValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.mStartVisibility = -1;
            visInfo.mStartParent = null;
        }
        if (endValues != null && endValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.mEndVisibility = (Integer)endValues.values.get(PROPNAME_VISIBILITY);
            visInfo.mEndParent = (ViewGroup)endValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.mEndVisibility = -1;
            visInfo.mEndParent = null;
        }
        if (startValues != null && endValues != null) {
            if (visInfo.mStartVisibility == visInfo.mEndVisibility && visInfo.mStartParent == visInfo.mEndParent) {
                return visInfo;
            }
            if (visInfo.mStartVisibility != visInfo.mEndVisibility) {
                if (visInfo.mStartVisibility == 0) {
                    visInfo.mFadeIn = false;
                    visInfo.mVisibilityChange = true;
                } else if (visInfo.mEndVisibility == 0) {
                    visInfo.mFadeIn = true;
                    visInfo.mVisibilityChange = true;
                }
            } else if (visInfo.mEndParent == null) {
                visInfo.mFadeIn = false;
                visInfo.mVisibilityChange = true;
            } else if (visInfo.mStartParent == null) {
                visInfo.mFadeIn = true;
                visInfo.mVisibilityChange = true;
            }
        } else if (startValues == null && visInfo.mEndVisibility == 0) {
            visInfo.mFadeIn = true;
            visInfo.mVisibilityChange = true;
        } else if (endValues == null && visInfo.mStartVisibility == 0) {
            visInfo.mFadeIn = false;
            visInfo.mVisibilityChange = true;
        }
        return visInfo;
    }

    @Override
    @Nullable
    public Animator createAnimator(@Nonnull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        VisibilityInfo visInfo = this.getVisibilityChangeInfo(startValues, endValues);
        if (visInfo.mVisibilityChange && (visInfo.mStartParent != null || visInfo.mEndParent != null)) {
            if (visInfo.mFadeIn) {
                return this.onAppear(sceneRoot, startValues, visInfo.mStartVisibility, endValues, visInfo.mEndVisibility);
            }
            return this.onDisappear(sceneRoot, startValues, visInfo.mStartVisibility, endValues, visInfo.mEndVisibility);
        }
        return null;
    }

    @Nullable
    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        ViewParent viewParent;
        if ((this.mMode & 1) != 1 || endValues == null) {
            return null;
        }
        if (startValues == null && (viewParent = endValues.view.getParent()) instanceof View) {
            View endParent = (View)((Object)viewParent);
            TransitionValues startParentValues = this.getMatchedTransitionValues(endParent, false);
            TransitionValues endParentValues = this.getTransitionValues(endParent, false);
            VisibilityInfo parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
            if (parentVisibilityInfo.mVisibilityChange) {
                return null;
            }
        }
        return this.onAppear(sceneRoot, endValues.view, startValues, endValues);
    }

    @Nullable
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    @Nullable
    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 2) != 2) {
            return null;
        }
        if (startValues == null) {
            return null;
        }
        final View startView = startValues.view;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        boolean reusingOverlayView = false;
        View savedOverlayView = (View)startView.getTag(0x4020002);
        if (savedOverlayView != null) {
            overlayView = savedOverlayView;
            reusingOverlayView = true;
        } else {
            boolean needOverlayForStartView = false;
            if (endView == null || endView.getParent() == null) {
                if (endView != null) {
                    overlayView = endView;
                } else {
                    needOverlayForStartView = true;
                }
            } else if (endVisibility == 4) {
                viewToKeep = endView;
            } else if (startView == endView) {
                viewToKeep = endView;
            } else {
                needOverlayForStartView = true;
            }
            if (needOverlayForStartView) {
                if (startView.getParent() == null) {
                    overlayView = startView;
                } else {
                    ViewParent viewParent = startView.getParent();
                    if (viewParent instanceof View) {
                        View startParent = (View)((Object)viewParent);
                        TransitionValues startParentValues = this.getTransitionValues(startParent, true);
                        TransitionValues endParentValues = this.getMatchedTransitionValues(startParent, true);
                        VisibilityInfo parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
                        if (!parentVisibilityInfo.mVisibilityChange) {
                            // empty if block
                        }
                        overlayView = startView;
                    }
                }
            }
        }
        if (overlayView != null) {
            if (!reusingOverlayView) {
                int[] screenLoc = (int[])startValues.values.get(PROPNAME_SCREEN_LOCATION);
                int screenX = screenLoc[0];
                int screenY = screenLoc[1];
                int[] loc = new int[2];
                sceneRoot.getLocationInWindow(loc);
                overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
                overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
                sceneRoot.startViewTransition(overlayView);
            }
            Animator animator = this.onDisappear(sceneRoot, overlayView, startValues, endValues);
            if (!reusingOverlayView) {
                if (animator == null) {
                    sceneRoot.endViewTransition(overlayView);
                } else {
                    startView.setTag(0x4020002, overlayView);
                    final View finalOverlayView = overlayView;
                    final ViewGroup overlayHost = sceneRoot;
                    this.addListener(new TransitionListener(){

                        @Override
                        public void onTransitionPause(@Nonnull Transition transition) {
                            overlayHost.endViewTransition(finalOverlayView);
                        }

                        @Override
                        public void onTransitionResume(@Nonnull Transition transition) {
                            if (finalOverlayView.getParent() == null) {
                                overlayHost.startViewTransition(finalOverlayView);
                            } else {
                                Visibility.this.cancel();
                            }
                        }

                        @Override
                        public void onTransitionEnd(@Nonnull Transition transition) {
                            startView.setTag(0x4020002, null);
                            overlayHost.endViewTransition(finalOverlayView);
                            transition.removeListener(this);
                        }
                    });
                }
            }
            return animator;
        }
        if (viewToKeep != null) {
            int originalVisibility = viewToKeep.getVisibility();
            viewToKeep.setTransitionVisibility(0);
            Animator animator = this.onDisappear(sceneRoot, viewToKeep, startValues, endValues);
            if (animator != null) {
                DisappearListener disappearListener = new DisappearListener(viewToKeep, endVisibility, true);
                animator.addListener(disappearListener);
                this.addListener(disappearListener);
            } else {
                viewToKeep.setTransitionVisibility(originalVisibility);
            }
            return animator;
        }
        return null;
    }

    @Nullable
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    @Override
    public boolean isTransitionRequired(@Nullable TransitionValues startValues, @Nullable TransitionValues newValues) {
        if (startValues == null && newValues == null) {
            return false;
        }
        if (startValues != null && newValues != null && newValues.values.containsKey(PROPNAME_VISIBILITY) != startValues.values.containsKey(PROPNAME_VISIBILITY)) {
            return false;
        }
        VisibilityInfo changeInfo = this.getVisibilityChangeInfo(startValues, newValues);
        return changeInfo.mVisibilityChange && (changeInfo.mStartVisibility == 0 || changeInfo.mEndVisibility == 0);
    }

    private static class VisibilityInfo {
        boolean mVisibilityChange;
        boolean mFadeIn;
        int mStartVisibility;
        int mEndVisibility;
        ViewGroup mStartParent;
        ViewGroup mEndParent;

        private VisibilityInfo() {
        }
    }

    private static class DisappearListener
    implements AnimatorListener,
    TransitionListener {
        private final View mView;
        private final int mFinalVisibility;
        private final ViewGroup mParent;
        private final boolean mSuppressLayout;
        private boolean mLayoutSuppressed;
        boolean mCanceled = false;

        DisappearListener(@Nonnull View view, int finalVisibility, boolean suppressLayout) {
            this.mView = view;
            this.mFinalVisibility = finalVisibility;
            this.mParent = (ViewGroup)view.getParent();
            this.mSuppressLayout = suppressLayout;
            this.suppressLayout(true);
        }

        @Override
        public void onAnimationPause(@Nonnull Animator animation) {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(this.mFinalVisibility);
            }
        }

        @Override
        public void onAnimationResume(@Nonnull Animator animation) {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(0);
            }
        }

        @Override
        public void onAnimationCancel(@Nonnull Animator animation) {
            this.mCanceled = true;
        }

        @Override
        public void onAnimationRepeat(@Nonnull Animator animation) {
        }

        @Override
        public void onAnimationStart(@Nonnull Animator animation) {
        }

        @Override
        public void onAnimationEnd(@Nonnull Animator animation) {
            this.hideViewWhenNotCanceled();
        }

        @Override
        public void onTransitionStart(@Nonnull Transition transition) {
        }

        @Override
        public void onTransitionEnd(@Nonnull Transition transition) {
            this.hideViewWhenNotCanceled();
            transition.removeListener(this);
        }

        @Override
        public void onTransitionCancel(@Nonnull Transition transition) {
        }

        @Override
        public void onTransitionPause(@Nonnull Transition transition) {
            this.suppressLayout(false);
        }

        @Override
        public void onTransitionResume(@Nonnull Transition transition) {
            this.suppressLayout(true);
        }

        private void hideViewWhenNotCanceled() {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(this.mFinalVisibility);
                if (this.mParent != null) {
                    this.mParent.invalidate();
                }
            }
            this.suppressLayout(false);
        }

        private void suppressLayout(boolean suppress) {
            if (this.mSuppressLayout && this.mLayoutSuppressed != suppress && this.mParent != null) {
                this.mLayoutSuppressed = suppress;
                this.mParent.suppressLayout(suppress);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

