/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.ibm.icu.text.Bidi;
import icyllis.modernui.annotation.IntRange;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.FontMetricsInt;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.LineBreakConfig;
import icyllis.modernui.graphics.text.MeasuredText;
import icyllis.modernui.text.Directions;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.style.MetricAffectingSpan;
import icyllis.modernui.text.style.ReplacementSpan;
import icyllis.modernui.util.Pools;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MeasuredParagraph {
    private static final Pools.Pool<MeasuredParagraph> sPool = Pools.newSynchronizedPool(1);
    @Nullable
    private Spanned mSpanned;
    private int mTextStart;
    private char[] mCopiedBuffer;
    private int mParaDir;
    @Nullable
    private byte[] mLevels;
    @NonNull
    private final IntArrayList mSpanEndCache = new IntArrayList();
    @NonNull
    private final IntArrayList mFontMetrics = new IntArrayList();
    @Nullable
    private MeasuredText mMeasuredText;
    @NonNull
    private final FontMetricsInt mCachedFm = new FontMetricsInt();

    private MeasuredParagraph() {
    }

    public void release() {
        this.reset();
        this.mSpanEndCache.trim();
        this.mFontMetrics.trim();
    }

    private void reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mLevels = null;
        this.mSpanEndCache.clear();
        this.mFontMetrics.clear();
        this.mMeasuredText = null;
    }

    public int getTextStart() {
        return this.mTextStart;
    }

    public int getTextLength() {
        return this.mCopiedBuffer.length;
    }

    @NonNull
    public char[] getChars() {
        return this.mCopiedBuffer;
    }

    public int getParagraphDir() {
        return this.mParaDir;
    }

    @NonNull
    public Directions getDirections(int start, int end) {
        boolean swap;
        int curLevel;
        if (start == end || this.mLevels == null) {
            return Directions.ALL_LEFT_TO_RIGHT;
        }
        int baseLevel = this.mParaDir == 1 ? 0 : 1;
        byte[] levels = this.mLevels;
        int minLevel = curLevel = levels[start];
        int runCount = 1;
        for (int i = start + 1; i < end; ++i) {
            int level = levels[i];
            if (level == curLevel) continue;
            curLevel = level;
            ++runCount;
        }
        int visLen = end - start;
        if ((curLevel & 1) != (baseLevel & 1)) {
            while (--visLen >= 0) {
                char ch = this.mCopiedBuffer[start + visLen];
                if (ch == '\n') {
                    --visLen;
                    break;
                }
                if (ch == ' ' || ch == '\t') continue;
                break;
            }
            if (++visLen != end - start) {
                ++runCount;
            }
        }
        if (runCount == 1 && minLevel == baseLevel) {
            if ((minLevel & 1) != 0) {
                return Directions.ALL_RIGHT_TO_LEFT;
            }
            return Directions.ALL_LEFT_TO_RIGHT;
        }
        int[] ld = new int[runCount * 2];
        int maxLevel = minLevel;
        int levelBits = minLevel << 26;
        int n = 1;
        int prev = start;
        curLevel = minLevel;
        int e = start + visLen;
        for (int i = start; i < e; ++i) {
            int level = levels[i];
            if (level == curLevel) continue;
            curLevel = level;
            if (level > maxLevel) {
                maxLevel = level;
            } else if (level < minLevel) {
                minLevel = level;
            }
            ld[n++] = i - prev | levelBits;
            ld[n++] = i - start;
            levelBits = curLevel << 26;
            prev = i;
        }
        ld[n] = start + visLen - prev | levelBits;
        if (visLen < end - start) {
            ld[++n] = visLen;
            ld[++n] = end - start - visLen | baseLevel << 26;
        }
        if ((minLevel & 1) == baseLevel) {
            swap = maxLevel > ++minLevel;
        } else {
            boolean bl = swap = runCount > 1;
        }
        if (swap) {
            for (int level = maxLevel - 1; level >= minLevel; --level) {
                for (int i = 0; i < ld.length; i += 2) {
                    int e2;
                    if (levels[ld[i]] < level) continue;
                    for (e2 = i + 2; e2 < ld.length && levels[ld[e2]] >= level; e2 += 2) {
                    }
                    int low = i;
                    for (int hi = e2 - 2; low < hi; low += 2, hi -= 2) {
                        int x = ld[low];
                        ld[low] = ld[hi];
                        ld[hi] = x;
                        x = ld[low + 1];
                        ld[low + 1] = ld[hi + 1];
                        ld[hi + 1] = x;
                    }
                    i = e2 + 2;
                }
            }
        }
        return new Directions(ld);
    }

    @NonNull
    public IntArrayList getSpanEndCache() {
        return this.mSpanEndCache;
    }

    @NonNull
    public IntArrayList getFontMetrics() {
        return this.mFontMetrics;
    }

    @Nullable
    public MeasuredText getMeasuredText() {
        return this.mMeasuredText;
    }

    public float getAdvance(int offset) {
        if (this.mMeasuredText == null) {
            return 0.0f;
        }
        return this.mMeasuredText.getAdvance(offset);
    }

    public float getAdvance(int start, int end) {
        if (this.mMeasuredText == null) {
            return 0.0f;
        }
        return this.mMeasuredText.getAdvance(start, end);
    }

    public void getExtent(@IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull FontMetricsInt fmi) {
        if (this.mMeasuredText != null) {
            this.mMeasuredText.getExtent(start, end, fmi);
        }
    }

    @NonNull
    private static MeasuredParagraph obtain() {
        MeasuredParagraph c = sPool.acquire();
        return c == null ? new MeasuredParagraph() : c;
    }

    @NonNull
    public static MeasuredParagraph buildForBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, @Nullable MeasuredParagraph recycle) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IllegalArgumentException();
        }
        MeasuredParagraph c = recycle == null ? MeasuredParagraph.obtain() : recycle;
        c.resetAndAnalyzeBidi(text, start, end, textDir);
        return c;
    }

    @NonNull
    public static MeasuredParagraph buildForStaticLayout(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull TextDirectionHeuristic textDir, boolean fullLayout, @Nullable MeasuredParagraph recycle) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IllegalArgumentException();
        }
        MeasuredParagraph c = recycle == null ? MeasuredParagraph.obtain() : recycle;
        c.resetAndAnalyzeBidi(text, start, end, textDir);
        if (end > start) {
            MeasuredText.Builder builder = new MeasuredText.Builder(c.mCopiedBuffer).setComputeLayout(fullLayout);
            if (c.mSpanned == null) {
                c.applyMetricsAffectingSpan(paint, lineBreakConfig, Collections.emptyList(), start, end, builder);
                c.mSpanEndCache.add(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int spanEnd = c.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    List<MetricAffectingSpan> spans = c.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, c.mSpanned);
                    c.applyMetricsAffectingSpan(paint, lineBreakConfig, spans, spanStart, spanEnd, builder);
                    c.mSpanEndCache.add(spanEnd);
                    spanStart = spanEnd;
                }
            }
            c.mMeasuredText = builder.build();
        }
        return c;
    }

    private void resetAndAnalyzeBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic dir) {
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        int length = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != length) {
            this.mCopiedBuffer = new char[length];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            List<ReplacementSpan> spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class);
            for (ReplacementSpan span : spans) {
                int startInPara = this.mSpanned.getSpanStart(span) - start;
                int endInPara = this.mSpanned.getSpanEnd(span) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > length) {
                    endInPara = length;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if (!(dir != TextDirectionHeuristics.LTR && dir != TextDirectionHeuristics.FIRSTSTRONG_LTR && dir != TextDirectionHeuristics.ANYRTL_LTR || Bidi.requiresBidi((char[])this.mCopiedBuffer, (int)0, (int)length))) {
            this.mLevels = null;
            this.mParaDir = 1;
        } else {
            boolean isRtl;
            byte paraLevel = dir == TextDirectionHeuristics.LTR ? (byte)0 : (dir == TextDirectionHeuristics.RTL ? (byte)1 : (dir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? (byte)126 : (dir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? (byte)127 : ((isRtl = dir.isRtl(this.mCopiedBuffer, 0, length)) ? (byte)1 : 0))));
            Bidi bidi = new Bidi(length, 0);
            bidi.setPara(this.mCopiedBuffer, paraLevel, null);
            this.mLevels = bidi.getLevels();
            this.mParaDir = (bidi.getParaLevel() & 1) == 0 ? 1 : -1;
        }
    }

    private void applyMetricsAffectingSpan(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull List<MetricAffectingSpan> spans, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull MeasuredText.Builder builder) {
        assert (start != end);
        TextPaint tp = TextPaint.obtain();
        tp.set(paint);
        tp.baselineShift = 0;
        ReplacementSpan replacement = null;
        for (MetricAffectingSpan span : spans) {
            if (span instanceof ReplacementSpan) {
                replacement = (ReplacementSpan)span;
                continue;
            }
            span.updateMeasureState(tp);
        }
        tp.getFontMetricsInt(this.mCachedFm);
        if (replacement != null) {
            float width = replacement.getSize(tp, this.mSpanned, start + this.mTextStart, end + this.mTextStart, this.mCachedFm);
            builder.addReplacementRun(tp.getTextLocale(), end - start, width);
        } else {
            int offset = this.mTextStart;
            FontPaint base = tp.createInternalPaint();
            this.applyStyleRun(base, start - offset, end - offset, lineBreakConfig, builder);
        }
        if (tp.baselineShift < 0) {
            this.mCachedFm.ascent += tp.baselineShift;
        } else {
            this.mCachedFm.descent += tp.baselineShift;
        }
        this.mFontMetrics.add(this.mCachedFm.ascent);
        this.mFontMetrics.add(this.mCachedFm.descent);
        tp.recycle();
    }

    private void applyStyleRun(@NonNull FontPaint paint, int start, int end, @Nullable LineBreakConfig config, @NonNull MeasuredText.Builder builder) {
        if (this.mLevels == null) {
            builder.addStyleRun(paint, config, end - start, false);
        } else {
            byte level = this.mLevels[start];
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mLevels[levelEnd] != level) {
                    boolean isRtl = (level & 1) != 0;
                    builder.addStyleRun(paint, config, levelEnd - levelStart, isRtl);
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mLevels[levelEnd];
                }
                ++levelEnd;
            }
        }
    }

    int breakText(int limit, boolean forwards, float width) {
        int i;
        MeasuredText mt = this.mMeasuredText;
        assert (mt != null);
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= mt.getAdvance(i2)) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mCopiedBuffer[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= mt.getAdvance(i)) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mCopiedBuffer[i + 1] == ' ' || mt.getAdvance(i + 1) == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    public void recycle() {
        this.release();
        sPool.release(this);
    }

    public int getMemoryUsage() {
        return MathUtil.align8(32 + (this.mCopiedBuffer == null ? 0 : 16 + (this.mCopiedBuffer.length << 1)) + 4 + (this.mLevels == null ? 0 : 16 + this.mLevels.length) + 16 + (this.mSpanEndCache.size() << 2) + 16 + (this.mFontMetrics.size() << 2) + 8) + (this.mMeasuredText == null ? 0 : this.mMeasuredText.getMemoryUsage());
    }
}

