/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.text.LineBreaker;
import icyllis.modernui.text.Directions;
import icyllis.modernui.text.GetChars;
import icyllis.modernui.text.MeasuredParagraph;
import icyllis.modernui.text.SpanSet;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.SpannableStringBuilder;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.TabStops;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextLine;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.method.TextKeyListener;
import icyllis.modernui.text.style.AlignmentSpan;
import icyllis.modernui.text.style.LeadingMarginSpan;
import icyllis.modernui.text.style.LineBackgroundSpan;
import icyllis.modernui.text.style.ParagraphStyle;
import icyllis.modernui.text.style.ReplacementSpan;
import icyllis.modernui.text.style.TabStopSpan;
import icyllis.modernui.text.style.TrailingMarginSpan;
import icyllis.modernui.util.GrowingArrayUtils;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Layout {
    public static final int DIR_LEFT_TO_RIGHT = 1;
    public static final int DIR_RIGHT_TO_LEFT = -1;
    public static final float TAB_INCREMENT = 20.0f;
    private CharSequence mText;
    private TextPaint mPaint;
    private int mWidth;
    private Alignment mAlignment;
    private boolean mSpannedText;
    private final TextDirectionHeuristic mTextDir;
    private SpanSet<LineBackgroundSpan> mLineBackgroundSpans;
    private static final LineBackgroundSpan[] EMPTY_BACKGROUND_SPANS = new LineBackgroundSpan[0];

    protected Layout(CharSequence text, TextPaint paint, int width, Alignment align) {
        this(text, paint, width, align, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    protected Layout(CharSequence text, TextPaint paint, int width, Alignment align, TextDirectionHeuristic textDir) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        if (paint != null) {
            paint.bgColor = 0;
            paint.baselineShift = 0;
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpannedText = text instanceof Spanned;
        this.mTextDir = textDir;
    }

    void replaceWith(CharSequence text, TextPaint paint, int width, Alignment align) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpannedText = text instanceof Spanned;
    }

    public void draw(@NonNull Canvas canvas) {
        long range = this.getLineRangeForDraw(canvas);
        if (range < 0L) {
            return;
        }
        int firstLine = (int)(range >>> 32);
        int lastLine = (int)(range & 0xFFFFFFFFL);
        this.drawBackground(canvas, firstLine, lastLine);
        this.drawText(canvas, firstLine, lastLine);
    }

    public final void drawBackground(@NonNull Canvas canvas, int firstLine, int lastLine) {
        if (!this.mSpannedText) {
            return;
        }
        assert (firstLine >= 0 && lastLine >= firstLine);
        if (this.mLineBackgroundSpans == null) {
            this.mLineBackgroundSpans = new SpanSet<LineBackgroundSpan>(LineBackgroundSpan.class);
        }
        Spanned buffer = (Spanned)this.mText;
        int textLength = buffer.length();
        this.mLineBackgroundSpans.init(buffer, 0, textLength);
        if (!this.mLineBackgroundSpans.isEmpty()) {
            int previousLineBottom = this.getLineTop(firstLine);
            int previousLineEnd = this.getLineStart(firstLine);
            LineBackgroundSpan[] spans = EMPTY_BACKGROUND_SPANS;
            int spansLength = 0;
            TextPaint paint = this.mPaint;
            int spanEnd = 0;
            int width = this.mWidth;
            for (int i = firstLine; i <= lastLine; ++i) {
                int lbottom;
                int end;
                int start = previousLineEnd;
                previousLineEnd = end = this.getLineStart(i + 1);
                int ltop = previousLineBottom;
                previousLineBottom = lbottom = this.getLineTop(i + 1);
                int lbaseline = lbottom - this.getLineDescent(i);
                if (end >= spanEnd) {
                    spanEnd = this.mLineBackgroundSpans.getNextTransition(start, textLength);
                    spansLength = 0;
                    if (start != end || start == 0) {
                        for (int j = 0; j < this.mLineBackgroundSpans.size(); ++j) {
                            if (this.mLineBackgroundSpans.mSpanStarts[j] >= end || this.mLineBackgroundSpans.mSpanEnds[j] <= start) continue;
                            spans = GrowingArrayUtils.append(spans, spansLength, (LineBackgroundSpan)this.mLineBackgroundSpans.get(j));
                            ++spansLength;
                        }
                    }
                }
                for (int n = 0; n < spansLength; ++n) {
                    LineBackgroundSpan lineBackgroundSpan = spans[n];
                    lineBackgroundSpan.drawBackground(canvas, paint, 0, width, ltop, lbaseline, lbottom, buffer, start, end, i);
                }
            }
        }
        this.mLineBackgroundSpans.recycle();
    }

    public void drawText(@NonNull Canvas canvas, int firstLine, int lastLine) {
        assert (firstLine >= 0 && lastLine >= firstLine && lastLine < this.getLineCount());
        int previousLineBottom = this.getLineTop(firstLine);
        int previousLineEnd = this.getLineStart(firstLine);
        List<Object> spans = Collections.emptyList();
        int spanEnd = 0;
        TextPaint paint = TextPaint.obtain();
        paint.set(this.mPaint);
        CharSequence buf = this.mText;
        Alignment paraAlign = this.mAlignment;
        TabStops tabStops = null;
        boolean tabStopsIsInitialized = false;
        TextLine tl = TextLine.obtain();
        for (int lineNum = firstLine; lineNum <= lastLine; ++lineNum) {
            int x;
            Alignment align;
            boolean hasTab;
            int lbottom;
            int start = previousLineEnd;
            previousLineEnd = this.getLineStart(lineNum + 1);
            int end = this.getLineVisibleEnd(lineNum, start, previousLineEnd);
            int ltop = previousLineBottom;
            previousLineBottom = lbottom = this.getLineTop(lineNum + 1);
            int lbaseline = lbottom - this.getLineDescent(lineNum);
            int dir = this.getParagraphDirection(lineNum);
            int left = 0;
            int right = this.mWidth;
            if (this.mSpannedText) {
                boolean isFirstParaLine;
                Spanned sp = (Spanned)buf;
                int textLength = buf.length();
                boolean bl = isFirstParaLine = start == 0 || buf.charAt(start - 1) == '\n';
                if (start >= spanEnd && (lineNum == firstLine || isFirstParaLine)) {
                    spanEnd = sp.nextSpanTransition(start, textLength, ParagraphStyle.class);
                    spans = Layout.getParagraphSpans(sp, start, spanEnd, ParagraphStyle.class);
                    paraAlign = this.mAlignment;
                    for (int n = spans.size() - 1; n >= 0; --n) {
                        Object object = spans.get(n);
                        if (!(object instanceof AlignmentSpan)) continue;
                        AlignmentSpan alignment = (AlignmentSpan)object;
                        paraAlign = alignment.getAlignment();
                        break;
                    }
                    tabStopsIsInitialized = false;
                }
                boolean useFirstLineMargin = isFirstParaLine;
                for (ParagraphStyle paragraphStyle : spans) {
                    if (!(paragraphStyle instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 margin = (LeadingMarginSpan.LeadingMarginSpan2)paragraphStyle;
                    int count = margin.getLeadingMarginLineCount();
                    int startLine = this.getLineForOffset(sp.getSpanStart(margin));
                    if (lineNum >= startLine + count) continue;
                    useFirstLineMargin = true;
                    break;
                }
                for (ParagraphStyle paragraphStyle : spans) {
                    if (paragraphStyle instanceof LeadingMarginSpan) {
                        LeadingMarginSpan lms = (LeadingMarginSpan)paragraphStyle;
                        lms.drawMargin(canvas, paint, left, right, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                        if (dir == -1) {
                            right -= lms.getLeadingMargin(useFirstLineMargin);
                        } else {
                            left += lms.getLeadingMargin(useFirstLineMargin);
                        }
                    }
                    if (!(paragraphStyle instanceof TrailingMarginSpan)) continue;
                    TrailingMarginSpan tms = (TrailingMarginSpan)paragraphStyle;
                    if (dir == 1) {
                        right -= tms.getTrailingMargin();
                        continue;
                    }
                    left += tms.getTrailingMargin();
                }
            }
            if ((hasTab = this.getLineContainsTab(lineNum)) && !tabStopsIsInitialized) {
                if (tabStops == null) {
                    tabStops = new TabStops(20.0f, spans);
                } else {
                    tabStops.reset(20.0f, spans);
                }
                tabStopsIsInitialized = true;
            }
            if ((align = paraAlign) == Alignment.ALIGN_LEFT) {
                align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
            } else if (align == Alignment.ALIGN_RIGHT) {
                align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
            }
            Directions directions = this.getLineDirections(lineNum);
            int ellipsisStart = this.getEllipsisStart(lineNum);
            tl.set(paint, buf, start, end, dir, directions, hasTab, tabStops, ellipsisStart, ellipsisStart + this.getEllipsisCount(lineNum));
            if (align == Alignment.ALIGN_NORMAL) {
                if (dir == 1) {
                    int n = this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT);
                    x = left + n;
                } else {
                    int n = -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT);
                    x = right - n;
                }
            } else {
                int max = (int)tl.metrics(null);
                if (align == Alignment.ALIGN_OPPOSITE) {
                    if (dir == 1) {
                        int n = -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT);
                        x = right - max - n;
                    } else {
                        int n = this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT);
                        x = left - max + n;
                    }
                } else {
                    int n = this.getIndentAdjust(lineNum, Alignment.ALIGN_CENTER);
                    x = (right + left - (max &= 0xFFFFFFFE) >> 1) + n;
                }
            }
            if (directions == Directions.ALL_LEFT_TO_RIGHT && !this.mSpannedText && !hasTab) {
                TextUtils.drawTextRun(canvas, buf, start, end, start, end, (float)x, (float)lbaseline, false, paint);
                continue;
            }
            tl.draw(canvas, x, ltop, lbaseline, lbottom);
        }
        paint.recycle();
        tl.recycle();
    }

    public final long getLineRangeForDraw(@NonNull Canvas canvas) {
        int lineCount = this.getLineCount();
        if (lineCount <= 0) {
            return -1L;
        }
        int bottom = this.getLineTop(lineCount);
        if (canvas.quickReject(0.0f, 0.0f, this.mWidth, bottom)) {
            return -1L;
        }
        int lineNum = 0;
        int lineTop = 0;
        int firstLine = -1;
        int lastLine = -1;
        do {
            int lineBottom = this.getLineTop(lineNum + 1);
            if (firstLine == -1) {
                if (!canvas.quickReject(0.0f, lineTop, this.mWidth, lineBottom)) {
                    firstLine = lineNum;
                }
            } else if (canvas.quickReject(0.0f, lineTop, this.mWidth, lineBottom)) {
                lastLine = lineNum - 1;
                break;
            }
            lineTop = lineBottom;
        } while (++lineNum < lineCount);
        if (firstLine == -1) {
            return -1L;
        }
        if (lastLine == -1) {
            assert (lineNum == lineCount);
            lastLine = lineCount - 1;
        }
        assert (lastLine >= firstLine);
        return (long)firstLine << 32 | (long)lastLine;
    }

    public int getLineForVertical(int vertical) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (this.getLineTop(guess) > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        return Math.max(low, 0);
    }

    public int getLineForOffset(int offset) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineStart(guess) > offset) {
                high = guess;
                continue;
            }
            low = guess;
        }
        return Math.max(low, 0);
    }

    public final CharSequence getText() {
        return this.mText;
    }

    public final TextPaint getPaint() {
        return this.mPaint;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public int getEllipsizedWidth() {
        return this.mWidth;
    }

    public final void increaseWidthTo(int wid) {
        if (wid < this.mWidth) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = wid;
    }

    public int getHeight() {
        return this.getLineTop(this.getLineCount());
    }

    public int getHeight(boolean cap) {
        return this.getHeight();
    }

    public final Alignment getAlignment() {
        return this.mAlignment;
    }

    public final TextDirectionHeuristic getTextDirectionHeuristic() {
        return this.mTextDir;
    }

    public abstract int getLineCount();

    public int getLineBounds(int line, @Nullable Rect bounds) {
        if (bounds != null) {
            bounds.left = 0;
            bounds.top = this.getLineTop(line);
            bounds.right = this.mWidth;
            bounds.bottom = this.getLineTop(line + 1);
        }
        return this.getLineBaseline(line);
    }

    public abstract int getLineTop(int var1);

    public abstract int getLineDescent(int var1);

    public abstract int getLineStart(int var1);

    public abstract int getParagraphDirection(int var1);

    public abstract boolean getLineContainsTab(int var1);

    public abstract Directions getLineDirections(int var1);

    public abstract int getTopPadding();

    public abstract int getBottomPadding();

    public int getIndentAdjust(int line, Alignment alignment) {
        return 0;
    }

    public abstract int getEllipsisStart(int var1);

    public abstract int getEllipsisCount(int var1);

    public float getLineMax(int line) {
        float margin = this.getParagraphLeadingMargin(line) + this.getParagraphTrailingMargin(line);
        float signedExtent = this.getLineExtent(line, false);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    public float getLineWidth(int line) {
        float margin = this.getParagraphLeadingMargin(line) + this.getParagraphTrailingMargin(line);
        float signedExtent = this.getLineExtent(line, true);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    private float getLineExtent(int line, boolean full) {
        Directions directions;
        List<TabStopSpan> tabs;
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabs = this.getLineContainsTab(line);
        TabStops tabStops = null;
        if (hasTabs && this.mText instanceof Spanned && !(tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).isEmpty()) {
            tabStops = new TabStops(20.0f, tabs);
        }
        if ((directions = this.getLineDirections(line)) == null) {
            return 0.0f;
        }
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        TextPaint paint = TextPaint.obtain();
        paint.set(this.mPaint);
        tl.set(paint, this.mText, start, end, dir, directions, hasTabs, tabStops, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        float width = tl.metrics(null);
        tl.recycle();
        paint.recycle();
        return width;
    }

    private float getLineExtent(int line, TabStops tabStops, boolean full) {
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabs = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        TextPaint paint = TextPaint.obtain();
        paint.set(this.mPaint);
        tl.set(paint, this.mText, start, end, dir, directions, hasTabs, tabStops, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        float width = tl.metrics(null);
        tl.recycle();
        paint.recycle();
        return width;
    }

    public final int getLineEnd(int line) {
        return this.getLineStart(line + 1);
    }

    public int getLineVisibleEnd(int line) {
        return this.getLineVisibleEnd(line, this.getLineStart(line), this.getLineStart(line + 1));
    }

    private int getLineVisibleEnd(int line, int start, int end) {
        CharSequence text = this.mText;
        if (line == this.getLineCount() - 1) {
            return end;
        }
        while (end > start) {
            char ch = text.charAt(end - 1);
            if (ch == '\n') {
                return end - 1;
            }
            if (!LineBreaker.isLineEndSpace(ch)) break;
            --end;
        }
        return end;
    }

    public final int getLineBottom(int line) {
        return this.getLineTop(line + 1);
    }

    public final int getLineBaseline(int line) {
        return this.getLineTop(line + 1) - this.getLineDescent(line);
    }

    public final int getLineAscent(int line) {
        return this.getLineTop(line) - (this.getLineTop(line + 1) - this.getLineDescent(line));
    }

    public final Alignment getParagraphAlignment(int line) {
        Alignment align = this.mAlignment;
        return align;
    }

    public final int getParagraphLeft(int line) {
        int left = 0;
        if (!this.mSpannedText) {
            return left;
        }
        int dir = this.getParagraphDirection(line);
        if (dir == -1) {
            return this.getParagraphTrailingMargin(line);
        }
        return this.getParagraphLeadingMargin(line);
    }

    public final int getParagraphRight(int line) {
        int right = this.mWidth;
        if (!this.mSpannedText) {
            return right;
        }
        int dir = this.getParagraphDirection(line);
        if (dir == 1) {
            return right - this.getParagraphTrailingMargin(line);
        }
        return right - this.getParagraphLeadingMargin(line);
    }

    public boolean primaryIsTrailingPrevious(int offset) {
        int line = this.getLineForOffset(offset);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int[] runs = this.getLineDirections((int)line).mDirections;
        int levelAt = -1;
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (limit > lineEnd) {
                limit = lineEnd;
            }
            if (offset < start || offset >= limit) continue;
            if (offset > start) {
                return false;
            }
            levelAt = runs[i + 1] >>> 26 & 0x3F;
            break;
        }
        if (levelAt == -1) {
            levelAt = this.getParagraphDirection(line) == 1 ? 0 : 1;
        }
        int levelBefore = -1;
        if (offset == lineStart) {
            levelBefore = this.getParagraphDirection(line) == 1 ? 0 : 1;
        } else {
            --offset;
            for (int i = 0; i < runs.length; i += 2) {
                int start = lineStart + runs[i];
                int limit = start + (runs[i + 1] & 0x3FFFFFF);
                if (limit > lineEnd) {
                    limit = lineEnd;
                }
                if (offset < start || offset >= limit) continue;
                levelBefore = runs[i + 1] >>> 26 & 0x3F;
                break;
            }
        }
        return levelBefore < levelAt;
    }

    public boolean[] primaryIsTrailingPreviousAllLineOffsets(int line) {
        int start;
        int i;
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int[] runs = this.getLineDirections((int)line).mDirections;
        boolean[] trailing = new boolean[lineEnd - lineStart + 1];
        byte[] level = new byte[lineEnd - lineStart + 1];
        for (i = 0; i < runs.length; i += 2) {
            start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (limit > lineEnd) {
                limit = lineEnd;
            }
            if (limit == start) continue;
            level[limit - lineStart - 1] = (byte)(runs[i + 1] >>> 26 & 0x3F);
        }
        for (i = 0; i < runs.length; i += 2) {
            start = lineStart + runs[i];
            byte currentLevel = (byte)(runs[i + 1] >>> 26 & 0x3F);
            trailing[start - lineStart] = currentLevel > (start == lineStart ? (this.getParagraphDirection(line) == 1 ? (byte)0 : 1) : level[start - lineStart - 1]);
        }
        return trailing;
    }

    public float getPrimaryHorizontal(int offset) {
        return this.getPrimaryHorizontal(offset, false);
    }

    public float getPrimaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, trailing, clamped);
    }

    public float getSecondaryHorizontal(int offset) {
        return this.getSecondaryHorizontal(offset, false);
    }

    public float getSecondaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, !trailing, clamped);
    }

    private float getHorizontal(int offset, boolean primary) {
        return primary ? this.getPrimaryHorizontal(offset) : this.getSecondaryHorizontal(offset);
    }

    private float getHorizontal(int offset, boolean trailing, boolean clamped) {
        int line = this.getLineForOffset(offset);
        return this.getHorizontal(offset, trailing, line, clamped);
    }

    private float getHorizontal(int offset, boolean trailing, int line, boolean clamped) {
        List<TabStopSpan> tabs;
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        int dir = this.getParagraphDirection(line);
        boolean hasTab = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        TabStops tabStops = null;
        if (hasTab && this.mText instanceof Spanned && !(tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).isEmpty()) {
            tabStops = new TabStops(20.0f, tabs);
        }
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTab, tabStops, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        float wid = tl.measure(offset - start, trailing, null);
        tl.recycle();
        if (clamped && wid > (float)this.mWidth) {
            wid = this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        return (float)this.getLineStartPos(line, left, right) + wid;
    }

    private float[] getLineHorizontals(int line, boolean clamped, boolean primary) {
        List<TabStopSpan> tabs;
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        int dir = this.getParagraphDirection(line);
        boolean hasTab = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        TabStops tabStops = null;
        if (hasTab && this.mText instanceof Spanned && !(tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).isEmpty()) {
            tabStops = new TabStops(20.0f, tabs);
        }
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTab, tabStops, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        boolean[] trailings = this.primaryIsTrailingPreviousAllLineOffsets(line);
        if (!primary) {
            for (int offset = 0; offset < trailings.length; ++offset) {
                trailings[offset] = !trailings[offset];
            }
        }
        float[] wid = tl.measureAllOffsets(trailings, null);
        tl.recycle();
        if (clamped) {
            for (int offset = 0; offset < wid.length; ++offset) {
                if (!(wid[offset] > (float)this.mWidth)) continue;
                wid[offset] = this.mWidth;
            }
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int lineStartPos = this.getLineStartPos(line, left, right);
        float[] horizontal = new float[end - start + 1];
        for (int offset = 0; offset < horizontal.length; ++offset) {
            horizontal[offset] = (float)lineStartPos + wid[offset];
        }
        return horizontal;
    }

    public int getOffsetForHorizontal(int line, float horiz) {
        return this.getOffsetForHorizontal(line, horiz, true);
    }

    public int getOffsetForHorizontal(int line, float horiz, boolean primary) {
        int lineEndOffset = this.getLineEnd(line);
        int lineStartOffset = this.getLineStart(line);
        Directions dirs = this.getLineDirections(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, lineStartOffset, lineEndOffset, this.getParagraphDirection(line), dirs, false, null, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        HorizontalMeasurementProvider horizontal = new HorizontalMeasurementProvider(line, primary);
        int max = line == this.getLineCount() - 1 ? lineEndOffset : tl.getOffsetToLeftRightOf(lineEndOffset - lineStartOffset, !this.isRtlCharAt(lineEndOffset - 1)) + lineStartOffset;
        int best = lineStartOffset;
        float bestdist = Math.abs(horizontal.get(lineStartOffset) - horiz);
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            float dist;
            int aft;
            int swap;
            int here = lineStartOffset + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            boolean isRtl = (dirs.mDirections[i + 1] & 0x4000000) != 0;
            int n = swap = isRtl ? -1 : 1;
            if (there > max) {
                there = max;
            }
            int high = there - 1 + 1;
            int low = here + 1 - 1;
            while (high - low > 1) {
                int guess = (high + low) / 2;
                int adguess = this.getOffsetAtStartOf(guess);
                if (horizontal.get(adguess) * (float)swap >= horiz * (float)swap) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            if (low < here + 1) {
                low = here + 1;
            }
            if (low < there && (low = tl.getOffsetToLeftRightOf((aft = tl.getOffsetToLeftRightOf(low - lineStartOffset, isRtl) + lineStartOffset) - lineStartOffset, !isRtl) + lineStartOffset) >= here && low < there) {
                float other;
                float dist2 = Math.abs(horizontal.get(low) - horiz);
                if (aft < there && (other = Math.abs(horizontal.get(aft) - horiz)) < dist2) {
                    dist2 = other;
                    low = aft;
                }
                if (dist2 < bestdist) {
                    bestdist = dist2;
                    best = low;
                }
            }
            if (!((dist = Math.abs(horizontal.get(here) - horiz)) < bestdist)) continue;
            bestdist = dist;
            best = here;
        }
        float dist = Math.abs(horizontal.get(max) - horiz);
        if (dist <= bestdist) {
            best = max;
        }
        tl.recycle();
        return best;
    }

    private int getLineStartPos(int line, int left, int right) {
        int x;
        Alignment align = this.getParagraphAlignment(line);
        int dir = this.getParagraphDirection(line);
        if (align == Alignment.ALIGN_LEFT) {
            align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
        } else if (align == Alignment.ALIGN_RIGHT) {
            Alignment alignment = align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
        }
        if (align == Alignment.ALIGN_NORMAL) {
            x = dir == 1 ? left + this.getIndentAdjust(line, Alignment.ALIGN_LEFT) : right + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT);
        } else {
            int spanEnd;
            int start;
            Spanned spanned;
            List<TabStopSpan> tabSpans;
            TabStops tabStops = null;
            if (this.mSpannedText && this.getLineContainsTab(line) && !(tabSpans = Layout.getParagraphSpans(spanned = (Spanned)this.mText, start = this.getLineStart(line), spanEnd = spanned.nextSpanTransition(start, spanned.length(), TabStopSpan.class), TabStopSpan.class)).isEmpty()) {
                tabStops = new TabStops(20.0f, tabSpans);
            }
            int max = (int)this.getLineExtent(line, tabStops, false);
            x = align == Alignment.ALIGN_OPPOSITE ? (dir == 1 ? right - max + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT) : left - max + this.getIndentAdjust(line, Alignment.ALIGN_LEFT)) : left + right - (max &= 0xFFFFFFFE) >> 1 + this.getIndentAdjust(line, Alignment.ALIGN_CENTER);
        }
        return x;
    }

    public boolean isLevelBoundary(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == Directions.ALL_LEFT_TO_RIGHT || dirs == Directions.ALL_RIGHT_TO_LEFT) {
            return false;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        if (offset == lineStart || offset == lineEnd) {
            int paraLevel = this.getParagraphDirection(line) == 1 ? 0 : 1;
            int runIndex = offset == lineStart ? 0 : runs.length - 2;
            return (runs[runIndex + 1] >>> 26 & 0x3F) != paraLevel;
        }
        offset -= lineStart;
        for (int i = 0; i < runs.length; i += 2) {
            if (offset != runs[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isRtlCharAt(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == Directions.ALL_LEFT_TO_RIGHT) {
            return false;
        }
        if (dirs == Directions.ALL_RIGHT_TO_LEFT) {
            return true;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (offset < start || offset >= limit) continue;
            int level = runs[i + 1] >>> 26 & 0x3F;
            return (level & 1) != 0;
        }
        return false;
    }

    private int getOffsetAtStartOf(int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        CharSequence text = this.mText;
        char c = text.charAt(offset);
        if (c >= '\udc00' && c <= '\udfff' && (c1 = text.charAt(offset - 1)) >= '\ud800' && c1 <= '\udbff') {
            --offset;
        }
        if (this.mSpannedText) {
            List<ReplacementSpan> spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (ReplacementSpan span : spans) {
                int start = ((Spanned)text).getSpanStart(span);
                int end = ((Spanned)text).getSpanEnd(span);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    public int getOffsetToLeftOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, true);
    }

    public int getOffsetToRightOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getOffsetToLeftRightOf(int caret, boolean toLeft) {
        boolean advance;
        int line = this.getLineForOffset(caret);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int lineDir = this.getParagraphDirection(line);
        boolean lineChanged = false;
        boolean bl = advance = toLeft == (lineDir == -1);
        if (advance) {
            if (caret == lineEnd) {
                if (line >= this.getLineCount() - 1) return caret;
                lineChanged = true;
                ++line;
            }
        } else if (caret == lineStart) {
            if (line <= 0) return caret;
            lineChanged = true;
            --line;
        }
        if (lineChanged) {
            lineStart = this.getLineStart(line);
            lineEnd = this.getLineEnd(line);
            int newDir = this.getParagraphDirection(line);
            if (newDir != lineDir) {
                toLeft = !toLeft;
                lineDir = newDir;
            }
        }
        Directions directions = this.getLineDirections(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, lineStart, lineEnd, lineDir, directions, false, null, this.getEllipsisStart(line), this.getEllipsisStart(line) + this.getEllipsisCount(line));
        caret = lineStart + tl.getOffsetToLeftRightOf(caret - lineStart, toLeft);
        tl.recycle();
        return caret;
    }

    private int getParagraphLeadingMargin(int line) {
        int lineEnd;
        int spanEnd;
        if (!this.mSpannedText) {
            return 0;
        }
        Spanned spanned = (Spanned)this.mText;
        int lineStart = this.getLineStart(line);
        List<LeadingMarginSpan> spans = Layout.getParagraphSpans(spanned, lineStart, spanEnd = spanned.nextSpanTransition(lineStart, lineEnd = this.getLineEnd(line), LeadingMarginSpan.class), LeadingMarginSpan.class);
        if (spans.isEmpty()) {
            return 0;
        }
        int margin = 0;
        boolean useFirstLineMargin = lineStart == 0 || spanned.charAt(lineStart - 1) == '\n';
        for (LeadingMarginSpan span : spans) {
            int count;
            if (!(span instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
            int spStart = spanned.getSpanStart(span);
            int spanLine = this.getLineForOffset(spStart);
            useFirstLineMargin |= line < spanLine + (count = ((LeadingMarginSpan.LeadingMarginSpan2)span).getLeadingMarginLineCount());
        }
        for (LeadingMarginSpan span : spans) {
            margin += span.getLeadingMargin(useFirstLineMargin);
        }
        return margin;
    }

    private int getParagraphTrailingMargin(int line) {
        int lineEnd;
        int spanEnd;
        if (!this.mSpannedText) {
            return 0;
        }
        Spanned spanned = (Spanned)this.mText;
        int lineStart = this.getLineStart(line);
        List<TrailingMarginSpan> spans = Layout.getParagraphSpans(spanned, lineStart, spanEnd = spanned.nextSpanTransition(lineStart, lineEnd = this.getLineEnd(line), TrailingMarginSpan.class), TrailingMarginSpan.class);
        if (spans.isEmpty()) {
            return 0;
        }
        int margin = 0;
        for (TrailingMarginSpan span : spans) {
            margin += span.getTrailingMargin();
        }
        return margin;
    }

    private boolean shouldClampCursor(int line) {
        return switch (this.getParagraphAlignment(line)) {
            case Alignment.ALIGN_LEFT -> true;
            case Alignment.ALIGN_NORMAL -> {
                if (this.getParagraphDirection(line) > 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public float getLineLeft(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == null) {
            align = Alignment.ALIGN_CENTER;
        }
        switch (switch (align) {
            case Alignment.ALIGN_NORMAL -> dir == -1 ? Alignment.ALIGN_RIGHT : Alignment.ALIGN_LEFT;
            case Alignment.ALIGN_OPPOSITE -> dir == -1 ? Alignment.ALIGN_LEFT : Alignment.ALIGN_RIGHT;
            case Alignment.ALIGN_CENTER -> Alignment.ALIGN_CENTER;
            case Alignment.ALIGN_RIGHT -> Alignment.ALIGN_RIGHT;
            default -> Alignment.ALIGN_LEFT;
        }) {
            case ALIGN_CENTER: {
                int left = this.getParagraphLeft(line);
                float max = this.getLineMax(line);
                return (float)Math.floor((float)left + ((float)this.mWidth - max) / 2.0f);
            }
            case ALIGN_RIGHT: {
                return (float)this.mWidth - this.getLineMax(line);
            }
        }
        return 0.0f;
    }

    public float getLineRight(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == null) {
            align = Alignment.ALIGN_CENTER;
        }
        switch (switch (align) {
            case Alignment.ALIGN_NORMAL -> dir == -1 ? Alignment.ALIGN_RIGHT : Alignment.ALIGN_LEFT;
            case Alignment.ALIGN_OPPOSITE -> dir == -1 ? Alignment.ALIGN_LEFT : Alignment.ALIGN_RIGHT;
            case Alignment.ALIGN_CENTER -> Alignment.ALIGN_CENTER;
            case Alignment.ALIGN_RIGHT -> Alignment.ALIGN_RIGHT;
            default -> Alignment.ALIGN_LEFT;
        }) {
            case ALIGN_CENTER: {
                int right = this.getParagraphRight(line);
                float max = this.getLineMax(line);
                return (float)Math.ceil((float)right - ((float)this.mWidth - max) / 2.0f);
            }
            case ALIGN_RIGHT: {
                return this.mWidth;
            }
        }
        return this.getLineMax(line);
    }

    public void getCursorPath(int point, @NonNull FloatArrayList dest, @NonNull CharSequence buffer) {
        dest.clear();
        if (point < 0) {
            return;
        }
        int line = this.getLineForOffset(point);
        int top = this.getLineTop(line);
        int bottom = this.getLineBottom(line);
        boolean clamped = this.shouldClampCursor(line);
        float h1 = this.getPrimaryHorizontal(point, clamped) - 0.5f;
        int caps = TextKeyListener.getMetaState(buffer, 1);
        int fn = TextKeyListener.getMetaState(buffer, 4);
        int dist = bottom - top >> 3;
        top += dist;
        bottom -= dist;
        if (caps != 0 || fn != 0) {
            dist = bottom - top >> 2;
            if (fn != 0) {
                top += dist;
            }
            if (caps != 0) {
                bottom -= dist;
            }
        } else {
            dist = 0;
        }
        if (h1 < 0.5f) {
            h1 = 0.5f;
        }
        dest.add(h1);
        dest.add((float)top);
        dest.add(h1);
        dest.add((float)bottom);
        if (caps == 1) {
            dest.add(h1);
            dest.add((float)bottom);
            dest.add(h1 - (float)dist * 0.7f);
            dest.add((float)(bottom + dist));
            dest.add(h1 - (float)dist * 0.7f);
            dest.add((float)(bottom + dist) - 0.5f);
            dest.add(h1 + (float)dist * 0.7f);
            dest.add((float)(bottom + dist) - 0.5f);
            dest.add(h1 + (float)dist * 0.7f);
            dest.add((float)(bottom + dist));
            dest.add(h1);
            dest.add((float)bottom);
        }
        if (fn == 1) {
            dest.add(h1);
            dest.add((float)top);
            dest.add(h1 - (float)dist * 0.7f);
            dest.add((float)(top - dist));
            dest.add(h1 - (float)dist * 0.7f);
            dest.add((float)(top - dist) + 0.5f);
            dest.add(h1 + (float)dist * 0.7f);
            dest.add((float)(top - dist) + 0.5f);
            dest.add(h1 + (float)dist * 0.7f);
            dest.add((float)(top - dist));
            dest.add(h1);
            dest.add((float)top);
        }
    }

    private void addSelection(int line, int start, int end, int top, int bottom, FloatArrayList out) {
        int linestart = this.getLineStart(line);
        int lineend = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (lineend > linestart && this.mText.charAt(lineend - 1) == '\n') {
            --lineend;
        }
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            int en;
            int st;
            int here = linestart + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            if (there > lineend) {
                there = lineend;
            }
            if (start > there || end < here || (st = Math.max(start, here)) == (en = Math.min(end, there))) continue;
            float h1 = this.getHorizontal(st, false, line, false);
            float h2 = this.getHorizontal(en, true, line, false);
            float left = Math.min(h1, h2);
            float right = Math.max(h1, h2);
            out.add(left);
            out.add((float)top);
            out.add(right);
            out.add((float)bottom);
        }
    }

    public void getSelectionPath(int start, int end, @NonNull FloatArrayList dest) {
        dest.clear();
        if (start == end) {
            return;
        }
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        int startline = this.getLineForOffset(start);
        int endline = this.getLineForOffset(end);
        int top = this.getLineTop(startline);
        int bottom = this.getLineBottom(endline);
        if (startline == endline) {
            this.addSelection(startline, start, end, top, bottom, dest);
        } else {
            float width = this.mWidth;
            this.addSelection(startline, start, this.getLineEnd(startline), top, this.getLineBottom(startline), dest);
            if (this.getParagraphDirection(startline) == -1) {
                dest.add(0.0f);
                dest.add((float)top);
                dest.add(this.getLineLeft(startline));
                dest.add((float)this.getLineBottom(startline));
            } else {
                dest.add(this.getLineRight(startline));
                dest.add((float)top);
                dest.add(width);
                dest.add((float)this.getLineBottom(startline));
            }
            for (int i = startline + 1; i < endline; ++i) {
                top = this.getLineTop(i);
                bottom = this.getLineBottom(i);
                dest.add(0.0f);
                dest.add((float)top);
                dest.add(width);
                dest.add((float)bottom);
            }
            top = this.getLineTop(endline);
            bottom = this.getLineBottom(endline);
            this.addSelection(endline, this.getLineStart(endline), end, top, bottom, dest);
            if (this.getParagraphDirection(endline) == -1) {
                dest.add(this.getLineRight(endline));
                dest.add((float)top);
                dest.add(width);
                dest.add((float)bottom);
            } else {
                dest.add(0.0f);
                dest.add((float)top);
                dest.add(this.getLineLeft(endline));
                dest.add((float)bottom);
            }
        }
    }

    public static float getDesiredWidth(CharSequence source, TextPaint paint) {
        return Layout.getDesiredWidth(source, 0, source.length(), paint);
    }

    public static float getDesiredWidth(CharSequence source, int start, int end, TextPaint paint) {
        return Layout.getDesiredWidth(source, start, end, paint, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    public static float getDesiredWidth(CharSequence source, int start, int end, TextPaint paint, TextDirectionHeuristic textDir) {
        return Layout.getDesiredWidthWithLimit(source, start, end, paint, textDir, Float.MAX_VALUE);
    }

    public static float getDesiredWidthWithLimit(CharSequence source, int start, int end, TextPaint paint, TextDirectionHeuristic textDir, float upperLimit) {
        float need = 0.0f;
        int i = start;
        while (i <= end) {
            float w;
            int next = TextUtils.indexOf(source, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if ((w = Layout.measurePara(paint, source, i, next, textDir)) > upperLimit) {
                return upperLimit;
            }
            if (w > need) {
                need = w;
            }
            i = ++next;
        }
        return need;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float measurePara(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        MeasuredParagraph mt = null;
        TextLine tl = TextLine.obtain();
        try {
            mt = MeasuredParagraph.buildForBidi(text, start, end, textDir, null);
            char[] chars = mt.getChars();
            int len = chars.length;
            Directions directions = mt.getDirections(0, len);
            int dir = mt.getParagraphDir();
            boolean hasTabs = false;
            TabStops tabStops = null;
            int margin = 0;
            if (text instanceof Spanned) {
                Spanned spanned = (Spanned)text;
                List<LeadingMarginSpan> leadingMarginSpans = Layout.getParagraphSpans(spanned, start, end, LeadingMarginSpan.class);
                for (LeadingMarginSpan leadingMarginSpan : leadingMarginSpans) {
                    margin += leadingMarginSpan.getLeadingMargin(true);
                }
                List<TrailingMarginSpan> trailingMarginSpans = Layout.getParagraphSpans(spanned, start, end, TrailingMarginSpan.class);
                for (TrailingMarginSpan tms : trailingMarginSpans) {
                    margin += tms.getTrailingMargin();
                }
            }
            for (char c : chars) {
                int spanEnd;
                Spanned spanned;
                List<TabStopSpan> spans;
                if (c != '\t') continue;
                hasTabs = true;
                if (!(text instanceof Spanned) || (spans = Layout.getParagraphSpans(spanned = (Spanned)text, start, spanEnd = spanned.nextSpanTransition(start, end, TabStopSpan.class), TabStopSpan.class)).isEmpty()) break;
                tabStops = new TabStops(20.0f, spans);
                break;
            }
            tl.set(paint, text, start, end, dir, directions, hasTabs, tabStops, 0, 0);
            float f = (float)margin + Math.abs(tl.metrics(null));
            return f;
        }
        finally {
            tl.recycle();
            if (mt != null) {
                mt.recycle();
            }
        }
    }

    @NonNull
    static <T> List<T> getParagraphSpans(@NonNull Spanned text, int start, int end, Class<T> type) {
        if (start == end && start > 0) {
            return Collections.emptyList();
        }
        if (text instanceof SpannableStringBuilder) {
            return ((SpannableStringBuilder)text).getSpans(start, end, type, false, null);
        }
        return text.getSpans(start, end, type);
    }

    private void ellipsize(int start, int end, int line, char[] dest, int destoff, TextUtils.TruncateAt method) {
        int ellipsisCount = this.getEllipsisCount(line);
        if (ellipsisCount == 0) {
            return;
        }
        int ellipsisStart = this.getEllipsisStart(line);
        int lineStart = this.getLineStart(line);
        String ellipsisString = TextUtils.getEllipsisString(method);
        int ellipsisStringLen = ellipsisString.length();
        boolean useEllipsisString = ellipsisCount >= ellipsisStringLen;
        int min = Math.max(0, start - ellipsisStart - lineStart);
        int max = Math.min(ellipsisCount, end - ellipsisStart - lineStart);
        for (int i = min; i < max; ++i) {
            int c = useEllipsisString && i < ellipsisStringLen ? (int)ellipsisString.charAt(i) : 65279;
            int a = i + ellipsisStart + lineStart;
            dest[destoff + a - start] = c;
        }
    }

    public static enum Alignment {
        ALIGN_NORMAL,
        ALIGN_OPPOSITE,
        ALIGN_CENTER,
        ALIGN_LEFT,
        ALIGN_RIGHT;

    }

    private class HorizontalMeasurementProvider {
        private final int mLine;
        private final boolean mPrimary;
        private float[] mHorizontals;
        private int mLineStartOffset;

        HorizontalMeasurementProvider(int line, boolean primary) {
            this.mLine = line;
            this.mPrimary = primary;
            this.init();
        }

        private void init() {
            Directions dirs = Layout.this.getLineDirections(this.mLine);
            if (dirs == Directions.ALL_LEFT_TO_RIGHT) {
                return;
            }
            this.mHorizontals = Layout.this.getLineHorizontals(this.mLine, false, this.mPrimary);
            this.mLineStartOffset = Layout.this.getLineStart(this.mLine);
        }

        float get(int offset) {
            int index = offset - this.mLineStartOffset;
            if (this.mHorizontals == null || index < 0 || index >= this.mHorizontals.length) {
                return Layout.this.getHorizontal(offset, this.mPrimary);
            }
            return this.mHorizontals[index];
        }
    }

    static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned {
        private final Spanned mSpanned;

        public SpannedEllipsizer(CharSequence display) {
            super(display);
            this.mSpanned = (Spanned)display;
        }

        @Override
        @NonNull
        public <T> List<T> getSpans(int start, int end, Class<? extends T> type, @Nullable List<T> out) {
            return this.mSpanned.getSpans(start, end, type, out);
        }

        @Override
        public int getSpanStart(@NonNull Object tag) {
            return this.mSpanned.getSpanStart(tag);
        }

        @Override
        public int getSpanEnd(@NonNull Object tag) {
            return this.mSpanned.getSpanEnd(tag);
        }

        @Override
        public int getSpanFlags(@NonNull Object tag) {
            return this.mSpanned.getSpanFlags(tag);
        }

        @Override
        public int nextSpanTransition(int start, int limit, Class<?> type) {
            return this.mSpanned.nextSpanTransition(start, limit, type);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            SpannableString ss = new SpannableString(new String(s));
            TextUtils.copySpansFrom(this.mSpanned, start, end, Object.class, ss, 0);
            return ss;
        }
    }

    static class Ellipsizer
    implements CharSequence,
    GetChars {
        CharSequence mText;
        Layout mLayout;
        int mWidth;
        TextUtils.TruncateAt mMethod;

        public Ellipsizer(CharSequence s) {
            this.mText = s;
        }

        @Override
        public char charAt(int off) {
            char[] buf = TextUtils.obtain(1);
            this.getChars(off, off + 1, buf, 0);
            char ret = buf[0];
            TextUtils.recycle(buf);
            return ret;
        }

        @Override
        public void getChars(int start, int end, char[] dest, int destoff) {
            int line1 = this.mLayout.getLineForOffset(start);
            int line2 = this.mLayout.getLineForOffset(end);
            TextUtils.getChars(this.mText, start, end, dest, destoff);
            for (int i = line1; i <= line2; ++i) {
                this.mLayout.ellipsize(start, end, i, dest, destoff, this.mMethod);
            }
        }

        @Override
        public int length() {
            return this.mText.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            return new String(s);
        }

        @Override
        public String toString() {
            char[] s = new char[this.length()];
            this.getChars(0, this.length(), s, 0);
            return new String(s);
        }
    }
}

