/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import icyllis.arc3d.core.PixelUtils;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Typeface;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.graphics.BitmapFactory;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontMetricsInt;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GLFontAtlas;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Unmodifiable;
import org.lwjgl.opengl.GL33C;

public class BitmapFont
implements Font,
AutoCloseable {
    public static final int MAX_ATLAS_DIMENSION = 128;
    public static final int FONT_TEXTURE_SIZE = 256;
    private final ResourceLocation mName;
    private Bitmap mBitmap;
    private final Int2ObjectOpenHashMap<Glyph> mGlyphs = new Int2ObjectOpenHashMap();
    @SharedPtr
    private GLTexture mTexture;
    private Int2ObjectOpenHashMap<GLBakedGlyph> mBakedGlyphs;
    private final int mAscent;
    private final int mDescent;
    private final int mSpriteWidth;
    private final int mSpriteHeight;
    private final float mScaleFactor;
    private final int[][] mCodepointGrid;

    private BitmapFont(ResourceLocation name, Bitmap bitmap, int[][] grid, int rows, int cols, int height, int ascent) {
        boolean useDedicatedTexture;
        this.mName = name;
        this.mBitmap = bitmap;
        this.mAscent = ascent;
        this.mDescent = height - ascent;
        this.mSpriteWidth = bitmap.getWidth() / cols;
        this.mSpriteHeight = bitmap.getHeight() / rows;
        this.mScaleFactor = (float)height / (float)this.mSpriteHeight;
        this.mCodepointGrid = grid;
        boolean isEmpty = height <= 0 || this.mSpriteWidth <= 0 || this.mSpriteHeight <= 0 || this.mSpriteWidth > 256 || this.mSpriteHeight > 256 || bitmap.getWidth() > Short.MAX_VALUE || bitmap.getHeight() > Short.MAX_VALUE;
        boolean bl = useDedicatedTexture = !isEmpty && (this.mSpriteWidth > 128 || this.mSpriteHeight > 128);
        if (useDedicatedTexture) {
            this.mBakedGlyphs = new Int2ObjectOpenHashMap();
        }
        int numEmptyGlyphs = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Glyph glyph;
                int ch = grid[r][c];
                if (ch == 0) {
                    ++numEmptyGlyphs;
                    continue;
                }
                int actualWidth = BitmapFont.getActualGlyphWidth(bitmap, this.mSpriteWidth, this.mSpriteHeight, c, r);
                if (actualWidth <= 0) {
                    ++numEmptyGlyphs;
                }
                if (this.mGlyphs.put(ch, (Object)(glyph = new Glyph((int)(0.5 + (double)((float)actualWidth * this.mScaleFactor)) + 1, c * this.mSpriteWidth, r * this.mSpriteHeight, actualWidth <= 0))) != null) {
                    ModernUI.LOGGER.warn(GlyphManager.MARKER, "Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(ch), (Object)this.mName);
                }
                if (!useDedicatedTexture) continue;
                GLBakedGlyph bakedGlyph = new GLBakedGlyph();
                this.setGlyphMetrics(bakedGlyph);
                bakedGlyph.u1 = (float)(c * this.mSpriteWidth) / (float)this.getTextureWidth();
                bakedGlyph.v1 = (float)(r * this.mSpriteHeight) / (float)this.getTextureHeight();
                bakedGlyph.u2 = (float)(c * this.mSpriteWidth + this.mSpriteWidth) / (float)this.getTextureWidth();
                bakedGlyph.v2 = (float)(r * this.mSpriteHeight + this.mSpriteHeight) / (float)this.getTextureHeight();
                this.mBakedGlyphs.put(ch, (Object)bakedGlyph);
            }
        }
        if (isEmpty || numEmptyGlyphs == cols * rows) {
            this.mBitmap.close();
            this.mBitmap = null;
            this.mBakedGlyphs = null;
        }
    }

    @Nonnull
    public static BitmapFont create(BitmapProvider.Definition definition, ResourceManager manager) {
        BitmapFont bitmapFont;
        block10: {
            int height = definition.f_285660_();
            int ascent = definition.f_285577_();
            if (ascent > height) {
                throw new JsonParseException("Ascent " + ascent + " higher than height " + height);
            }
            int[][] grid = definition.f_285611_();
            if (grid.length == 0 || grid[0].length == 0) {
                throw new JsonParseException("Expected to find data in chars, found none.");
            }
            int rows = grid.length;
            int cols = grid[0].length;
            ResourceLocation file = definition.f_285631_();
            ResourceLocation location = file.m_246208_("textures/");
            InputStream stream = manager.m_215595_(location);
            try {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inPreferredFormat = Bitmap.Format.RGBA_8888;
                Bitmap bitmap = BitmapFactory.decodeStream(stream, opts);
                Objects.requireNonNull(bitmap);
                bitmapFont = new BitmapFont(file, bitmap, grid, rows, cols, height, ascent);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return bitmapFont;
    }

    private static int getActualGlyphWidth(Bitmap bitmap, int width, int height, int col, int row) {
        int i;
        for (i = width - 1; i >= 0; --i) {
            int x = col * width + i;
            for (int j = 0; j < height; ++j) {
                int y = row * height + j;
                if (bitmap.getPixelARGB(x, y) >>> 24 == 0) continue;
                return i + 1;
            }
        }
        return i + 1;
    }

    private void createTexture() {
        assert (this.mBitmap != null);
        ImmediateContext context = Core.requireImmediateContext();
        ImageDesc desc = context.getCaps().getDefaultColorImageDesc(1, this.mBitmap.getColorType(), this.getTextureWidth(), this.getTextureHeight(), 1, 8);
        Objects.requireNonNull(desc);
        this.mTexture = (GLTexture)context.getResourceProvider().findOrCreateImage(desc, true, this.mName.toString());
        if (this.mTexture == null) {
            ModernUI.LOGGER.error(GlyphManager.MARKER, "Failed to create font texture for {}", (Object)this.mName);
            return;
        }
        boolean res = ((GLDevice)context.getDevice()).writePixels(this.mTexture, 0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mBitmap.getColorType(), this.mBitmap.getColorType(), this.mBitmap.getRowBytes(), this.mBitmap.getAddress());
        assert (res);
        int boundTexture = GL33C.glGetInteger((int)32873);
        GL33C.glBindTexture((int)3553, (int)this.mTexture.getHandle());
        GL33C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL33C.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL33C.glBindTexture((int)3553, (int)boundTexture);
    }

    public void dumpAtlas(int index, String path) {
        ModernUI.LOGGER.info(GlyphManager.MARKER, "BitmapFont {}: {}, ascent: {}, descent: {}, numGlyphs: {}, nothingToDraw: {}, fitsInAtlas: {}, dedicatedTexture: {}", (Object)index, (Object)this.mName, (Object)this.getAscent(), (Object)this.getDescent(), (Object)this.mGlyphs.size(), (Object)this.nothingToDraw(), (Object)this.fitsInAtlas(), (Object)this.mTexture);
        if (path != null && this.mTexture != null && Core.isOnRenderThread()) {
            GLFontAtlas.dumpAtlas((GLCaps)Core.requireImmediateContext().getCaps(), this.mTexture, Bitmap.Format.RGBA_8888, path);
        }
    }

    @Override
    public int getStyle() {
        return 0;
    }

    @Override
    public String getFullName(@Nonnull Locale locale) {
        return this.mName.toString();
    }

    @Override
    public String getFamilyName(@Nonnull Locale locale) {
        return this.mName.toString();
    }

    @Override
    public int getMetrics(@Nonnull FontPaint paint, FontMetricsInt fm) {
        return 0;
    }

    @Nullable
    public Glyph getGlyph(int ch) {
        return (Glyph)this.mGlyphs.get(ch);
    }

    public boolean nothingToDraw() {
        return this.mBitmap == null;
    }

    public boolean fitsInAtlas() {
        return this.mBakedGlyphs == null;
    }

    private int getTextureWidth() {
        assert (this.mBitmap != null);
        return Math.max(this.mBitmap.getWidth(), 256);
    }

    private int getTextureHeight() {
        assert (this.mBitmap != null);
        return Math.max(this.mBitmap.getHeight(), 256);
    }

    public void setGlyphMetrics(@Nonnull GLBakedGlyph glyph) {
        glyph.x = 0;
        glyph.y = -this.mAscent * 8;
        glyph.width = (short)MathUtil.clamp(Math.round((float)this.mSpriteWidth * this.mScaleFactor * 8.0f), 0, Short.MAX_VALUE);
        glyph.height = (short)MathUtil.clamp(Math.round((float)this.mSpriteHeight * this.mScaleFactor * 8.0f), 0, Short.MAX_VALUE);
    }

    public boolean getGlyphImage(int ch, long dst) {
        assert (this.mBitmap != null);
        Glyph src = this.getGlyph(ch);
        if (src == null || src.isEmpty) {
            return false;
        }
        int dstRowBytes = this.mSpriteWidth * this.mBitmap.getFormat().getBytesPerPixel();
        PixelUtils.copyImage(this.mBitmap.getPixmap().getAddress(src.offsetX, src.offsetY), this.mBitmap.getRowBytes(), dst, dstRowBytes, dstRowBytes, this.mSpriteHeight);
        return true;
    }

    @Nullable
    public GLBakedGlyph getBakedGlyph(int ch) {
        assert (this.mBitmap != null && this.mBakedGlyphs != null);
        GLBakedGlyph glyph = (GLBakedGlyph)this.mBakedGlyphs.get(ch);
        if (glyph != null && this.mTexture == null) {
            this.createTexture();
        }
        return glyph;
    }

    public int getCurrentTexture() {
        return this.mTexture != null ? this.mTexture.getHandle() : 0;
    }

    public int getAscent() {
        return this.mAscent;
    }

    public int getDescent() {
        return this.mDescent;
    }

    public int getSpriteWidth() {
        return this.mSpriteWidth;
    }

    public int getSpriteHeight() {
        return this.mSpriteHeight;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public @Unmodifiable int[][] getCodepointGrid() {
        return this.mCodepointGrid;
    }

    @Override
    public boolean hasGlyph(int ch, int vs) {
        return this.mGlyphs.containsKey(ch);
    }

    @Override
    public float doSimpleLayout(char[] buf, int start, int limit, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float x, float y) {
        return this.doComplexLayout(buf, start, limit, start, limit, false, paint, glyphs, positions, null, 0, null, x, y);
    }

    @Override
    public float doComplexLayout(char[] buf, int contextStart, int contextLimit, int layoutStart, int layoutLimit, boolean isRtl, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float[] advances, int advanceOffset, Rect bounds, float x, float y) {
        float scaleUp = (int)((double)(paint.getFontSize() / TextLayoutProcessor.sBaseFontSize) + 0.5);
        float advance = 0.0f;
        for (int index = layoutStart; index < layoutLimit; ++index) {
            int ch;
            int i = index;
            int _c1 = buf[index];
            if (Character.isHighSurrogate((char)_c1) && index + 1 < layoutLimit) {
                char _c2 = buf[index + 1];
                if (Character.isLowSurrogate(_c2)) {
                    ch = Character.toCodePoint((char)_c1, _c2);
                    ++index;
                } else {
                    ch = _c1;
                }
            } else {
                ch = _c1;
            }
            Glyph glyph = this.getGlyph(ch);
            if (glyph == null) continue;
            float adv = glyph.advance * scaleUp;
            if (advances != null) {
                advances[i - advanceOffset] = adv;
            }
            if (glyphs != null) {
                glyphs.add(ch);
            }
            if (positions != null) {
                positions.add(x + advance + scaleUp * 0.5f);
                positions.add(y);
            }
            advance += adv;
        }
        return advance;
    }

    @Override
    public Typeface getNativeTypeface() {
        return null;
    }

    public int hashCode() {
        int result = this.mName.hashCode();
        result = 31 * result + this.mAscent;
        result = 31 * result + this.mDescent;
        result = 31 * result + Arrays.deepHashCode((Object[])this.mCodepointGrid);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapFont that = (BitmapFont)o;
        if (this.mAscent != that.mAscent) {
            return false;
        }
        if (this.mDescent != that.mDescent) {
            return false;
        }
        if (!this.mName.equals((Object)that.mName)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.mCodepointGrid, (Object[])that.mCodepointGrid);
    }

    @Override
    public void close() {
        if (this.mBitmap != null) {
            this.mBitmap.close();
            this.mBitmap = null;
        }
        this.mTexture = RefCnt.move(this.mTexture);
    }

    public static class Glyph
    implements GlyphInfo {
        public final float advance;
        public final short offsetX;
        public final short offsetY;
        public final boolean isEmpty;

        public Glyph(int advance, int offsetX, int offsetY, boolean isEmpty) {
            this.advance = advance;
            this.offsetX = (short)offsetX;
            this.offsetY = (short)offsetY;
            this.isEmpty = isEmpty;
        }

        public float m_7403_() {
            return this.advance;
        }

        @Nonnull
        public BakedGlyph m_213604_(@Nonnull Function<SheetGlyphInfo, BakedGlyph> function) {
            return EmptyGlyph.f_232594_;
        }
    }
}

