/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.testforge.trash;

import icyllis.modernui.mc.testforge.trash.GLVertexAttrib;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.opengl.GL45C;

public final class GLVertexFormat {
    private final GLVertexAttrib[][] mAttributeSets;
    private int mVertexArray = 0;

    public GLVertexFormat(GLVertexAttrib ... attribs) {
        int len = attribs.length;
        if (len == 0) {
            throw new IllegalArgumentException("No attribs");
        }
        Arrays.sort(attribs, Comparator.comparingInt(GLVertexAttrib::getBinding));
        this.mAttributeSets = new GLVertexAttrib[attribs[len - 1].getBinding() + 1][];
        int pos = 0;
        int binding = 0;
        for (int i = 0; i <= len; ++i) {
            GLVertexAttrib attr2;
            GLVertexAttrib gLVertexAttrib = attr2 = i < len ? attribs[i] : null;
            if (attr2 != null && binding == attr2.getBinding()) continue;
            GLVertexAttrib[] attributes = new GLVertexAttrib[i - pos];
            int j = pos;
            int k = 0;
            while (j < i) {
                attributes[k] = attribs[j];
                ++j;
                ++k;
            }
            this.mAttributeSets[binding] = attributes;
            if (attr2 == null) break;
            pos = i;
            for (j = binding + 1; j < attr2.getBinding(); ++j) {
                this.mAttributeSets[j] = new GLVertexAttrib[0];
            }
            binding = attr2.getBinding();
        }
    }

    public int getVertexArray() {
        if (this.mVertexArray == 0) {
            this.mVertexArray = GL45C.glCreateVertexArrays();
            this.setFormat(this.mVertexArray);
        }
        return this.mVertexArray;
    }

    public void setFormat(int array) {
        int location = 0;
        for (GLVertexAttrib[] attributes : this.mAttributeSets) {
            int offset = 0;
            for (GLVertexAttrib attr2 : attributes) {
                offset = attr2.setFormat(array, location, offset);
                location += attr2.getLocationSize();
            }
        }
    }

    public int getMaxBinding() {
        return this.mAttributeSets.length - 1;
    }

    public void setVertexBuffer(int binding, int buffer, int offset) {
        GL45C.glVertexArrayVertexBuffer((int)this.getVertexArray(), (int)binding, (int)buffer, (long)offset, (int)this.getBindingSize(binding));
    }

    public void setBindingDivisor(int binding, int divisor) {
        GL45C.glVertexArrayBindingDivisor((int)this.getVertexArray(), (int)binding, (int)divisor);
    }

    public void setIndexBuffer(int buffer) {
        GL45C.glVertexArrayElementBuffer((int)this.getVertexArray(), (int)buffer);
    }

    public int getBindingSize(int binding) {
        int size = 0;
        for (GLVertexAttrib attributes : this.mAttributeSets[binding]) {
            size += attributes.getTotalSize();
        }
        return size;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.mAttributeSets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.mAttributeSets, (Object[])((GLVertexFormat)o).mAttributeSets);
    }
}

