/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.testforge.shader;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.mc.testforge.shader.GLProgram;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.opengl.GL43C;

@Deprecated
public final class ShaderShard {
    private static final Object2ObjectMap<ResourceLocation, ShaderShard> SHADERS = new Object2ObjectAVLTreeMap();
    private final ResourceLocation mLocation;
    private final int mId;
    private int mAttachCount = 0;
    private boolean mDeleted = false;

    private ShaderShard(ResourceLocation location, int id2) {
        this.mLocation = location;
        this.mId = id2;
    }

    public void attach(@Nonnull GLProgram program) {
        if (this.mAttachCount == Integer.MIN_VALUE) {
            throw new IllegalStateException(this + " has been deleted.");
        }
        ++this.mAttachCount;
        GL43C.glAttachShader((int)program.get(), (int)this.mId);
        if (this.mDeleted) {
            ModernUI.LOGGER.warn(ModernUI.MARKER, "{} is marked as deleted, but the shader is still trying to attach to program {}", (Object)this, (Object)program);
        }
    }

    public void detach(@Nonnull GLProgram program) {
        if (this.mAttachCount > 0) {
            --this.mAttachCount;
            GL43C.glDetachShader((int)program.get(), (int)this.mId);
            if (this.mAttachCount == 0 && this.mDeleted) {
                SHADERS.remove((Object)this.mLocation);
                this.mAttachCount = Integer.MIN_VALUE;
            }
        } else {
            ModernUI.LOGGER.warn(ModernUI.MARKER, "Try to detach {} from {}, but the shader is not attached to any program", (Object)this, (Object)program);
        }
    }

    public int getAttachCount() {
        return this.mAttachCount;
    }

    public void delete() {
        if (!this.mDeleted) {
            GL43C.glDeleteShader((int)this.mId);
            if (this.mAttachCount <= 0) {
                SHADERS.remove((Object)this.mLocation);
                this.mAttachCount = Integer.MIN_VALUE;
            }
            this.mDeleted = true;
        }
    }

    @RenderThread
    public static ShaderShard getOrCreate(ResourceManager manager, ResourceLocation location, Type type) throws IOException {
        ShaderShard shader;
        block9: {
            shader = (ShaderShard)SHADERS.get((Object)location);
            if (shader != null) {
                return shader;
            }
            try (InputStream stream = manager.m_215595_(location);){
                CharSequence src = null;
                if (src != null) {
                    int id2 = GL43C.glCreateShader((int)type.type);
                    GL43C.glShaderSource((int)id2, src);
                    GL43C.glCompileShader((int)id2);
                    if (GL43C.glGetShaderi((int)id2, (int)35713) == 1) {
                        shader = new ShaderShard(location, id2);
                        SHADERS.put((Object)location, (Object)shader);
                        break block9;
                    }
                    String y = GL43C.glGetShaderInfoLog((int)id2, (int)32768).trim();
                    throw new IOException("Failed to compile " + type.getName() + " shader (" + location + ") : " + y);
                }
                throw new IOException("Failed to read shader source (" + location + ")");
            }
        }
        return shader;
    }

    public static void deleteAll() {
        SHADERS.values().forEach(ShaderShard::delete);
        if (!SHADERS.isEmpty()) {
            throw new IllegalStateException("There are still " + SHADERS.size() + " shaders attaching to some programs.");
        }
    }

    public static enum Type {
        VERTEX(35633),
        FRAGMENT(35632),
        GEOMETRY(36313),
        TESS_CONTROL(36488),
        TESS_EVALUATION(36487),
        COMPUTE(37305);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        @Nonnull
        private String getName() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        }
    }
}

