/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.forge;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class PacketBuffer
extends FriendlyByteBuf {
    private final ResourceLocation mName;

    PacketBuffer(ResourceLocation name) {
        super(Unpooled.buffer());
        this.mName = name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer() {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
        } else {
            this.release();
        }
    }

    public void sendToPlayer(@Nonnull Player player) {
        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToPlayer(@Nonnull ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToPlayers(@Nonnull Iterable<? extends Player> players) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this);
        for (Player player : players) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)packet);
        }
    }

    public void sendToAll() {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11268_((Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToDimension(@Nonnull ResourceKey<Level> dimension) {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11270_((Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this), dimension);
    }

    public void sendToNear(@Nullable Player excluded, double x, double y, double z, double radius, @Nonnull ResourceKey<Level> dimension) {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11241_(excluded, x, y, z, radius, dimension, (Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToTrackingEntity(@Nonnull Entity entity) {
        ((ServerLevel)entity.m_9236_()).m_7726_().m_8445_(entity, (Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToTrackingAndSelf(@Nonnull Entity entity) {
        ((ServerLevel)entity.m_9236_()).m_7726_().m_8394_(entity, (Packet)new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this));
    }

    public void sendToTrackingChunk(@Nonnull Level level, @Nonnull BlockPos pos) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this);
        ((ServerLevel)level).m_7726_().f_8325_.m_183262_(level.m_46865_(pos).m_7697_(), false).forEach(arg_0 -> PacketBuffer.lambda$sendToTrackingChunk$0((Packet)packet, arg_0));
    }

    public void sendToTrackingChunk(@Nonnull LevelChunk chunk) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(this.mName, (FriendlyByteBuf)this);
        ((ServerLevel)chunk.m_62953_()).m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(arg_0 -> PacketBuffer.lambda$sendToTrackingChunk$1((Packet)packet, arg_0));
    }

    private static /* synthetic */ void lambda$sendToTrackingChunk$1(Packet packet, ServerPlayer p) {
        p.f_8906_.m_9829_(packet);
    }

    private static /* synthetic */ void lambda$sendToTrackingChunk$0(Packet packet, ServerPlayer p) {
        p.f_8906_.m_9829_(packet);
    }
}

