/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.forge;

import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.forge.MenuScreen;
import icyllis.modernui.mc.forge.ModernUIForge;
import icyllis.modernui.mc.forge.NetworkHandler;
import icyllis.modernui.mc.forge.OpenMenuEvent;
import icyllis.modernui.mc.forge.PacketBuffer;
import icyllis.modernui.mc.forge.UIManagerForge;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.ApiStatus;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Internal
public class NetworkMessages
extends NetworkHandler {
    private static final int S2C_OPEN_MENU = 0;
    static NetworkHandler sNetwork;

    NetworkMessages() {
        super(ModernUIMod.location("network"), "360", true);
    }

    static PacketBuffer openMenu(@Nonnull AbstractContainerMenu menu, @Nullable Consumer<FriendlyByteBuf> writer) {
        PacketBuffer buf = sNetwork.buffer(0);
        buf.m_130130_(menu.f_38840_);
        buf.m_130130_(BuiltInRegistries.f_256818_.m_7447_((Object)menu.m_6772_()));
        if (writer != null) {
            writer.accept(buf);
        }
        return buf;
    }

    static NetworkMessages client() {
        return new Client();
    }

    static final class Client
    extends NetworkMessages {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Client() {
        }

        @Override
        protected void handleClientMessage(int index, @Nonnull FriendlyByteBuf payload, @Nonnull Supplier<NetworkEvent.Context> source, @Nonnull BlockableEventLoop<?> looper) {
            if (index == 0) {
                Client.openMenu(payload, source, looper);
            }
        }

        private static void openMenu(@Nonnull FriendlyByteBuf payload, @Nonnull Supplier<NetworkEvent.Context> source, @Nonnull BlockableEventLoop<?> looper) {
            int containerId = payload.m_130242_();
            MenuType type = (MenuType)BuiltInRegistries.f_256818_.m_200957_(payload.m_130242_());
            ResourceLocation key = BuiltInRegistries.f_256818_.m_7981_((Object)type);
            if (!$assertionsDisabled && key == null) {
                throw new AssertionError();
            }
            payload.retain();
            looper.execute(() -> {
                try {
                    LocalPlayer p = Client.getClientPlayer(source);
                    if (p != null) {
                        AbstractContainerMenu menu = type.create(containerId, p.m_150109_(), payload);
                        OpenMenuEvent event = new OpenMenuEvent(menu);
                        ModernUIForge.post(key.m_135827_(), event);
                        Fragment fragment = event.getFragment();
                        if (fragment == null) {
                            p.m_6915_();
                        } else {
                            p.f_36096_ = menu;
                            Minecraft.m_91087_().m_91152_(new MenuScreen<AbstractContainerMenu>(UIManagerForge.getInstance(), fragment, null, menu, p.m_150109_(), CommonComponents.f_237098_));
                        }
                    }
                }
                finally {
                    payload.release();
                }
            });
        }

        static {
            boolean bl = $assertionsDisabled = !NetworkMessages.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }
    }
}

