/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import icyllis.modernui.mc.MinecraftSurfaceView;
import icyllis.modernui.mc.MuiScreen;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MinecraftDrawHandler {
    private final WeakReference<MinecraftSurfaceView> mViewWeakRef;
    final Properties mStagingProperties = new Properties();
    private final Properties mProperties = new Properties();
    MuiScreen mOwnerScreen;

    public MinecraftDrawHandler(WeakReference<MinecraftSurfaceView> viewWeakRef) {
        this.mViewWeakRef = viewWeakRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTick, Window window) {
        MinecraftSurfaceView view = (MinecraftSurfaceView)this.mViewWeakRef.get();
        if (view == null) {
            return;
        }
        Properties p = this.mProperties;
        if (p.mHidden) {
            return;
        }
        MinecraftSurfaceView.Renderer renderer = view.mRenderer;
        if (renderer == null) {
            return;
        }
        if (p.mAlpha < 0.01f) {
            return;
        }
        gr.m_280262_();
        int rtHeight = window.m_85442_();
        double guiScale = window.m_85449_();
        PoseStack mvs = RenderSystem.getModelViewStack();
        mvs.m_85836_();
        mvs.m_85837_((double)p.mPositionLeft / guiScale, (double)p.mPositionTop / guiScale, 0.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableScissor((int)p.mPositionLeft, (int)(rtHeight - (p.mPositionTop + p.mSurfaceHeight)), (int)p.mSurfaceWidth, (int)p.mSurfaceHeight);
        try {
            renderer.onDraw(gr, mouseX, mouseY, deltaTick, guiScale, p.mAlpha);
        }
        finally {
            mvs.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.disableScissor();
        }
    }

    public void syncProperties() {
        MinecraftSurfaceView view = (MinecraftSurfaceView)this.mViewWeakRef.get();
        if (view == null) {
            return;
        }
        MinecraftSurfaceView.Renderer renderer = view.mRenderer;
        if (renderer == null) {
            return;
        }
        boolean sizeChanged = this.mProperties.set(this.mStagingProperties);
        if (sizeChanged) {
            renderer.onSurfaceChanged(this.mProperties.mSurfaceWidth, this.mProperties.mSurfaceHeight);
        }
    }

    public static class Properties {
        public boolean mHidden;
        public float mAlpha;
        public int mPositionLeft;
        public int mPositionTop;
        public int mSurfaceWidth;
        public int mSurfaceHeight;

        public boolean set(Properties p) {
            this.mHidden = p.mHidden;
            this.mAlpha = p.mAlpha;
            this.mPositionLeft = p.mPositionLeft;
            this.mPositionTop = p.mPositionTop;
            boolean sizeChanged = this.mSurfaceWidth != p.mSurfaceWidth || this.mSurfaceHeight != p.mSurfaceHeight;
            this.mSurfaceWidth = p.mSurfaceWidth;
            this.mSurfaceHeight = p.mSurfaceHeight;
            return sizeChanged;
        }
    }

    public static class Operation {
        public static final int OP_ADD = 0;
        public static final int OP_REMOVE = 1;
        public static final int OP_UPDATE = 2;
        public final int mOp;
        public final MinecraftDrawHandler mTarget;

        public Operation(int op, MinecraftDrawHandler target) {
            this.mOp = op;
            this.mTarget = target;
        }
    }
}

