/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.TooltipRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public class ExtendedGuiGraphics {
    private final GuiGraphics guiGraphics;
    private final MultiBufferSource.BufferSource bufferSource;
    private int mColorTL = -1;
    private int mColorTR = -1;
    private int mColorBR = -1;
    private int mColorBL = -1;
    private float mDepth = 0.0f;
    private float mWidth = 1.0f;

    public ExtendedGuiGraphics(@Nonnull GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.bufferSource = guiGraphics.m_280091_();
    }

    public PoseStack pose() {
        return this.guiGraphics.m_280168_();
    }

    public void setColor(int color) {
        this.mColorTL = color;
        this.mColorTR = color;
        this.mColorBR = color;
        this.mColorBL = color;
    }

    public void setGradient(@Nonnull Orientation orientation, int startColor, int endColor) {
        int midColor = TooltipRenderer.lerpInLinearSpace(0.5f, startColor, endColor);
        switch (orientation) {
            case TOP_BOTTOM: {
                this.mColorTL = startColor;
                this.mColorTR = startColor;
                this.mColorBR = endColor;
                this.mColorBL = endColor;
                break;
            }
            case TR_BL: {
                this.mColorTL = midColor;
                this.mColorTR = startColor;
                this.mColorBR = midColor;
                this.mColorBL = endColor;
                break;
            }
            case RIGHT_LEFT: {
                this.mColorTL = endColor;
                this.mColorTR = startColor;
                this.mColorBR = startColor;
                this.mColorBL = endColor;
                break;
            }
            case BR_TL: {
                this.mColorTL = endColor;
                this.mColorTR = midColor;
                this.mColorBR = startColor;
                this.mColorBL = midColor;
                break;
            }
            case BOTTOM_TOP: {
                this.mColorTL = endColor;
                this.mColorTR = endColor;
                this.mColorBR = startColor;
                this.mColorBL = startColor;
                break;
            }
            case BL_TR: {
                this.mColorTL = midColor;
                this.mColorTR = endColor;
                this.mColorBR = midColor;
                this.mColorBL = startColor;
                break;
            }
            case LEFT_RIGHT: {
                this.mColorTL = startColor;
                this.mColorTR = endColor;
                this.mColorBR = endColor;
                this.mColorBL = startColor;
                break;
            }
            case TL_BR: {
                this.mColorTL = startColor;
                this.mColorTR = midColor;
                this.mColorBR = endColor;
                this.mColorBL = midColor;
            }
        }
    }

    public float getDepth() {
        return this.mDepth;
    }

    public void setDepth(float depth) {
        this.mDepth = depth;
    }

    public float getStrokeWidth() {
        return this.mWidth;
    }

    public void setStrokeWidth(float width) {
        if (width >= 0.0f) {
            this.mWidth = width;
        }
    }

    public void fillCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, -1.0f);
    }

    public void strokeCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, this.mWidth * 0.5f);
    }

    public void fillRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, -1.0f);
    }

    public void strokeRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, this.mWidth * 0.5f);
    }

    private void drawRoundRect(float left, float top, float right, float bottom, float depth, float radius, float thickness) {
        ShaderInstance shader;
        if (!(left < right) || !(top < bottom)) {
            return;
        }
        if (thickness == 0.0f) {
            return;
        }
        if (!Float.isFinite(radius) || radius < 0.0f) {
            radius = 0.0f;
        }
        if ((shader = GuiRenderType.getShaderRoundRect()) == null) {
            return;
        }
        Matrix4f pose = this.guiGraphics.m_280168_().m_85850_().m_252922_();
        float centerX = (left + right) * 0.5f;
        float centerY = (top + bottom) * 0.5f;
        float extentX = (right - left) * 0.5f;
        float extentY = (bottom - top) * 0.5f;
        radius = Math.min(radius, Math.min(extentX, extentY));
        float outset = 1.0f + thickness;
        if ((pose.properties() & 8) != 0) {
            shader.m_173356_("u_Rect").m_5805_(centerX + pose.m30(), centerY + pose.m31(), extentX, extentY);
            shader.m_173356_("u_Radii").m_7971_(radius, thickness);
            VertexConsumer buffer = this.bufferSource.m_6299_(GuiRenderType.roundRect());
            buffer.m_252986_(pose, left - outset, top - outset, depth).m_193479_(this.mColorTL).m_5752_();
            buffer.m_252986_(pose, left - outset, bottom + outset, depth).m_193479_(this.mColorBL).m_5752_();
            buffer.m_252986_(pose, right + outset, bottom + outset, depth).m_193479_(this.mColorBR).m_5752_();
            buffer.m_252986_(pose, right + outset, top - outset, depth).m_193479_(this.mColorTR).m_5752_();
            this.guiGraphics.m_280262_();
        } else {
            this.guiGraphics.m_280262_();
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_252931_(pose);
            RenderSystem.applyModelViewMatrix();
            shader.m_173356_("u_Rect").m_5805_(centerX, centerY, extentX, extentY);
            shader.m_173356_("u_Radii").m_7971_(radius, thickness);
            VertexConsumer buffer = this.bufferSource.m_6299_(GuiRenderType.roundRect());
            buffer.m_5483_((double)(left - outset), (double)(top - outset), (double)depth).m_193479_(this.mColorTL).m_5752_();
            buffer.m_5483_((double)(left - outset), (double)(bottom + outset), (double)depth).m_193479_(this.mColorBL).m_5752_();
            buffer.m_5483_((double)(right + outset), (double)(bottom + outset), (double)depth).m_193479_(this.mColorBR).m_5752_();
            buffer.m_5483_((double)(right + outset), (double)(top - outset), (double)depth).m_193479_(this.mColorTR).m_5752_();
            this.guiGraphics.m_280262_();
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }
}

