/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.modernui.annotation.ColorInt;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Size;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.MathUtil;
import org.jetbrains.annotations.ApiStatus;

public class Color {
    @ColorInt
    public static final int TRANSPARENT = 0;
    public static final int COLOR_CHANNEL_R = 0;
    public static final int COLOR_CHANNEL_G = 1;
    public static final int COLOR_CHANNEL_B = 2;
    public static final int COLOR_CHANNEL_A = 3;
    public static final int COLOR_CHANNEL_FLAG_RED = 1;
    public static final int COLOR_CHANNEL_FLAG_GREEN = 2;
    public static final int COLOR_CHANNEL_FLAG_BLUE = 4;
    public static final int COLOR_CHANNEL_FLAG_ALPHA = 8;
    public static final int COLOR_CHANNEL_FLAG_GRAY = 16;
    public static final int COLOR_CHANNEL_FLAGS_RG = 3;
    public static final int COLOR_CHANNEL_FLAGS_RGB = 7;
    public static final int COLOR_CHANNEL_FLAGS_RGBA = 15;

    public static int alpha(@ColorInt int color) {
        return color >>> 24;
    }

    public static int red(@ColorInt int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(@ColorInt int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(@ColorInt int color) {
        return color & 0xFF;
    }

    @ColorInt
    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @ColorInt
    public static int rgb(float red, float green, float blue) {
        return 0xFF000000 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    @ColorInt
    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @ColorInt
    public static int argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    @ColorInt
    public static int parseColor(@NonNull String colorString) {
        int index;
        if (colorString.startsWith("#")) {
            index = 1;
        } else if (colorString.startsWith("0x") || colorString.startsWith("0X")) {
            index = 2;
        } else {
            throw new IllegalArgumentException("Unknown color prefix: " + colorString);
        }
        int length = colorString.length() - index;
        if (length != 6 && length != 8) {
            throw new IllegalArgumentException("Unknown color: " + colorString);
        }
        int color = Integer.parseUnsignedInt(colorString, index, index + length, 16);
        if (length == 6) {
            color |= 0xFF000000;
        }
        return color;
    }

    public static void RGBToHSV(int r, int g, int b, float[] hsv) {
        int min;
        int max = Math.max(r, Math.max(g, b));
        int delta = max - (min = Math.min(r, Math.min(g, b)));
        if (delta == 0) {
            hsv[0] = 0.0f;
            hsv[1] = 0.0f;
            hsv[2] = (float)max / 255.0f;
            return;
        }
        float h = max == r ? (float)(g - b) / (float)delta : (max == g ? 2.0f + (float)(b - r) / (float)delta : 4.0f + (float)(r - g) / (float)delta);
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        hsv[0] = h;
        hsv[1] = (float)delta / (float)max;
        hsv[2] = (float)max / 255.0f;
    }

    public static void RGBToHSV(int color, float[] hsv) {
        Color.RGBToHSV(Color.red(color), Color.green(color), Color.blue(color), hsv);
    }

    public static int HSVToColor(float h, float s, float v) {
        float g;
        float r;
        s = MathUtil.clamp(s, 0.0f, 1.0f);
        v = MathUtil.clamp(v, 0.0f, 1.0f);
        if (s <= 9.765625E-4f) {
            int i = (int)(v * 255.0f + 0.5f);
            return i << 16 | i << 8 | i;
        }
        float hx = h < 0.0f || h >= 360.0f ? 0.0f : h / 60.0f;
        int w = (int)hx;
        float f = hx - (float)w;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        return (int)(r * 255.0f + 0.5f) << 16 | (int)(g * 255.0f + 0.5f) << 8 | (int)((switch (w) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        }) * 255.0f + 0.5f);
    }

    public static int HSVToColor(float[] hsv) {
        return Color.HSVToColor(hsv[0], hsv[1], hsv[2]);
    }

    public static float GammaToLinear(float x) {
        return (double)x < 0.04045 ? x / 12.92f : (float)Math.pow(((double)x + 0.055) / 1.055, 2.4);
    }

    public static float LinearToGamma(float x) {
        return (double)x < 0.0031308049535603713 ? x * 12.92f : (float)Math.pow(x, 0.4166666666666667) * 1.055f - 0.055f;
    }

    public static void GammaToLinear(float[] col) {
        col[0] = Color.GammaToLinear(col[0]);
        col[1] = Color.GammaToLinear(col[1]);
        col[2] = Color.GammaToLinear(col[2]);
    }

    public static void LinearToGamma(float[] col) {
        col[0] = Color.LinearToGamma(col[0]);
        col[1] = Color.LinearToGamma(col[1]);
        col[2] = Color.LinearToGamma(col[2]);
    }

    public static float luminance(float r, float g, float b) {
        return 0.2126f * r + 0.7152f * g + 0.0722f * b;
    }

    public static float luminance(float[] col) {
        return Color.luminance(col[0], col[1], col[2]);
    }

    public static float lightness(float lum) {
        return (double)lum <= 0.008856451679035631 ? lum * 24389.0f / 27.0f : (float)Math.pow(lum, 0.3333333333333333) * 116.0f - 16.0f;
    }

    @ApiStatus.Internal
    @ColorInt
    public static int blend(@NonNull BlendMode mode, @ColorInt int src, @ColorInt int dst) {
        return icyllis.arc3d.core.Color.blend(mode.getNativeBlendMode(), src, dst);
    }

    @ApiStatus.Internal
    public static boolean equals_within_tolerance(@Size(value=4L) float[] colA, @Size(value=4L) float[] colB, float tol) {
        for (int i = 0; i < 4; ++i) {
            if (Math.abs(colA[i] - colB[i]) <= tol) continue;
            return false;
        }
        return true;
    }
}

