/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.fragment;

import icyllis.modernui.annotation.CallSuper;
import icyllis.modernui.core.CancellationSignal;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.fragment.FragmentManager;
import icyllis.modernui.fragment.FragmentStateManager;
import icyllis.modernui.fragment.SpecialEffectsControllerFactory;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class SpecialEffectsController {
    private final ViewGroup mContainer;
    final ArrayList<Operation> mPendingOperations = new ArrayList();
    final ArrayList<Operation> mRunningOperations = new ArrayList();
    boolean mOperationDirectionIsPop = false;
    boolean mIsContainerPostponed = false;

    @Nonnull
    static SpecialEffectsController getOrCreateController(@Nonnull ViewGroup container, @Nonnull FragmentManager fragmentManager) {
        SpecialEffectsControllerFactory factory = fragmentManager.getSpecialEffectsControllerFactory();
        return SpecialEffectsController.getOrCreateController(container, factory);
    }

    @Nonnull
    static SpecialEffectsController getOrCreateController(@Nonnull ViewGroup container, @Nonnull SpecialEffectsControllerFactory factory) {
        Object controller = container.getTag(0x2020003);
        if (controller instanceof SpecialEffectsController) {
            return (SpecialEffectsController)controller;
        }
        SpecialEffectsController newController = factory.createController(container);
        container.setTag(0x2020003, newController);
        return newController;
    }

    SpecialEffectsController(@Nonnull ViewGroup container) {
        this.mContainer = container;
    }

    @Nonnull
    public ViewGroup getContainer() {
        return this.mContainer;
    }

    @Nullable
    Operation.LifecycleImpact getAwaitingCompletionLifecycleImpact(@Nonnull FragmentStateManager fragmentStateManager) {
        Operation runningOperation;
        Operation.LifecycleImpact lifecycleImpact = null;
        Operation pendingOperation = this.findPendingOperation(fragmentStateManager.getFragment());
        if (pendingOperation != null) {
            lifecycleImpact = pendingOperation.getLifecycleImpact();
        }
        if ((runningOperation = this.findRunningOperation(fragmentStateManager.getFragment())) != null && (lifecycleImpact == null || lifecycleImpact == Operation.LifecycleImpact.NONE)) {
            return runningOperation.getLifecycleImpact();
        }
        return lifecycleImpact;
    }

    @Nullable
    private Operation findPendingOperation(@Nonnull Fragment fragment) {
        for (Operation operation : this.mPendingOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    @Nullable
    private Operation findRunningOperation(@Nonnull Fragment fragment) {
        for (Operation operation : this.mRunningOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    void enqueueAdd(@Nonnull Operation.State finalState, @Nonnull FragmentStateManager fragmentStateManager) {
        this.enqueue(finalState, Operation.LifecycleImpact.ADDING, fragmentStateManager);
    }

    void enqueueShow(@Nonnull FragmentStateManager fragmentStateManager) {
        this.enqueue(Operation.State.VISIBLE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    void enqueueHide(@Nonnull FragmentStateManager fragmentStateManager) {
        this.enqueue(Operation.State.GONE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    void enqueueRemove(@Nonnull FragmentStateManager fragmentStateManager) {
        this.enqueue(Operation.State.REMOVED, Operation.LifecycleImpact.REMOVING, fragmentStateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(@Nonnull Operation.State finalState, @Nonnull Operation.LifecycleImpact lifecycleImpact, @Nonnull FragmentStateManager fragmentStateManager) {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            CancellationSignal signal = new CancellationSignal();
            Operation existingOperation = this.findPendingOperation(fragmentStateManager.getFragment());
            if (existingOperation != null) {
                existingOperation.mergeWith(finalState, lifecycleImpact);
                return;
            }
            FragmentStateManagerOperation operation = new FragmentStateManagerOperation(finalState, lifecycleImpact, fragmentStateManager, signal);
            this.mPendingOperations.add(operation);
            operation.addCompletionListener(() -> {
                if (this.mPendingOperations.contains(operation)) {
                    operation.getFinalState().applyState(operation.getFragment().mView);
                }
            });
            operation.addCompletionListener(() -> {
                this.mPendingOperations.remove(operation);
                this.mRunningOperations.remove(operation);
            });
        }
    }

    void updateOperationDirection(boolean isPop) {
        this.mOperationDirectionIsPop = isPop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markPostponedState() {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            this.updateFinalState();
            this.mIsContainerPostponed = false;
            for (int index = this.mPendingOperations.size() - 1; index >= 0; --index) {
                Operation operation = this.mPendingOperations.get(index);
                Operation.State currentState = Operation.State.from(operation.getFragment().mView);
                if (operation.getFinalState() != Operation.State.VISIBLE || currentState == Operation.State.VISIBLE) continue;
                Fragment fragment = operation.getFragment();
                this.mIsContainerPostponed = fragment.isPostponed();
                break;
            }
        }
    }

    void forcePostponedExecutePendingOperations() {
        if (this.mIsContainerPostponed) {
            this.mIsContainerPostponed = false;
            this.executePendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePendingOperations() {
        if (this.mIsContainerPostponed) {
            return;
        }
        if (!this.mContainer.isAttachedToWindow()) {
            this.forceCompleteAllOperations();
            this.mOperationDirectionIsPop = false;
            return;
        }
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            if (!this.mPendingOperations.isEmpty()) {
                ArrayList<Operation> currentlyRunningOperations = new ArrayList<Operation>(this.mRunningOperations);
                this.mRunningOperations.clear();
                for (Operation operation : currentlyRunningOperations) {
                    operation.cancel();
                    if (operation.isComplete()) continue;
                    this.mRunningOperations.add(operation);
                }
                this.updateFinalState();
                ArrayList<Operation> newPendingOperations = new ArrayList<Operation>(this.mPendingOperations);
                this.mPendingOperations.clear();
                this.mRunningOperations.addAll(newPendingOperations);
                for (Operation operation : newPendingOperations) {
                    operation.onStart();
                }
                this.executeOperations(newPendingOperations, this.mOperationDirectionIsPop);
                this.mOperationDirectionIsPop = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCompleteAllOperations() {
        boolean attachedToWindow = this.mContainer.isAttachedToWindow();
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            this.updateFinalState();
            for (Operation operation : this.mPendingOperations) {
                operation.onStart();
            }
            ArrayList<Operation> runningOperations = new ArrayList<Operation>(this.mRunningOperations);
            for (Operation operation : runningOperations) {
                operation.cancel();
            }
            ArrayList<Operation> arrayList2 = new ArrayList<Operation>(this.mPendingOperations);
            for (Operation operation : arrayList2) {
                operation.cancel();
            }
        }
    }

    private void updateFinalState() {
        for (Operation operation : this.mPendingOperations) {
            if (operation.getLifecycleImpact() != Operation.LifecycleImpact.ADDING) continue;
            Fragment fragment = operation.getFragment();
            View view = fragment.requireView();
            Operation.State finalState = Operation.State.from(view.getVisibility());
            operation.mergeWith(finalState, Operation.LifecycleImpact.NONE);
        }
    }

    abstract void executeOperations(@Nonnull List<Operation> var1, boolean var2);

    static class Operation {
        @Nonnull
        private State mFinalState;
        @Nonnull
        private LifecycleImpact mLifecycleImpact;
        @Nonnull
        private final Fragment mFragment;
        @Nonnull
        private final List<Runnable> mCompletionListeners = new ArrayList<Runnable>();
        @Nonnull
        private final HashSet<CancellationSignal> mSpecialEffectsSignals = new HashSet();
        private boolean mIsCanceled = false;
        private boolean mIsComplete = false;

        Operation(@Nonnull State finalState, @Nonnull LifecycleImpact lifecycleImpact, @Nonnull Fragment fragment, @Nonnull CancellationSignal cancellationSignal) {
            this.mFinalState = finalState;
            this.mLifecycleImpact = lifecycleImpact;
            this.mFragment = fragment;
            cancellationSignal.setOnCancelListener(this::cancel);
        }

        @Nonnull
        public State getFinalState() {
            return this.mFinalState;
        }

        @Nonnull
        LifecycleImpact getLifecycleImpact() {
            return this.mLifecycleImpact;
        }

        @Nonnull
        public final Fragment getFragment() {
            return this.mFragment;
        }

        final boolean isCanceled() {
            return this.mIsCanceled;
        }

        @Nonnull
        public String toString() {
            return "Operation {" + Integer.toHexString(System.identityHashCode(this)) + "} {mFinalState = " + this.mFinalState + "} {mLifecycleImpact = " + this.mLifecycleImpact + "} {mFragment = " + this.mFragment + "}";
        }

        final void cancel() {
            if (this.isCanceled()) {
                return;
            }
            this.mIsCanceled = true;
            if (this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            } else {
                ArrayList<CancellationSignal> signals = new ArrayList<CancellationSignal>(this.mSpecialEffectsSignals);
                for (CancellationSignal signal : signals) {
                    signal.cancel();
                }
            }
        }

        final void mergeWith(@Nonnull State finalState, @Nonnull LifecycleImpact lifecycleImpact) {
            switch (lifecycleImpact) {
                case ADDING: {
                    if (this.mFinalState != State.REMOVED) break;
                    this.mFinalState = State.VISIBLE;
                    this.mLifecycleImpact = LifecycleImpact.ADDING;
                    break;
                }
                case REMOVING: {
                    this.mFinalState = State.REMOVED;
                    this.mLifecycleImpact = LifecycleImpact.REMOVING;
                    break;
                }
                case NONE: {
                    if (this.mFinalState == State.REMOVED) break;
                    this.mFinalState = finalState;
                }
            }
        }

        final void addCompletionListener(@Nonnull Runnable listener) {
            this.mCompletionListeners.add(listener);
        }

        void onStart() {
        }

        public final void markStartedSpecialEffect(@Nonnull CancellationSignal signal) {
            this.onStart();
            this.mSpecialEffectsSignals.add(signal);
        }

        public final void completeSpecialEffect(@Nonnull CancellationSignal signal) {
            if (this.mSpecialEffectsSignals.remove(signal) && this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            }
        }

        final boolean isComplete() {
            return this.mIsComplete;
        }

        @CallSuper
        public void complete() {
            if (this.mIsComplete) {
                return;
            }
            this.mIsComplete = true;
            for (Runnable listener : this.mCompletionListeners) {
                listener.run();
            }
        }

        static enum State {
            REMOVED,
            VISIBLE,
            GONE,
            INVISIBLE;


            @Nonnull
            static State from(@Nonnull View view) {
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    return INVISIBLE;
                }
                return State.from(view.getVisibility());
            }

            @Nonnull
            static State from(int visibility) {
                return switch (visibility) {
                    case 0 -> VISIBLE;
                    case 4 -> INVISIBLE;
                    case 8 -> GONE;
                    default -> throw new IllegalArgumentException("Unknown visibility " + visibility);
                };
            }

            void applyState(@Nonnull View view) {
                switch (this) {
                    case REMOVED: {
                        ViewGroup parent = (ViewGroup)view.getParent();
                        if (parent == null) break;
                        parent.removeView(view);
                        break;
                    }
                    case VISIBLE: {
                        view.setVisibility(0);
                        break;
                    }
                    case GONE: {
                        view.setVisibility(8);
                        break;
                    }
                    case INVISIBLE: {
                        view.setVisibility(4);
                    }
                }
            }
        }

        static enum LifecycleImpact {
            NONE,
            ADDING,
            REMOVING;

        }
    }

    private static class FragmentStateManagerOperation
    extends Operation {
        @Nonnull
        private final FragmentStateManager mFragmentStateManager;

        FragmentStateManagerOperation(@Nonnull Operation.State finalState, @Nonnull Operation.LifecycleImpact lifecycleImpact, @Nonnull FragmentStateManager fragmentStateManager, @Nonnull CancellationSignal cancellationSignal) {
            super(finalState, lifecycleImpact, fragmentStateManager.getFragment(), cancellationSignal);
            this.mFragmentStateManager = fragmentStateManager;
        }

        @Override
        void onStart() {
            if (this.getLifecycleImpact() == Operation.LifecycleImpact.ADDING) {
                View view;
                Fragment fragment = this.mFragmentStateManager.getFragment();
                View focusedView = fragment.mView.findFocus();
                if (focusedView != null) {
                    fragment.setFocusedView(focusedView);
                }
                if ((view = this.getFragment().requireView()).getParent() == null) {
                    this.mFragmentStateManager.addViewToContainer();
                    view.setAlpha(0.0f);
                }
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    view.setVisibility(4);
                }
                view.setAlpha(fragment.getPostOnViewCreatedAlpha());
            } else if (this.getLifecycleImpact() == Operation.LifecycleImpact.REMOVING) {
                Fragment fragment = this.mFragmentStateManager.getFragment();
                View view = fragment.requireView();
                view.clearFocus();
            }
        }

        @Override
        public void complete() {
            super.complete();
            this.mFragmentStateManager.moveToExpectedState();
        }
    }
}

