/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Message;
import icyllis.modernui.core.Monitor;
import icyllis.modernui.core.VideoMode;
import icyllis.modernui.core.Window;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.Selection;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewRoot;
import icyllis.modernui.widget.EditText;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

public final class ActivityWindow
extends Window {
    private static volatile ActivityWindow sMainWindow;
    private int mScreenX;
    private int mScreenY;
    private int mScreenWidth;
    private int mScreenHeight;
    private int mWidth;
    private int mHeight;
    private volatile ViewRoot mRoot;
    private int mButtonState;
    private final StringBuilder mCharInputBuffer = new StringBuilder();
    private final Runnable mCommitCharInput = this::commitCharInput;

    ActivityWindow(long handle) {
        super(handle);
        sMainWindow = this;
        GLFW.glfwSetWindowPosCallback((long)handle, this::onPosCallback);
        GLFW.glfwSetWindowSizeCallback((long)handle, this::onSizeCallback);
        GLFW.glfwSetWindowRefreshCallback((long)handle, this::onRefreshCallback);
        GLFW.glfwSetWindowFocusCallback((long)handle, this::onFocusCallback);
        GLFW.glfwSetWindowIconifyCallback((long)handle, this::onMinimizeCallback);
        GLFW.glfwSetWindowMaximizeCallback((long)handle, this::onMaximizeCallback);
        GLFW.glfwSetFramebufferSizeCallback((long)handle, this::onFramebufferSizeCallback);
        GLFW.glfwSetWindowContentScaleCallback((long)handle, this::onContentScaleCallback);
        GLFW.glfwSetKeyCallback((long)handle, this::onKeyCallback);
        GLFW.glfwSetCharCallback((long)handle, this::onCharCallback);
        GLFW.glfwSetMouseButtonCallback((long)handle, this::onMouseButtonCallback);
        GLFW.glfwSetCursorPosCallback((long)handle, this::onCursorPosCallback);
        GLFW.glfwSetScrollCallback((long)handle, this::onScrollCallback);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h = stack.mallocInt(1);
            GLFW.glfwGetWindowPos((long)handle, (IntBuffer)w, (IntBuffer)h);
            this.mScreenX = w.get(0);
            this.mScreenY = h.get(0);
            GLFW.glfwGetWindowSize((long)handle, (IntBuffer)w, (IntBuffer)h);
            this.mScreenWidth = w.get(0);
            this.mScreenHeight = h.get(0);
            GLFW.glfwGetFramebufferSize((long)handle, (IntBuffer)w, (IntBuffer)h);
            this.mWidth = w.get(0);
            this.mHeight = h.get(0);
        }
    }

    @NonNull
    public static ActivityWindow createMainWindow(@NonNull String title, int width, int height) {
        return ActivityWindow.createMainWindow(title, width, height, null);
    }

    @NonNull
    public static ActivityWindow createMainWindow(@NonNull String title, int width, int height, @Nullable Monitor monitor) {
        Core.checkMainThread();
        if (sMainWindow != null) {
            throw new IllegalStateException("Multiple main windows");
        }
        long handle = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)(monitor == null ? 0L : monitor.getHandle()), (long)0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create window");
        }
        return new ActivityWindow(handle);
    }

    private void onPosCallback(long w, int xPos, int yPos) {
        this.mScreenX = xPos;
        this.mScreenY = yPos;
    }

    @Override
    public int getScreenX() {
        return this.mScreenX;
    }

    @Override
    public int getScreenY() {
        return this.mScreenY;
    }

    private void onSizeCallback(long w, int width, int height) {
        this.mScreenWidth = width;
        this.mScreenHeight = height;
    }

    @Override
    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    private void onRefreshCallback(long w) {
    }

    private void onFocusCallback(long w, boolean focused) {
    }

    private void onMinimizeCallback(long w, boolean minimized) {
    }

    private void onMaximizeCallback(long w, boolean maximized) {
    }

    private void onFramebufferSizeCallback(long w, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        if (this.mRoot != null) {
            this.mRoot.mHandler.post(() -> {
                if (this.mWidth != 0 && this.mHeight != 0) {
                    this.mRoot.setFrame(this.mWidth, this.mHeight);
                }
            });
        }
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    private void onContentScaleCallback(long w, float xScale, float yScale) {
    }

    public void center(@NonNull Monitor monitor) {
        VideoMode mode = monitor.getCurrentMode();
        GLFW.glfwSetWindowPos((long)this.mHandle, (int)((mode.getWidth() - this.mScreenWidth) / 2 + monitor.getXPos()), (int)((mode.getHeight() - this.mScreenHeight) / 2 + monitor.getYPos()));
    }

    public void install(@NonNull ViewRoot root) {
        this.mRoot = root;
        root.setFrame(this.mWidth, this.mHeight);
    }

    private void onKeyCallback(long w, int key, int scancode, int action, int mods) {
        if (this.mRoot != null) {
            KeyEvent keyEvent = KeyEvent.obtain(Core.timeNanos(), action == 0 ? 1 : 0, key, 0, mods, scancode, 0);
            this.mRoot.enqueueInputEvent(keyEvent);
        }
    }

    private void onCharCallback(long w, int codepoint) {
        if (this.mRoot == null) {
            return;
        }
        if (codepoint == 0 || codepoint == 127) {
            return;
        }
        this.mCharInputBuffer.appendCodePoint(codepoint);
        Core.postOnMainThread(this.mCommitCharInput);
    }

    private void commitCharInput() {
        if (this.mCharInputBuffer.isEmpty()) {
            return;
        }
        String input = this.mCharInputBuffer.toString();
        this.mCharInputBuffer.setLength(0);
        Message msg = Message.obtain(this.mRoot.mHandler, () -> {
            View patt7541$temp;
            if (this.mRoot != null && (patt7541$temp = this.mRoot.getView().findFocus()) instanceof EditText) {
                EditText text = (EditText)patt7541$temp;
                Editable content = text.getText();
                int selStart = text.getSelectionStart();
                int selEnd = text.getSelectionEnd();
                if (selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection(content, Math.max(selStart, selEnd));
                    content.replace(Math.min(selStart, selEnd), Math.max(selStart, selEnd), input);
                }
            }
        });
        msg.setAsynchronous(true);
        msg.sendToTarget();
    }

    private void onMouseButtonCallback(long w, int button, int action, int mods) {
        double cursorY;
        double cursorX;
        if (this.mRoot == null) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            DoubleBuffer x = stack.mallocDouble(1);
            DoubleBuffer y = stack.mallocDouble(1);
            GLFW.glfwGetCursorPos((long)w, (DoubleBuffer)x, (DoubleBuffer)y);
            cursorX = x.get(0);
            cursorY = y.get(0);
        }
        long now = Core.timeNanos();
        float x = (float)(cursorX * (double)this.mWidth / (double)this.mScreenWidth);
        float y = (float)(cursorY * (double)this.mHeight / (double)this.mScreenHeight);
        int buttonState = 0;
        for (int i = 0; i < 5; ++i) {
            if (GLFW.glfwGetMouseButton((long)w, (int)i) != 1) continue;
            buttonState |= 1 << i;
        }
        this.mButtonState = buttonState;
        int actionButton = 1 << button;
        int n = action = action == 1 ? 0 : 1;
        if (action == 0 && (buttonState ^ actionButton) == 0 || action == 1 && buttonState == 0) {
            MotionEvent ev = MotionEvent.obtain(now, action, actionButton, x, y, mods, buttonState, 0);
            this.mRoot.enqueueInputEvent(ev);
        }
    }

    private void onCursorPosCallback(long w, double cursorX, double cursorY) {
        if (this.mRoot == null) {
            return;
        }
        long now = Core.timeNanos();
        float x = (float)(cursorX * (double)this.mWidth / (double)this.mScreenWidth);
        float y = (float)(cursorY * (double)this.mHeight / (double)this.mScreenHeight);
        MotionEvent event = MotionEvent.obtain(now, 7, x, y, 0);
        this.mRoot.enqueueInputEvent(event);
        if (this.mButtonState > 0) {
            event = MotionEvent.obtain(now, 2, 0, x, y, 0, this.mButtonState, 0);
            this.mRoot.enqueueInputEvent(event);
        }
    }

    private void onScrollCallback(long w, double deltaX, double deltaY) {
        double cursorY;
        double cursorX;
        if (this.mRoot == null) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            DoubleBuffer x = stack.mallocDouble(1);
            DoubleBuffer y = stack.mallocDouble(1);
            GLFW.glfwGetCursorPos((long)w, (DoubleBuffer)x, (DoubleBuffer)y);
            cursorX = x.get(0);
            cursorY = y.get(0);
        }
        int mods = 0;
        if (GLFW.glfwGetKey((long)w, (int)341) == 1 || GLFW.glfwGetKey((long)w, (int)345) == 1) {
            mods |= KeyEvent.META_CTRL_ON;
        }
        if (GLFW.glfwGetKey((long)w, (int)340) == 1 || GLFW.glfwGetKey((long)w, (int)344) == 1) {
            mods |= 1;
        }
        long now = Core.timeNanos();
        float x = (float)(cursorX * (double)this.mWidth / (double)this.mScreenWidth);
        float y = (float)(cursorY * (double)this.mHeight / (double)this.mScreenHeight);
        MotionEvent event = MotionEvent.obtain(now, 8, x, y, mods);
        event.setAxisValue(10, (float)deltaX);
        event.setAxisValue(9, (float)deltaY);
        this.mRoot.enqueueInputEvent(event);
    }
}

