/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.Sampler;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLUtil;
import javax.annotation.Nullable;

public final class GLSampler
extends Sampler {
    private final SamplerDesc mDesc;
    private int mSampler;

    private GLSampler(Context context, SamplerDesc desc) {
        super(context);
        this.mDesc = desc;
    }

    @Nullable
    @SharedPtr
    public static GLSampler create(Context context, SamplerDesc desc) {
        GLDevice device = (GLDevice)context.getDevice();
        GLSampler sampler = new GLSampler(context, desc);
        if (device.isOnExecutingThread()) {
            if (!sampler.initialize()) {
                sampler.unref();
                return null;
            }
        } else {
            device.executeRenderCall(dev -> {
                if (!sampler.isDestroyed() && !sampler.initialize()) {
                    sampler.setNonCacheable();
                }
            });
        }
        return sampler;
    }

    private boolean initialize() {
        GLDevice device = (GLDevice)this.getDevice();
        int sampler = device.getGL().glGenSamplers();
        if (sampler == 0) {
            return false;
        }
        int magFilter = GLUtil.toGLMagFilter(this.mDesc.getMagFilter());
        int minFilter = GLUtil.toGLMinFilter(this.mDesc.getMinFilter(), this.mDesc.getMipmapMode());
        int wrapX = GLUtil.toGLWrapMode(this.mDesc.getAddressModeX());
        int wrapY = GLUtil.toGLWrapMode(this.mDesc.getAddressModeY());
        int wrapZ = GLUtil.toGLWrapMode(this.mDesc.getAddressModeZ());
        device.getGL().glSamplerParameteri(sampler, 10240, magFilter);
        device.getGL().glSamplerParameteri(sampler, 10241, minFilter);
        device.getGL().glSamplerParameteri(sampler, 10242, wrapX);
        device.getGL().glSamplerParameteri(sampler, 10243, wrapY);
        device.getGL().glSamplerParameteri(sampler, 32882, wrapZ);
        if (device.getCaps().hasAnisotropySupport()) {
            float maxAnisotropy = Math.min((float)this.mDesc.getMaxAnisotropy(), device.getCaps().maxTextureMaxAnisotropy());
            assert (maxAnisotropy >= 1.0f);
            device.getGL().glSamplerParameterf(sampler, 34046, maxAnisotropy);
        }
        this.mSampler = sampler;
        return true;
    }

    @Override
    protected void onRelease() {
        ((GLDevice)this.getDevice()).executeRenderCall(dev -> {
            if (this.mSampler != 0) {
                dev.getGL().glDeleteSamplers(this.mSampler);
            }
            this.discard();
        });
    }

    public void discard() {
        this.mSampler = 0;
    }

    public int getHandle() {
        return this.mSampler;
    }
}

