/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.BlendInfo;
import icyllis.arc3d.engine.DepthStencilSettings;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.VertexInputLayout;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLGraphicsPipeline;
import icyllis.arc3d.opengl.GLInterface;
import icyllis.arc3d.opengl.GLProgram;
import icyllis.arc3d.opengl.GLUtil;
import icyllis.arc3d.opengl.GLVertexArray;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public class GLGraphicsPipelineBuilder {
    private final GLDevice mDevice;
    private final PipelineDesc mPipelineDesc;
    private ByteBuffer mFinalizedVertSource;
    private ByteBuffer mFinalizedFragSource;
    private byte mPrimitiveType;
    private VertexInputLayout mInputLayout;
    private String mInputLayoutLabel;
    private BlendInfo mBlendInfo;
    private DepthStencilSettings mDepthStencilSettings;
    private PipelineDesc.UniformBlockInfo[] mUniformBlockInfos;
    private PipelineDesc.SamplerInfo[] mSamplerInfos;
    private String mPipelineLabel;

    private GLGraphicsPipelineBuilder(GLDevice device, PipelineDesc pipelineDesc) {
        this.mDevice = device;
        this.mPipelineDesc = pipelineDesc;
    }

    @Nonnull
    @SharedPtr
    public static GLGraphicsPipeline createGraphicsPipeline(GLDevice device, PipelineDesc desc) {
        return new GLGraphicsPipeline(device, CompletableFuture.supplyAsync(() -> {
            GLGraphicsPipelineBuilder builder = new GLGraphicsPipelineBuilder(device, desc);
            builder.build();
            return builder;
        }));
    }

    private void build() {
        PipelineDesc.GraphicsPipelineInfo info = this.mPipelineDesc.createGraphicsPipelineInfo(this.mDevice);
        this.mPrimitiveType = info.mPrimitiveType;
        this.mInputLayout = info.mInputLayout;
        this.mInputLayoutLabel = info.mInputLayoutLabel;
        this.mBlendInfo = info.mBlendInfo;
        this.mDepthStencilSettings = info.mDepthStencilSettings;
        this.mUniformBlockInfos = info.mUniformBlockInfos;
        this.mSamplerInfos = info.mSamplerInfos;
        this.mFinalizedVertSource = GLGraphicsPipelineBuilder.toUTF8(info.mVertSource);
        this.mFinalizedFragSource = GLGraphicsPipelineBuilder.toUTF8(info.mFragSource);
        this.mPipelineLabel = info.mPipelineLabel;
    }

    @Nonnull
    public static ByteBuffer toUTF8(StringBuilder shaderString) {
        int len = shaderString.length();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)len);
        len = 0;
        len += MemoryUtil.memUTF8((CharSequence)shaderString, (boolean)false, (ByteBuffer)buffer, (int)len);
        assert (len == buffer.capacity() && len == buffer.remaining());
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finish(GLGraphicsPipeline dest) {
        Object label;
        if (this.mFinalizedVertSource == null || this.mFinalizedFragSource == null) {
            return false;
        }
        GLInterface gl = this.mDevice.getGL();
        int program = gl.glCreateProgram();
        if (program == 0) {
            return false;
        }
        int frag = GLUtil.glCompileShader(this.mDevice, 35632, this.mFinalizedFragSource, this.mDevice.getSharedResourceCache().getStats());
        if (frag == 0) {
            gl.glDeleteProgram(program);
            return false;
        }
        int vert = GLUtil.glCompileShader(this.mDevice, 35633, this.mFinalizedVertSource, this.mDevice.getSharedResourceCache().getStats());
        if (vert == 0) {
            gl.glDeleteProgram(program);
            gl.glDeleteShader(frag);
            return false;
        }
        gl.glAttachShader(program, vert);
        gl.glAttachShader(program, frag);
        gl.glLinkProgram(program);
        if (gl.glGetProgrami(program, 35714) == 0) {
            try {
                String log = gl.glGetProgramInfoLog(program);
                GLUtil.handleLinkError(this.mDevice.getLogger(), new String[]{"Vertex GLSL", "Fragment GLSL"}, new String[]{MemoryUtil.memUTF8((ByteBuffer)this.mFinalizedVertSource), MemoryUtil.memUTF8((ByteBuffer)this.mFinalizedFragSource)}, log);
                boolean bl = false;
                return bl;
            }
            finally {
                Reference.reachabilityFence(this.mFinalizedVertSource);
                Reference.reachabilityFence(this.mFinalizedFragSource);
                gl.glDeleteProgram(program);
                gl.glDeleteShader(frag);
                gl.glDeleteShader(vert);
            }
        }
        gl.glDetachShader(program, vert);
        gl.glDetachShader(program, frag);
        gl.glDeleteShader(frag);
        gl.glDeleteShader(vert);
        @SharedPtr GLVertexArray vertexArray = this.mDevice.findOrCreateVertexArray(this.mInputLayout, this.mInputLayoutLabel);
        if (vertexArray == null) {
            gl.glDeleteProgram(program);
            return false;
        }
        if (this.mDevice.getCaps().hasDebugSupport() && (label = this.mPipelineLabel) != null && !((String)label).isEmpty()) {
            label = "Arc3D_PIPE_" + (String)label;
            label = ((String)label).substring(0, Math.min(((String)label).length(), this.mDevice.getCaps().maxLabelLength()));
            gl.glObjectLabel(33506, program, (CharSequence)label);
        }
        if (!this.mDevice.getCaps().shaderCaps().mUseUniformBinding) {
            if (this.mUniformBlockInfos != null) {
                for (PipelineDesc.UniformBlockInfo uniformBlockInfo : this.mUniformBlockInfos) {
                    if (uniformBlockInfo.mVisibility == 0) continue;
                    int index = gl.glGetUniformBlockIndex(program, uniformBlockInfo.mBlockName);
                    assert (index != -1);
                    gl.glUniformBlockBinding(program, index, uniformBlockInfo.mBinding);
                }
            }
            if (this.mSamplerInfos != null && this.mSamplerInfos.length > 0) {
                gl.glUseProgram(program);
                for (PipelineDesc.SamplerInfo samplerInfo : this.mSamplerInfos) {
                    if (samplerInfo.mVisibility == 0) continue;
                    int location = gl.glGetUniformLocation(program, samplerInfo.mName);
                    assert (location != -1);
                    gl.glUniform1i(location, samplerInfo.mBinding);
                }
            }
        }
        dest.init(new GLProgram(this.mDevice, program), vertexArray, this.mPrimitiveType, this.mBlendInfo, this.mDepthStencilSettings);
        return true;
    }
}

