/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.compiler.GLSLVersion;
import icyllis.arc3d.compiler.TargetApi;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.ShaderCaps;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLInterface;
import icyllis.arc3d.opengl.GLUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.opengles.EXTBaseInstance;
import org.lwjgl.opengles.EXTBufferStorage;
import org.lwjgl.opengles.EXTCopyImage;
import org.lwjgl.opengles.EXTDrawElementsBaseVertex;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLES30;
import org.lwjgl.opengles.GLES31;
import org.lwjgl.opengles.GLES32;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.NVTextureBarrier;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public final class GLCaps_GLES
extends GLCaps
implements GLInterface {
    private boolean mDrawElementsBaseVertexEXT;
    private boolean mCopyImageSubDataEXT;

    @VisibleForTesting
    public GLCaps_GLES(ContextOptions options, Object capabilities) {
        super(options);
        int glslVersion;
        GLESCapabilities caps = (GLESCapabilities)capabilities;
        if (!caps.GLES30) {
            throw new UnsupportedOperationException("OpenGL ES 3.0 is unavailable");
        }
        Logger logger = (Logger)Objects.requireNonNullElse(options.mLogger, NOPLogger.NOP_LOGGER);
        if (caps.GL_NV_texture_barrier) {
            this.mTextureBarrierSupport = true;
            logger.info("Use NV_texture_barrier");
        } else {
            this.mTextureBarrierSupport = false;
        }
        this.mDSASupport = false;
        this.mDebugSupport = caps.GLES32;
        if (caps.GLES32) {
            this.mDrawElementsBaseVertexSupport = true;
            this.mDrawElementsBaseVertexEXT = false;
        } else if (caps.GL_EXT_draw_elements_base_vertex) {
            this.mDrawElementsBaseVertexSupport = true;
            this.mDrawElementsBaseVertexEXT = true;
            logger.info("Use EXT_draw_elements_base_vertex");
        } else {
            this.mDrawElementsBaseVertexSupport = false;
        }
        this.mBaseInstanceSupport = caps.GL_EXT_base_instance;
        if (this.mBaseInstanceSupport) {
            logger.info("Use EXT_base_instance");
        }
        if (caps.GLES32) {
            this.mCopyImageSupport = true;
            this.mCopyImageSubDataEXT = false;
        } else if (caps.GL_EXT_copy_image) {
            this.mCopyImageSupport = true;
            this.mCopyImageSubDataEXT = true;
            logger.info("Use EXT_copy_image");
        } else {
            this.mCopyImageSupport = false;
        }
        this.mTexStorageSupport = true;
        this.mViewCompatibilityClassSupport = false;
        this.mProgramBinarySupport = true;
        this.mProgramParameterSupport = true;
        this.mVertexAttribBindingSupport = caps.GLES31;
        this.mBufferStorageSupport = caps.GL_EXT_buffer_storage;
        if (this.mBufferStorageSupport) {
            logger.info("Use EXT_buffer_storage");
        }
        this.mMaxColorAttachments = Math.min(Math.min(this.glGetInteger(34852), this.glGetInteger(36063)), 8);
        this.mMinUniformBufferOffsetAlignment = this.glGetInteger(35380);
        this.mMinStorageBufferOffsetAlignment = this.glGetInteger(37087);
        String versionString = GLES20.glGetString((int)7938);
        String vendorString = GLES20.glGetString((int)7936);
        this.mVendor = GLUtil.findVendor(vendorString);
        this.mDriver = GLUtil.findDriver(this.mVendor, vendorString, versionString);
        logger.info("Identified OpenGL vendor: {}", (Object)this.mVendor);
        logger.info("Identified OpenGL driver: {}", (Object)this.mDriver);
        this.mMaxFragmentUniformVectors = GLES20.glGetInteger((int)36349);
        this.mMaxVertexAttributes = Math.min(32, GLES20.glGetInteger((int)34921));
        this.mInvalidateBufferType = 1;
        this.mInvalidateFramebufferSupport = true;
        this.mTransferPixelsToRowBytesSupport = true;
        this.mMustSyncGpuDuringDiscard = false;
        this.mMaxLabelLength = this.mDebugSupport ? GLES20.glGetInteger((int)33512) : 0;
        ShaderCaps shaderCaps = this.mShaderCaps;
        shaderCaps.mTargetApi = caps.GLES31 ? TargetApi.OPENGL_ES_3_1 : TargetApi.OPENGL_ES_3_0;
        if (caps.GLES32) {
            glslVersion = 320;
            logger.info("Using OpenGL ES 3.2 and GLSL 3.20");
        } else if (caps.GLES31) {
            glslVersion = 310;
            logger.info("Using OpenGL ES 3.1 and GLSL 3.10");
        } else {
            glslVersion = 300;
            logger.info("Using OpenGL ES 3.0 and GLSL 3.00");
        }
        this.mGLSLVersion = glslVersion;
        shaderCaps.mGLSLVersion = glslVersion == 320 ? GLSLVersion.GLSL_320_ES : (glslVersion == 310 ? GLSLVersion.GLSL_310_ES : GLSLVersion.GLSL_300_ES);
        this.initGLSL(caps, shaderCaps.mGLSLVersion);
        shaderCaps.mDualSourceBlendingSupport = caps.GL_EXT_blend_func_extended;
        if (shaderCaps.mDualSourceBlendingSupport) {
            logger.info("Use EXT_blend_func_extended");
        }
        if (caps.GL_NV_conservative_raster) {
            this.mConservativeRasterSupport = true;
            logger.info("Use NV_conservative_raster");
        }
        shaderCaps.mMaxFragmentSamplers = Math.min(32, GLES20.glGetInteger((int)34930));
        if (caps.GL_NV_blend_equation_advanced_coherent) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED_COHERENT;
            shaderCaps.mAdvBlendEqInteraction = 1;
            logger.info("Use NV_blend_equation_advanced_coherent");
        } else if (caps.GL_KHR_blend_equation_advanced_coherent) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED_COHERENT;
            this.mShaderCaps.mAdvBlendEqInteraction = 2;
            logger.info("Use KHR_blend_equation_advanced_coherent");
        } else if (caps.GL_NV_blend_equation_advanced) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED;
            this.mShaderCaps.mAdvBlendEqInteraction = 1;
            logger.info("Use NV_blend_equation_advanced");
        } else if (caps.GL_KHR_blend_equation_advanced) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED;
            this.mShaderCaps.mAdvBlendEqInteraction = 2;
            logger.info("Use KHR_blend_equation_advanced");
        }
        this.mAnisotropySupport = caps.GL_EXT_texture_filter_anisotropic;
        if (this.mAnisotropySupport) {
            this.mMaxTextureMaxAnisotropy = GLES30.glGetFloat((int)34047);
            logger.info("Use EXT_texture_filter_anisotropic");
        }
        this.mMaxTextureSize = GLES20.glGetInteger((int)3379);
        this.mMaxPreferredRenderTargetSize = this.mMaxRenderTargetSize = GLES20.glGetInteger((int)34024);
        if (!(caps.GLES32 || caps.GL_EXT_texture_border_clamp || caps.GL_NV_texture_border_clamp || caps.GL_OES_texture_border_clamp)) {
            this.mClampToBorderSupport = false;
        }
        this.mGpuTracingSupport = caps.GL_EXT_debug_marker;
        if (this.mGpuTracingSupport) {
            logger.info("Use EXT_debug_marker");
        }
        this.mDynamicStateArrayGeometryProcessorTextureSupport = true;
        if (this.mProgramBinarySupport) {
            int count = GLES20.glGetInteger((int)34814);
            if (count > 0) {
                this.mProgramBinaryFormats = new int[count];
                GLES20.glGetIntegerv((int)34815, (int[])this.mProgramBinaryFormats);
            } else {
                this.mProgramBinarySupport = false;
            }
        }
        this.mSPIRVSupport = false;
        this.initFormatTable(caps);
        assert (this.validateFormatTable());
        this.applyDriverWorkaround();
        this.finishInitialization(options);
    }

    private void initGLSL(GLESCapabilities caps, GLSLVersion version) {
        ShaderCaps shaderCaps = this.mShaderCaps;
        shaderCaps.mPreferFlatInterpolation = this.mVendor != GLUtil.GLVendor.QUALCOMM;
        shaderCaps.mNoPerspectiveInterpolationSupport = false;
        shaderCaps.mVertexIDSupport = true;
        shaderCaps.mInfinitySupport = true;
        shaderCaps.mNonConstantArrayIndexSupport = true;
        shaderCaps.mBitManipulationSupport = version.isAtLeast(GLSLVersion.GLSL_310_ES);
        shaderCaps.mFMASupport = version.isAtLeast(GLSLVersion.GLSL_320_ES);
        shaderCaps.mUseUniformBinding = caps.GLES31;
        shaderCaps.mUseVaryingLocation = caps.GLES32;
        shaderCaps.mUseBlockMemberOffset = false;
        shaderCaps.mUsePrecisionModifiers = true;
    }

    void initFormatTable(GLESCapabilities caps) {
        super.initFormatTable(true, caps.GL_EXT_texture_compression_s3tc);
        int nonMSAARenderFlags = 2;
        int msaaRenderFlags = 6;
        GLCaps.FormatInfo info = this.getFormatInfo(36194);
        info.mFlags |= 0x11;
        info.mFlags |= 6;
        info = this.mFormatTable[6];
        info.mFlags |= 6;
        info = this.getFormatInfo(37492);
        info.mFlags |= 1;
        for (GLCaps.FormatInfo info2 : this.mFormatTable) {
            if ((info2.mFlags & 4) != 0) {
                assert ((info2.mFlags & 2) != 0);
                int glFormat = info2.mInternalFormatForRenderbuffer;
                int count = GLES30.glGetInternalformati((int)36161, (int)glFormat, (int)37760);
                if (count <= 0) continue;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer temp = stack.mallocInt(count);
                    GLES30.glGetInternalformativ((int)36161, (int)glFormat, (int)32937, (IntBuffer)temp);
                    if (temp.get(count - 1) == 1) assert (--count == 0 || temp.get(count - 1) > 1);
                    info2.mColorSampleCounts = new int[count + 1];
                    info2.mColorSampleCounts[0] = 1;
                    for (int j = 0; j < count; ++j) {
                        info2.mColorSampleCounts[j + 1] = temp.get(count - j - 1);
                    }
                    continue;
                }
            }
            if ((info2.mFlags & 2) == 0) continue;
            info2.mColorSampleCounts = new int[1];
            info2.mColorSampleCounts[0] = 1;
        }
    }

    @Override
    public boolean isGLES() {
        return true;
    }

    @Override
    public void glEnable(int cap) {
        GLES20.glEnable((int)cap);
    }

    @Override
    public void glDisable(int cap) {
        GLES20.glDisable((int)cap);
    }

    @Override
    public void glFrontFace(int mode) {
        GLES20.glFrontFace((int)mode);
    }

    @Override
    public void glLineWidth(float width) {
        GLES20.glLineWidth((float)width);
    }

    @Override
    public int glGenTextures() {
        return GLES20.glGenTextures();
    }

    @Override
    public void glTexParameteri(int target, int pname, int param) {
        GLES20.glTexParameteri((int)target, (int)pname, (int)param);
    }

    @Override
    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    @Override
    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        GLES20.nglTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (long)pixels);
    }

    @Override
    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    @Override
    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GLES20.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glDeleteTextures(int texture) {
        GLES20.glDeleteTextures((int)texture);
    }

    @Override
    public void glBindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
    }

    @Override
    public void glPixelStorei(int pname, int param) {
        GLES20.glPixelStorei((int)pname, (int)param);
    }

    @Override
    public void glBlendFunc(int sfactor, int dfactor) {
        GLES20.glBlendFunc((int)sfactor, (int)dfactor);
    }

    @Override
    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    @Override
    public void glDepthFunc(int func) {
        GLES20.glDepthFunc((int)func);
    }

    @Override
    public void glDepthMask(boolean flag) {
        GLES20.glDepthMask((boolean)flag);
    }

    @Override
    public void glStencilOp(int sfail, int dpfail, int dppass) {
        GLES20.glStencilOp((int)sfail, (int)dpfail, (int)dppass);
    }

    @Override
    public void glStencilFunc(int func, int ref, int mask) {
        GLES20.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    @Override
    public void glStencilMask(int mask) {
        GLES20.glStencilMask((int)mask);
    }

    @Override
    public void glDrawArrays(int mode, int first, int count) {
        GLES20.glDrawArrays((int)mode, (int)first, (int)count);
    }

    @Override
    public void glDrawElements(int mode, int count, int type, long indices) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    @Override
    public void glFlush() {
        GLES20.glFlush();
    }

    @Override
    public void glFinish() {
        GLES20.glFinish();
    }

    @Override
    public int glGetError() {
        return GLES20.glGetError();
    }

    @Override
    @Nullable
    public String glGetString(int name) {
        return GLES20.glGetString((int)name);
    }

    @Override
    public int glGetInteger(int pname) {
        return GLES20.glGetInteger((int)pname);
    }

    @Override
    public void glScissor(int x, int y, int width, int height) {
        GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glActiveTexture(int texture) {
        GLES20.glActiveTexture((int)texture);
    }

    @Override
    public void glBlendEquation(int mode) {
        GLES20.glBlendEquation((int)mode);
    }

    @Override
    public int glGenBuffers() {
        return GLES20.glGenBuffers();
    }

    @Override
    public void glDeleteBuffers(int buffer) {
        GLES20.glDeleteBuffers((int)buffer);
    }

    @Override
    public void glBindBuffer(int target, int buffer) {
        GLES20.glBindBuffer((int)target, (int)buffer);
    }

    @Override
    public void glBufferData(int target, long size, long data, int usage) {
        GLES20.nglBufferData((int)target, (long)size, (long)data, (int)usage);
    }

    @Override
    public void glBufferSubData(int target, long offset, long size, long data) {
        GLES20.nglBufferSubData((int)target, (long)offset, (long)size, (long)data);
    }

    @Override
    public boolean glUnmapBuffer(int target) {
        return GLES30.glUnmapBuffer((int)target);
    }

    @Override
    public void glDrawBuffers(int[] bufs) {
        GLES30.glDrawBuffers((int[])bufs);
    }

    @Override
    public void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        GLES20.glStencilOpSeparate((int)face, (int)sfail, (int)dpfail, (int)dppass);
    }

    @Override
    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    @Override
    public void glStencilMaskSeparate(int face, int mask) {
        GLES20.glStencilMaskSeparate((int)face, (int)mask);
    }

    @Override
    public int glCreateProgram() {
        return GLES20.glCreateProgram();
    }

    @Override
    public void glDeleteProgram(int program) {
        GLES20.glDeleteProgram((int)program);
    }

    @Override
    public int glCreateShader(int type) {
        return GLES20.glCreateShader((int)type);
    }

    @Override
    public void glDeleteShader(int shader) {
        GLES20.glDeleteShader((int)shader);
    }

    @Override
    public void glAttachShader(int program, int shader) {
        GLES20.glAttachShader((int)program, (int)shader);
    }

    @Override
    public void glDetachShader(int program, int shader) {
        GLES20.glDetachShader((int)program, (int)shader);
    }

    @Override
    public void glShaderSource(int shader, int count, long strings, long length) {
        GLES20.nglShaderSource((int)shader, (int)count, (long)strings, (long)length);
    }

    @Override
    public void glCompileShader(int shader) {
        GLES20.glCompileShader((int)shader);
    }

    @Override
    public void glLinkProgram(int program) {
        GLES20.glLinkProgram((int)program);
    }

    @Override
    public void glUseProgram(int program) {
        GLES20.glUseProgram((int)program);
    }

    @Override
    public int glGetShaderi(int shader, int pname) {
        return GLES20.glGetShaderi((int)shader, (int)pname);
    }

    @Override
    public int glGetProgrami(int program, int pname) {
        return GLES20.glGetProgrami((int)program, (int)pname);
    }

    @Override
    public String glGetShaderInfoLog(int shader) {
        return GLES20.glGetShaderInfoLog((int)shader);
    }

    @Override
    public String glGetProgramInfoLog(int program) {
        return GLES20.glGetProgramInfoLog((int)program);
    }

    @Override
    public int glGetUniformLocation(int program, CharSequence name) {
        return GLES20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    @Override
    public void glUniform1i(int location, int v0) {
        GLES20.glUniform1i((int)location, (int)v0);
    }

    @Override
    public void glEnableVertexAttribArray(int index) {
        GLES20.glEnableVertexAttribArray((int)index);
    }

    @Override
    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GLES20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)pointer);
    }

    @Override
    public void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        GLES30.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)pointer);
    }

    @Override
    public int glGenVertexArrays() {
        return GLES30.glGenVertexArrays();
    }

    @Override
    public void glDeleteVertexArrays(int array) {
        GLES30.glDeleteVertexArrays((int)array);
    }

    @Override
    public void glBindVertexArray(int array) {
        GLES30.glBindVertexArray((int)array);
    }

    @Override
    public int glGenFramebuffers() {
        return GLES20.glGenFramebuffers();
    }

    @Override
    public void glDeleteFramebuffers(int framebuffer) {
        GLES20.glDeleteFramebuffers((int)framebuffer);
    }

    @Override
    public void glBindFramebuffer(int target, int framebuffer) {
        GLES20.glBindFramebuffer((int)target, (int)framebuffer);
    }

    @Override
    public int glCheckFramebufferStatus(int target) {
        return GLES20.glCheckFramebufferStatus((int)target);
    }

    @Override
    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    @Override
    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GLES20.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    @Override
    public void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GLES30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    @Override
    public void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        GLES30.glClearBufferiv((int)buffer, (int)drawbuffer, (IntBuffer)value);
    }

    @Override
    public void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        GLES30.glClearBufferfv((int)buffer, (int)drawbuffer, (FloatBuffer)value);
    }

    @Override
    public void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        GLES30.glClearBufferfi((int)buffer, (int)drawbuffer, (float)depth, (int)stencil);
    }

    @Override
    public void glBindBufferBase(int target, int index, int buffer) {
        GLES30.glBindBufferBase((int)target, (int)index, (int)buffer);
    }

    @Override
    public void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        GLES30.glBindBufferRange((int)target, (int)index, (int)buffer, (long)offset, (long)size);
    }

    @Override
    public int glGenRenderbuffers() {
        return GLES20.glGenRenderbuffers();
    }

    @Override
    public void glDeleteRenderbuffers(int renderbuffer) {
        GLES20.glDeleteRenderbuffers((int)renderbuffer);
    }

    @Override
    public void glBindRenderbuffer(int target, int renderbuffer) {
        GLES20.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    @Override
    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GLES20.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        GLES30.glRenderbufferStorageMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public long glMapBufferRange(int target, long offset, long length, int access) {
        return GLES30.nglMapBufferRange((int)target, (long)offset, (long)length, (int)access);
    }

    @Override
    public void glDrawArraysInstanced(int mode, int first, int count, int instancecount) {
        GLES30.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)instancecount);
    }

    @Override
    public void glDrawElementsInstanced(int mode, int count, int type, long indices, int instancecount) {
        GLES30.glDrawElementsInstanced((int)mode, (int)count, (int)type, (long)indices, (int)instancecount);
    }

    @Override
    public void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        GLES30.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    @Override
    public int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        return GLES30.glGetUniformBlockIndex((int)program, (CharSequence)uniformBlockName);
    }

    @Override
    public void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        GLES30.glUniformBlockBinding((int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
    }

    @Override
    public long glFenceSync(int condition, int flags) {
        return GLES30.glFenceSync((int)condition, (int)flags);
    }

    @Override
    public void glDeleteSync(long sync) {
        GLES30.glDeleteSync((long)sync);
    }

    @Override
    public int glClientWaitSync(long sync, int flags, long timeout) {
        return GLES30.glClientWaitSync((long)sync, (int)flags, (long)timeout);
    }

    @Override
    public int glGenSamplers() {
        return GLES30.glGenSamplers();
    }

    @Override
    public void glDeleteSamplers(int sampler) {
        GLES30.glDeleteSamplers((int)sampler);
    }

    @Override
    public void glBindSampler(int unit, int sampler) {
        GLES30.glBindSampler((int)unit, (int)sampler);
    }

    @Override
    public void glSamplerParameteri(int sampler, int pname, int param) {
        GLES30.glSamplerParameteri((int)sampler, (int)pname, (int)param);
    }

    @Override
    public void glSamplerParameterf(int sampler, int pname, float param) {
        GLES30.glSamplerParameterf((int)sampler, (int)pname, (float)param);
    }

    @Override
    public void glVertexAttribDivisor(int index, int divisor) {
        GLES30.glVertexAttribDivisor((int)index, (int)divisor);
    }

    @Override
    public void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        assert (this.mDrawElementsBaseVertexSupport);
        if (this.mDrawElementsBaseVertexEXT) {
            EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
        } else {
            GLES32.nglDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
        }
    }

    @Override
    public void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        assert (this.mDrawElementsBaseVertexSupport);
        if (this.mDrawElementsBaseVertexEXT) {
            EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT((int)mode, (int)count, (int)type, (long)indices, (int)instancecount, (int)basevertex);
        } else {
            GLES32.nglDrawElementsInstancedBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)instancecount, (int)basevertex);
        }
    }

    @Override
    public void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GLES20.glShaderBinary((IntBuffer)shaders, (int)binaryformat, (ByteBuffer)binary);
    }

    @Override
    public void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int instancecount, int baseinstance) {
        assert (this.mBaseInstanceSupport);
        EXTBaseInstance.glDrawArraysInstancedBaseInstanceEXT((int)mode, (int)first, (int)count, (int)instancecount, (int)baseinstance);
    }

    @Override
    public void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int instancecount, int basevertex, int baseinstance) {
        assert (this.mBaseInstanceSupport);
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT((int)mode, (int)count, (int)type, (long)indices, (int)instancecount, (int)basevertex, (int)baseinstance);
    }

    @Override
    public void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        GLES30.glTexStorage2D((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public void glInvalidateBufferSubData(int buffer, long offset, long length) {
        assert (false);
    }

    @Override
    public void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        GLES30.glInvalidateFramebuffer((int)target, (IntBuffer)attachments);
    }

    @Override
    public void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        assert (this.mCopyImageSupport);
        if (this.mCopyImageSubDataEXT) {
            EXTCopyImage.glCopyImageSubDataEXT((int)srcName, (int)srcTarget, (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (int)dstName, (int)dstTarget, (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth);
        } else {
            GLES32.glCopyImageSubData((int)srcName, (int)srcTarget, (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (int)dstName, (int)dstTarget, (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth);
        }
    }

    @Override
    public void glObjectLabel(int identifier, int name, int length, long label) {
        assert (this.mDebugSupport);
        GLES32.nglObjectLabel((int)identifier, (int)name, (int)length, (long)label);
    }

    @Override
    public void glObjectLabel(int identifier, int name, CharSequence label) {
        assert (this.mDebugSupport);
        GLES32.glObjectLabel((int)identifier, (int)name, (CharSequence)label);
    }

    @Override
    public void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride) {
        assert (this.mVertexAttribBindingSupport);
        GLES31.glBindVertexBuffer((int)bindingindex, (int)buffer, (long)offset, (int)stride);
    }

    @Override
    public void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        GLES31.glVertexAttribFormat((int)attribindex, (int)size, (int)type, (boolean)normalized, (int)relativeoffset);
    }

    @Override
    public void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset) {
        GLES31.glVertexAttribIFormat((int)attribindex, (int)size, (int)type, (int)relativeoffset);
    }

    @Override
    public void glVertexAttribBinding(int attribindex, int bindingindex) {
        GLES31.glVertexAttribBinding((int)attribindex, (int)bindingindex);
    }

    @Override
    public void glVertexBindingDivisor(int bindingindex, int divisor) {
        GLES31.glVertexBindingDivisor((int)bindingindex, (int)divisor);
    }

    @Override
    public void glBufferStorage(int target, long size, long data, int flags) {
        assert (this.mBufferStorageSupport);
        EXTBufferStorage.nglBufferStorageEXT((int)target, (long)size, (long)data, (int)flags);
    }

    @Override
    public void glTextureBarrier() {
        assert (this.mTextureBarrierSupport);
        NVTextureBarrier.glTextureBarrierNV();
    }

    @Override
    public int glCreateBuffers() {
        assert (false);
        return 0;
    }

    @Override
    public void glNamedBufferData(int buffer, long size, long data, int usage) {
        assert (false);
    }

    @Override
    public void glNamedBufferSubData(int buffer, long offset, long size, long data) {
        assert (false);
    }

    @Override
    public long glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        assert (false);
        return 0L;
    }

    @Override
    public boolean glUnmapNamedBuffer(int buffer) {
        assert (false);
        return false;
    }

    @Override
    public void glNamedBufferStorage(int buffer, long size, long data, int flags) {
        assert (false);
    }

    @Override
    public void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        assert (false);
    }

    @Override
    public int glCreateTextures(int target) {
        assert (false);
        return 0;
    }

    @Override
    public void glTextureParameteri(int texture, int pname, int param) {
        assert (false);
    }

    @Override
    public void glTextureParameteriv(int texture, int pname, IntBuffer params) {
        assert (false);
    }

    @Override
    public void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        assert (false);
    }

    @Override
    public void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height) {
        assert (false);
    }

    @Override
    public int glCreateVertexArrays() {
        assert (false);
        return 0;
    }

    @Override
    public void glEnableVertexArrayAttrib(int vaobj, int index) {
        assert (false);
    }

    @Override
    public void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        assert (false);
    }

    @Override
    public void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        assert (false);
    }

    @Override
    public void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex) {
        assert (false);
    }

    @Override
    public void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor) {
        assert (false);
    }

    @Override
    public void glBindTextureUnit(int unit, int texture) {
        assert (false);
    }

    @Override
    public void glSpecializeShader(int shader, CharSequence pEntryPoint, IntBuffer pConstantIndex, IntBuffer pConstantValue) {
        assert (false);
    }
}

