/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.Pixmap;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.Swizzle;
import icyllis.arc3d.engine.task.ImageUploadTask;
import icyllis.arc3d.granite.GraniteImage;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import javax.annotation.Nullable;

public class TextureUtils {
    @Nullable
    public static ObjectIntPair<@SharedPtr ImageViewProxy> makePixmapViewProxy(RecordingContext context, Pixmap pixmap, boolean mipmapped, boolean budgeted, String label) {
        ImageViewProxy view;
        ImageDesc desc;
        int srcCT;
        if (!pixmap.getInfo().isValid()) {
            return null;
        }
        Caps caps = context.getCaps();
        int dstCT = srcCT = pixmap.getColorType();
        if (pixmap.getWidth() <= 1 && pixmap.getHeight() <= 1) {
            mipmapped = false;
        }
        if ((desc = caps.getDefaultColorImageDesc(1, dstCT, pixmap.getWidth(), pixmap.getHeight(), 1, 8 | (mipmapped ? 4 : 0))) == null) {
            return null;
        }
        assert (desc != null);
        short readSwizzle = caps.getReadSwizzle(desc, dstCT);
        if (ColorInfo.colorTypeIsAlphaOnly(dstCT)) {
            readSwizzle = Swizzle.concat(readSwizzle, (short)13107);
        }
        if ((view = ImageViewProxy.make(context, desc, 0, readSwizzle, budgeted, label)) == null) {
            return null;
        }
        ImageInfo imageInfo = pixmap.getInfo();
        ImageUploadTask task = ImageUploadTask.make(context, view, srcCT, imageInfo.alphaType(), imageInfo.colorSpace(), dstCT, imageInfo.alphaType(), imageInfo.colorSpace(), new ImageUploadTask.MipLevel[]{new ImageUploadTask.MipLevel(pixmap)}, new Rect2i(0, 0, pixmap.getWidth(), pixmap.getHeight()), ImageUploadTask.uploadOnce());
        if (task == null) {
            context.getLogger().error("ImageUtils.makePixmapViewProxy: Could not create ImageUploadTask");
            return null;
        }
        context.addTask(task);
        view.ref();
        return ObjectIntPair.of((Object)view, (int)dstCT);
    }

    @Nullable
    @SharedPtr
    public static GraniteImage makeFromPixmap(RecordingContext context, Pixmap pixmap, boolean mipmapped, boolean budgeted, String label) {
        ObjectIntPair<ImageViewProxy> result = TextureUtils.makePixmapViewProxy(context, pixmap, mipmapped, budgeted, label);
        if (result == null) {
            return null;
        }
        return new GraniteImage(context, (ImageViewProxy)result.first(), result.rightInt(), pixmap.getAlphaType(), pixmap.getColorSpace());
    }
}

