/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Surface;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.granite.GraniteDevice;
import icyllis.arc3d.granite.GraniteImage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GraniteSurface
extends Surface {
    @SharedPtr
    private GraniteDevice mDevice;

    public GraniteSurface(@SharedPtr GraniteDevice device) {
        super(device.getWidth(), device.getHeight());
        this.mDevice = device;
    }

    @Nullable
    @SharedPtr
    static GraniteSurface make(RecordingContext rc, ImageInfo info, boolean budgeted, boolean mipmapped, boolean approxFit, int surfaceOrigin, byte initialLoadOp, String label, boolean trackDevice) {
        GraniteDevice device;
        int flags = 0;
        if (budgeted) {
            flags |= 1;
        }
        if (mipmapped) {
            flags |= 4;
        }
        if (approxFit) {
            flags |= 2;
        }
        if ((device = GraniteDevice.make(rc, info, flags, surfaceOrigin, initialLoadOp, label, trackDevice)) == null) {
            return null;
        }
        assert (budgeted || device.getReadView().isInstantiated());
        return new GraniteSurface(device);
    }

    @Nullable
    @SharedPtr
    public static GraniteSurface make(RecordingContext rc, ImageInfo info, boolean budgeted, boolean mipmapped, boolean approxFit, int surfaceOrigin, String label) {
        return GraniteSurface.make(rc, info, budgeted, mipmapped, approxFit, surfaceOrigin, (byte)1, label, true);
    }

    @Nullable
    @SharedPtr
    public static GraniteSurface makeRenderTarget(RecordingContext rc, @Nonnull ImageInfo info, boolean mipmapped, int surfaceOrigin, @Nullable String label) {
        if (label == null) {
            label = "SurfaceRenderTarget";
        }
        return GraniteSurface.make(rc, info, false, mipmapped, false, surfaceOrigin, label);
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.mDevice.setImmutable();
        this.mDevice = RefCnt.move(this.mDevice);
    }

    public void flush() {
        this.mDevice.flushPendingWork();
    }

    @Override
    @Nonnull
    public ImageInfo getImageInfo() {
        return this.mDevice.getImageInfo();
    }

    @Override
    protected Canvas onNewCanvas() {
        return new Canvas(RefCnt.create(this.mDevice));
    }

    @Override
    @Nullable
    protected Image onNewImageSnapshot(@Nullable Rect2ic subset) {
        return this.makeImageCopy(subset, this.mDevice.getReadView().isMipmapped());
    }

    @Override
    protected boolean onCopyOnWrite(int changeMode) {
        return true;
    }

    @Nullable
    @SharedPtr
    public GraniteImage makeImageCopy(@Nullable Rect2ic subset, boolean mipmapped) {
        assert (!this.hasCachedImage());
        if (subset == null) {
            subset = new Rect2i(0, 0, this.getWidth(), this.getHeight());
        }
        return this.mDevice.makeImageCopy(subset, false, mipmapped, false);
    }

    @Override
    protected RecordingContext onGetRecordingContext() {
        return this.mDevice.getRecordingContext();
    }
}

