/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Glyph;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Strike;
import icyllis.arc3d.core.StrikeDesc;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.granite.BakedGlyph;
import icyllis.arc3d.granite.DrawAtlas;
import icyllis.arc3d.granite.GlyphAtlasManager;
import icyllis.arc3d.granite.GlyphStrike;

public class GlyphVector
extends DrawAtlas.PlotBulkUseUpdater {
    private final StrikeDesc mStrikeDesc;
    private final int[] mGlyphs;
    private BakedGlyph[] mBakedGlyphs;
    private long mAtlasGeneration = 0L;

    public GlyphVector(StrikeDesc strikeDesc, int[] glyphs) {
        this.mStrikeDesc = strikeDesc;
        this.mGlyphs = glyphs;
    }

    public BakedGlyph[] getGlyphs() {
        return this.mBakedGlyphs;
    }

    public int getGlyphCount() {
        return this.mGlyphs.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareGlyphs(int start, int end, int maskFormat, RecordingContext context) {
        assert (0 <= start && start <= end && end <= this.mGlyphs.length);
        if (this.mBakedGlyphs == null) {
            GlyphStrike glyphStrike = context.getGlyphStrikeCache().findOrCreateStrike(this.mStrikeDesc);
            BakedGlyph[] bakedGlyphs = new BakedGlyph[this.mGlyphs.length];
            int e = this.mGlyphs.length;
            for (int i = 0; i < e; ++i) {
                bakedGlyphs[i] = glyphStrike.getGlyph(this.mGlyphs[i]);
            }
            this.mBakedGlyphs = bakedGlyphs;
        }
        GlyphAtlasManager atlasManager = context.getAtlasProvider().getGlyphAtlasManager();
        DrawAtlas.AtlasTokenTracker tokenTracker = context.getAtlasTokenTracker();
        long currentGeneration = atlasManager.getAtlasGeneration(maskFormat);
        if (this.mAtlasGeneration != currentGeneration) {
            super.clear();
            Strike strike = this.mStrikeDesc.findOrCreateStrike();
            boolean success = true;
            int glyphsUpdated = 0;
            for (int i = start; i < end; ++i) {
                BakedGlyph bakedGlyph = this.mBakedGlyphs[i];
                if (!atlasManager.hasGlyph(maskFormat, bakedGlyph)) {
                    Glyph glyph;
                    strike.lock();
                    try {
                        glyph = strike.getGlyph(this.mGlyphs[i]);
                        strike.prepareForImage(glyph);
                    }
                    finally {
                        strike.unlock();
                    }
                    int res = atlasManager.addGlyphToAtlas(glyph, bakedGlyph);
                    if (res != 0) {
                        assert (res == 1 || res == 2);
                        success = res != 1;
                        break;
                    }
                }
                atlasManager.addGlyphAndSetLastUseToken(this, bakedGlyph, maskFormat, tokenTracker.nextFlushToken());
                ++glyphsUpdated;
            }
            if (success && start + glyphsUpdated == this.mGlyphs.length) {
                this.mAtlasGeneration = atlasManager.getAtlasGeneration(maskFormat);
            }
            return success ? glyphsUpdated : ~glyphsUpdated;
        }
        if (end == this.mGlyphs.length) {
            atlasManager.setLastUseTokenBulk(maskFormat, this, tokenTracker.nextFlushToken());
        }
        return end - start;
    }

    @Override
    public long getMemorySize() {
        long size = super.getMemorySize();
        size += 8L + this.mStrikeDesc.getMemorySize();
        size += 32L + MathUtil.align8((long)this.mGlyphs.length * 12L) + 16L;
        return size += 8L;
    }
}

