/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.SLDataType;
import icyllis.arc3d.engine.DepthStencilSettings;
import icyllis.arc3d.engine.KeyBuilder;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.ShaderCaps;
import icyllis.arc3d.engine.ShaderVar;
import icyllis.arc3d.engine.UniformDataManager;
import icyllis.arc3d.engine.VertexInputLayout;
import icyllis.arc3d.granite.Draw;
import icyllis.arc3d.granite.MeshDrawWriter;
import icyllis.arc3d.granite.TextureDataGatherer;
import icyllis.arc3d.granite.UniformDataGatherer;
import icyllis.arc3d.granite.shading.FPFragmentBuilder;
import icyllis.arc3d.granite.shading.UniformHandler;
import icyllis.arc3d.granite.shading.VaryingHandler;
import icyllis.arc3d.granite.shading.VertexGeomBuilder;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class GeometryStep {
    public static final VertexInputLayout.Attribute DEPTH = new VertexInputLayout.Attribute("Depth", 0, 13);
    public static final VertexInputLayout.Attribute SOLID_COLOR = new VertexInputLayout.Attribute("SolidColor", 3, 16);
    public static final VertexInputLayout.Attribute MODEL_VIEW = new VertexInputLayout.Attribute("ModelView", 2, 18);
    public static final int FLAG_PERFORM_SHADING = 2;
    public static final int FLAG_HAS_TEXTURES = 4;
    public static final int FLAG_EMIT_COVERAGE = 8;
    public static final int FLAG_OUTSET_BOUNDS_FOR_AA = 32;
    public static final int FLAG_EMIT_PRIMITIVE_COLOR = 64;
    public static final int FLAG_HANDLE_SOLID_COLOR = 128;
    private static final AtomicInteger sNextID = new AtomicInteger(0);
    private final int mUniqueID = GeometryStep.nextID();
    private final String mName;
    private final VertexInputLayout mInputLayout;
    private final int mVertexBinding;
    private final int mInstanceBinding;
    private final int mVertexStride;
    private final int mInstanceStride;
    final int mFlags;
    private final byte mPrimitiveType;
    private final DepthStencilSettings mDepthStencilSettings;

    @Nonnull
    protected static VertexInputLayout.Attribute makeColorAttribute(String name, boolean wideColor) {
        return new VertexInputLayout.Attribute(name, wideColor ? (byte)3 : 17, 16);
    }

    private static int nextID() {
        int newValue;
        int value;
        while (!sNextID.weakCompareAndSetVolatile(value = sNextID.get(), newValue = value + 1)) {
        }
        return value;
    }

    protected GeometryStep(@Nonnull String className, @Nonnull String variantName, @Nullable VertexInputLayout.AttributeSet vertexAttributes, @Nullable VertexInputLayout.AttributeSet instanceAttributes, int flags, byte primitiveType, DepthStencilSettings depthStencilSettings) {
        this.mName = variantName.isEmpty() ? className : className + "[" + variantName + "]";
        int binding = 0;
        this.mVertexBinding = vertexAttributes != null ? binding++ : -1;
        this.mInstanceBinding = instanceAttributes != null ? binding++ : -1;
        VertexInputLayout.AttributeSet[] attributeSets = new VertexInputLayout.AttributeSet[binding];
        binding = 0;
        if (vertexAttributes != null) {
            attributeSets[binding++] = vertexAttributes;
        }
        if (instanceAttributes != null) {
            attributeSets[binding++] = instanceAttributes;
        }
        this.mInputLayout = new VertexInputLayout(attributeSets);
        this.mVertexStride = this.mVertexBinding != -1 ? this.mInputLayout.getStride(this.mVertexBinding) : 0;
        this.mInstanceStride = this.mInstanceBinding != -1 ? this.mInputLayout.getStride(this.mInstanceBinding) : 0;
        assert (binding == this.mInputLayout.getBindingCount());
        this.mFlags = flags;
        this.mPrimitiveType = primitiveType;
        this.mDepthStencilSettings = depthStencilSettings;
    }

    @Nonnull
    public final String name() {
        return this.mName;
    }

    public final int uniqueID() {
        return this.mUniqueID;
    }

    public final byte primitiveType() {
        return this.mPrimitiveType;
    }

    public int numTextureSamplers() {
        return 0;
    }

    public int textureSamplerState(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    public short textureSamplerSwizzle(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    public VertexInputLayout getInputLayout() {
        return this.mInputLayout;
    }

    public final boolean hasVertexAttributes() {
        return this.mVertexBinding != -1;
    }

    public final int vertexBinding() {
        return this.mVertexBinding;
    }

    public final int numVertexAttributes() {
        return this.mInputLayout.getAttributeCount(this.mVertexBinding);
    }

    public final int numVertexLocations() {
        return this.mInputLayout.getLocationCount(this.mVertexBinding);
    }

    @Nonnull
    public final Iterator<VertexInputLayout.Attribute> vertexAttributes() {
        return this.mInputLayout.getAttributes(this.mVertexBinding);
    }

    public final int vertexStride() {
        return this.mVertexStride;
    }

    public final boolean hasInstanceAttributes() {
        return this.mInstanceBinding != -1;
    }

    public final int instanceBinding() {
        return this.mInstanceBinding;
    }

    public final int numInstanceAttributes() {
        return this.mInputLayout.getAttributeCount(this.mInstanceBinding);
    }

    public final int numInstanceLocations() {
        return this.mInputLayout.getLocationCount(this.mInstanceBinding);
    }

    @Nonnull
    public final Iterator<VertexInputLayout.Attribute> instanceAttributes() {
        return this.mInputLayout.getAttributes(this.mInstanceBinding);
    }

    public final int instanceStride() {
        return this.mInstanceStride;
    }

    public final boolean performsShading() {
        return (this.mFlags & 2) != 0;
    }

    public final boolean emitsCoverage() {
        return (this.mFlags & 8) != 0;
    }

    public final boolean handlesSolidColor() {
        return (this.mFlags & 0x80) != 0;
    }

    public final boolean emitsPrimitiveColor() {
        return (this.mFlags & 0x40) != 0;
    }

    public final DepthStencilSettings depthStencilSettings() {
        return this.mDepthStencilSettings;
    }

    public final int depthStencilFlags() {
        return (this.mDepthStencilSettings.mDepthTest || this.mDepthStencilSettings.mDepthWrite ? 1 : 0) | (this.mDepthStencilSettings.mStencilTest ? 2 : 0);
    }

    public abstract void appendToKey(@Nonnull KeyBuilder var1);

    public final void appendAttributesToKey(@Nonnull KeyBuilder b) {
    }

    @Nonnull
    public abstract ProgramImpl makeProgramImpl(ShaderCaps var1);

    public void emitVaryings(VaryingHandler varyingHandler, boolean usesFastSolidColor) {
    }

    public void emitUniforms(UniformHandler uniformHandler, boolean mayRequireLocalCoords) {
    }

    public void emitSamplers(UniformHandler uniformHandler) {
    }

    public void emitVertexGeomCode(Formatter vs, @Nonnull String worldPosVar, @Nullable String localPosVar, boolean usesFastSolidColor) {
    }

    public void emitFragmentColorCode(Formatter fs, String outputColor) {
    }

    public void emitFragmentCoverageCode(Formatter fs, String outputCoverage) {
    }

    public void writeMesh(MeshDrawWriter writer, Draw draw, @Nullable float[] solidColor, boolean mayRequireLocalCoords) {
    }

    public void writeUniformsAndTextures(RecordingContext context, Draw draw, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, boolean mayRequireLocalCoords) {
    }

    public static abstract class ProgramImpl {
        protected static Matrix setTransform(@Nonnull UniformDataManager pdm, int uniform, @Nonnull Matrix matrix, @Nullable Matrix state) {
            if (uniform == -1 || state != null && state.equals(matrix)) {
                return state;
            }
            if (matrix.isScaleTranslate()) {
                pdm.set4f(uniform, matrix.getScaleX(), matrix.getTranslateX(), matrix.getScaleY(), matrix.getTranslateY());
            } else {
                pdm.setMatrix3f(uniform, matrix);
            }
            return matrix;
        }

        protected static void writePassthroughWorldPosition(VertexGeomBuilder vertBuilder, ShaderVar inPos, ShaderVar outPos) {
            assert (inPos.getType() == 14 || inPos.getType() == 15);
            vertBuilder.codeAppendf("vec%d _worldPos = %s;\n", SLDataType.vectorDim(inPos.getType()), inPos.getName());
            outPos.set("_worldPos", inPos.getType());
        }

        protected static void writeWorldPosition(VertexGeomBuilder vertBuilder, ShaderVar inPos, String matrixName, ShaderVar outPos) {
            assert (inPos.getType() == 14 || inPos.getType() == 15);
            if (inPos.getType() == 15) {
                vertBuilder.codeAppendf("vec3 _worldPos = %s * %s;\n", matrixName, inPos.getName());
                outPos.set("_worldPos", (byte)15);
            } else {
                vertBuilder.codeAppendf("vec3 _worldPos = %s * vec3(%s, 1.0);\n", matrixName, inPos.getName());
                outPos.set("_worldPos", (byte)15);
            }
        }

        public final void emitCode(VertexGeomBuilder vertBuilder, FPFragmentBuilder fragBuilder, VaryingHandler varyingHandler, UniformHandler uniformHandler, ShaderCaps shaderCaps, GeometryStep geomProc, String outputColor, String outputCoverage, int[] texSamplers) {
            ShaderVar localPos = new ShaderVar();
            ShaderVar worldPos = new ShaderVar();
            this.onEmitCode(vertBuilder, fragBuilder, varyingHandler, uniformHandler, shaderCaps, geomProc, outputColor, outputCoverage, texSamplers, localPos, worldPos);
            assert (worldPos.getType() == 14 || worldPos.getType() == 15);
            vertBuilder.emitNormalizedPosition(worldPos);
            if (worldPos.getType() == 14) {
                varyingHandler.setNoPerspective();
            }
        }

        public abstract void setData(UniformDataManager var1, GeometryStep var2);

        protected abstract void onEmitCode(VertexGeomBuilder var1, FPFragmentBuilder var2, VaryingHandler var3, UniformHandler var4, ShaderCaps var5, GeometryStep var6, String var7, String var8, int[] var9, ShaderVar var10, ShaderVar var11);
    }
}

