/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.granite.GeometryStep;

public final class GeometryRenderer {
    public static final int MAX_RENDER_STEPS = 4;
    private final GeometryStep mStep0;
    private final GeometryStep mStep1;
    private final GeometryStep mStep2;
    private final int mNumSteps;
    private final String mName;
    private final int mStepFlags;
    private final int mDepthStencilFlags;

    public GeometryRenderer(String name, GeometryStep step0) {
        this.mName = name;
        this.mStep0 = step0;
        this.mStep2 = null;
        this.mStep1 = null;
        this.mNumSteps = 1;
        this.mStepFlags = step0.mFlags;
        this.mDepthStencilFlags = step0.depthStencilFlags();
        assert ((this.mStepFlags & 2) != 0);
    }

    public GeometryRenderer(String name, GeometryStep step0, GeometryStep step1) {
        this.mName = name;
        this.mStep0 = step0;
        this.mStep1 = step1;
        this.mStep2 = null;
        this.mNumSteps = 2;
        this.mStepFlags = step0.mFlags | step1.mFlags;
        this.mDepthStencilFlags = step0.depthStencilFlags() | step1.depthStencilFlags();
        assert ((this.mStepFlags & 2) != 0);
    }

    public GeometryRenderer(String name, GeometryStep step0, GeometryStep step1, GeometryStep step2) {
        this.mName = name;
        this.mStep0 = step0;
        this.mStep1 = step1;
        this.mStep2 = step2;
        this.mNumSteps = 3;
        this.mStepFlags = step0.mFlags | step1.mFlags | step2.mFlags;
        this.mDepthStencilFlags = step0.depthStencilFlags() | step1.depthStencilFlags() | step2.depthStencilFlags();
        assert ((this.mStepFlags & 2) != 0);
    }

    public GeometryStep step(int i) {
        assert (i >= 0 && i < this.mNumSteps);
        return switch (i) {
            case 0 -> this.mStep0;
            case 1 -> this.mStep1;
            case 2 -> this.mStep2;
            default -> null;
        };
    }

    public int numSteps() {
        return this.mNumSteps;
    }

    public String name() {
        return this.mName;
    }

    public int depthStencilFlags() {
        return this.mDepthStencilFlags;
    }

    public boolean outsetBoundsForAA() {
        return (this.mStepFlags & 0x20) != 0;
    }

    public boolean emitsPrimitiveColor() {
        return (this.mStepFlags & 0x40) != 0;
    }

    public boolean emitsCoverage() {
        return (this.mStepFlags & 8) != 0;
    }
}

