/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Quad;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.granite.Draw;
import icyllis.arc3d.granite.DrawOrder;
import icyllis.arc3d.granite.GraniteDevice;
import icyllis.arc3d.granite.SimpleShape;
import icyllis.arc3d.granite.geom.BoundsManager;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class ClipStack {
    public static final int OP_DIFFERENCE = 0;
    public static final int OP_INTERSECT = 1;
    public static final int STATE_EMPTY = 0;
    public static final int STATE_WIDE_OPEN = 1;
    public static final int STATE_DEVICE_RECT = 2;
    public static final int STATE_COMPLEX = 3;
    private final ArrayDeque<SaveRecord> mSaves = new ArrayDeque();
    private final ArrayDeque<ClipElement> mElements = new ArrayDeque();
    private final Collection<Element> mElementsView = Collections.unmodifiableCollection(this.mElements);
    private final GraniteDevice mDevice;
    private final Rect2i mDeviceBounds;
    private final Rect2f mDeviceBoundsF;
    private final ClipElement mTmpElement = new ClipElement();
    private final ClipDraw mTmpDraw = new ClipDraw();
    private final Rect2f mTmpShapeBounds = new Rect2f();
    public static final int CLIP_GEOMETRY_EMPTY = 0;
    public static final int CLIP_GEOMETRY_A_ONLY = 1;
    public static final int CLIP_GEOMETRY_B_ONLY = 2;
    public static final int CLIP_GEOMETRY_BOTH = 3;

    public ClipStack(GraniteDevice device) {
        this.mDevice = device;
        this.mDeviceBounds = new Rect2i(device.getBounds());
        this.mDeviceBoundsF = new Rect2f(device.getBounds());
        this.mSaves.add(new SaveRecord(device.getBounds()));
    }

    public int currentClipState() {
        return this.mSaves.element().mState;
    }

    public void save() {
        this.mSaves.element().pushSave();
    }

    public void restore() {
        SaveRecord current = this.mSaves.element();
        if (current.popSave()) {
            return;
        }
        current.removeElements(this.mElements, this.mDevice);
        this.mSaves.pop();
        this.mSaves.element().restoreElements(this.mElements);
    }

    public @UnmodifiableView Collection<Element> elements() {
        return this.mElementsView;
    }

    public void clipRect(@Nullable Matrixc viewMatrix, @Nonnull Rect2fc localRect, int clipOp) {
        this.clip(this.mTmpElement.init(this.mDeviceBounds, localRect, false, viewMatrix, clipOp));
    }

    private void clip(ClipElement element) {
        boolean wasDeferred;
        if (this.mSaves.element().mState == 0) {
            return;
        }
        if (element.shape().isEmpty() && element.clipOp() == 0) {
            return;
        }
        SaveRecord current = this.mSaves.element();
        if (current.canBeUpdated()) {
            wasDeferred = false;
        } else {
            boolean alive = current.popSave();
            assert (alive);
            wasDeferred = true;
            current = new SaveRecord(current, this.mElements.size());
            this.mSaves.push(current);
        }
        int elementCount = this.mElements.size();
        if (!current.addElement(element, this.mElements, this.mDevice) && wasDeferred) {
            assert (elementCount == this.mElements.size());
            this.mSaves.pop();
            this.mSaves.element().pushSave();
        }
    }

    public int maxDeferredClipDraws() {
        return this.mElements.size();
    }

    public void getConservativeBounds(Rect2f out) {
        SaveRecord current = this.mSaves.element();
        if (current.mState == 0) {
            out.setEmpty();
        } else if (current.mState == 1) {
            out.set(this.mDeviceBounds);
        } else if (current.op() == 0) {
            ClipStack.subtract(this.mDeviceBoundsF, current.mInnerBounds, out, true);
        } else {
            assert (this.mDeviceBounds.contains(current.outerBounds()));
            out.set(current.mOuterBounds);
        }
    }

    public <GEO> boolean prepareForDraw(Draw draw, GEO geometry, BiConsumer<GEO, Rect2f> boundsFn, boolean outsetBoundsForAA, List<Element> elementsForMask) {
        float rendererOutset;
        SaveRecord save = this.mSaves.element();
        if (save.mState == 0) {
            return true;
        }
        Rect2f shapeBounds = this.mTmpShapeBounds;
        boundsFn.accept(geometry, shapeBounds);
        if (!shapeBounds.isFinite()) {
            return true;
        }
        boolean infiniteBounds = false;
        if (!infiniteBounds && shapeBounds.isEmpty() && !draw.isStroke()) {
            return true;
        }
        draw.mAARadius = rendererOutset = outsetBoundsForAA ? draw.mTransform.localAARadius(shapeBounds) : 0.0f;
        Rect2f transformedShapeBounds = new Rect2f();
        boolean shapeInDeviceSpace = false;
        Rect2f deviceBounds = this.mDeviceBoundsF;
        if (!Float.isFinite(rendererOutset)) {
            transformedShapeBounds.set(deviceBounds);
            infiniteBounds = true;
        } else {
            transformedShapeBounds.set(shapeBounds);
            if (draw.mHalfWidth != 0.0f || rendererOutset != 0.0f) {
                float localStyleOutset = draw.getInflationRadius() + rendererOutset;
                transformedShapeBounds.outset(localStyleOutset, localStyleOutset);
                if (draw.mHalfWidth >= 0.0f || rendererOutset != 0.0f) {
                    shapeBounds.set(transformedShapeBounds);
                }
            }
            draw.mTransform.mapRect(transformedShapeBounds);
            if ((double)draw.mHalfWidth == 0.0 && rendererOutset == 0.0f) {
                transformedShapeBounds.outset(0.5f, 0.5f);
                shapeBounds.set(transformedShapeBounds);
                shapeInDeviceSpace = true;
            }
            transformedShapeBounds.intersectNoCheck(deviceBounds);
        }
        Rect2f drawBounds = new Rect2f();
        if (infiniteBounds) {
            drawBounds.set(deviceBounds);
            shapeBounds.set(drawBounds);
            shapeInDeviceSpace = true;
        } else {
            drawBounds.set(transformedShapeBounds);
        }
        if (drawBounds.isEmpty()) {
            return true;
        }
        if (save.mState == 1) {
            draw.mDrawBounds = drawBounds;
            draw.mTransformedShapeBounds = transformedShapeBounds;
            draw.mScissorRect = this.mDeviceBounds;
            return false;
        }
        Rect2ic scissor = save.scissor(this.mDeviceBounds, drawBounds);
        if (!drawBounds.intersect(scissor)) {
            return true;
        }
        transformedShapeBounds.intersectNoCheck(scissor);
        if (!save.innerBounds().contains(drawBounds)) {
            assert (elementsForMask.isEmpty());
            this.mTmpDraw.init(shapeInDeviceSpace ? Matrix.identity() : draw.mTransform, shapeBounds, drawBounds);
            int i = this.mElements.size();
            for (ClipElement e : this.mElements) {
                if (--i < save.oldestElementIndex()) break;
                if (e.isInvalid()) continue;
                switch (ClipStack.getClipGeometry(e, this.mTmpDraw)) {
                    case 0: {
                        elementsForMask.clear();
                        return true;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        assert (false);
                    }
                    case 3: {
                        boolean fullyApplied = false;
                        if (fullyApplied) break;
                        elementsForMask.add(e);
                        break;
                    }
                }
            }
        }
        draw.mDrawBounds = drawBounds;
        draw.mTransformedShapeBounds = transformedShapeBounds;
        draw.mScissorRect = scissor;
        return false;
    }

    public int updateForDraw(Draw draw, List<Element> elementsForMask, BoundsManager boundsManager, int depth) {
        if (draw.isClippedOut()) {
            return 0;
        }
        assert (this.mSaves.element().mState != 0);
        int maxClipOrder = 0;
        for (Element element : elementsForMask) {
            ClipElement e = (ClipElement)element;
            int order = e.updateForDraw(boundsManager, draw.mDrawBounds, depth);
            maxClipOrder = Math.max(maxClipOrder, order);
        }
        return maxClipOrder;
    }

    public void recordDeferredClipDraws() {
        for (ClipElement e : this.mElements) {
            e.drawClip(this.mDevice);
        }
    }

    public static boolean intersects(ClipGeometry A, ClipGeometry B) {
        if (!Rect2f.intersects(A.outerBounds(), B.outerBounds())) {
            return false;
        }
        if (A.viewMatrix().isAxisAligned() && B.viewMatrix().isAxisAligned()) {
            return true;
        }
        if (A.viewMatrix().equals(B.viewMatrix())) {
            return A.shape().intersects(B.shape());
        }
        return true;
    }

    public static int getClipGeometry(ClipGeometry A, ClipGeometry B) {
        if (A.op() == 1) {
            if (B.op() == 1) {
                if (!ClipStack.intersects(A, B)) {
                    return 0;
                }
                if (B.contains(A)) {
                    return 1;
                }
                if (A.contains(B)) {
                    return 2;
                }
                return 3;
            }
            if (B.op() == 0) {
                if (!ClipStack.intersects(A, B)) {
                    return 1;
                }
                if (B.contains(A)) {
                    return 0;
                }
                return 3;
            }
        }
        if (A.op() == 0) {
            if (B.op() == 1) {
                if (!ClipStack.intersects(A, B)) {
                    return 2;
                }
                if (A.contains(B)) {
                    return 0;
                }
                return 3;
            }
            if (B.op() == 0) {
                if (A.contains(B)) {
                    return 1;
                }
                if (B.contains(A)) {
                    return 2;
                }
                return 3;
            }
        }
        throw new IllegalStateException();
    }

    static void subtract(Rect2fc a, Rect2fc b, Rect2f out, boolean exact) {
        Rect2f diff = new Rect2f();
        if (Rect2f.subtract(a, b, diff) || !exact) {
            out.set(diff);
        } else {
            out.set(a);
        }
    }

    static final class ClipElement
    extends Element
    implements ClipGeometry {
        boolean mInverseFill;
        final Matrix mInverseViewMatrix = new Matrix();
        final Rect2f mInnerBounds = new Rect2f();
        final Rect2f mOuterBounds = new Rect2f();
        final Rect2f mUsageBounds = new Rect2f();
        int mPaintersOrder = 0;
        int mMaxDepth = 0;
        int mInvalidatedByIndex = -1;

        public ClipElement() {
        }

        public ClipElement(ClipElement e) {
            super(e.shape(), e.viewMatrix(), e.clipOp());
            this.mInverseFill = e.mInverseFill;
            this.mInverseViewMatrix.set(e.mInverseViewMatrix);
            this.mInnerBounds.set(e.mInnerBounds);
            this.mOuterBounds.set(e.mOuterBounds);
            this.mUsageBounds.set(e.mUsageBounds);
            this.mPaintersOrder = e.mPaintersOrder;
            this.mMaxDepth = e.mMaxDepth;
            this.mInvalidatedByIndex = e.mInvalidatedByIndex;
        }

        public void set(ClipElement e) {
            this.mShape.set(e.shape());
            this.mViewMatrix.set(e.viewMatrix());
            this.mClipOp = e.clipOp();
            this.mInverseFill = e.mInverseFill;
            this.mInverseViewMatrix.set(e.mInverseViewMatrix);
            this.mInnerBounds.set(e.mInnerBounds);
            this.mOuterBounds.set(e.mOuterBounds);
            this.mUsageBounds.set(e.mUsageBounds);
            this.mPaintersOrder = e.mPaintersOrder;
            this.mMaxDepth = e.mMaxDepth;
            this.mInvalidatedByIndex = e.mInvalidatedByIndex;
        }

        public ClipElement init(Rect2ic deviceBounds, Rect2fc shape, boolean inverseFill, Matrixc viewMatrix, int clipOp) {
            this.mShape.set(shape);
            this.mViewMatrix.set(viewMatrix);
            this.mClipOp = clipOp;
            this.mUsageBounds.setEmpty();
            this.mPaintersOrder = 0;
            this.mMaxDepth = 0;
            this.mInvalidatedByIndex = -1;
            if (!viewMatrix.invert(this.mInverseViewMatrix)) {
                this.mShape.setEmpty();
                this.mInverseViewMatrix.setIdentity();
            }
            if (inverseFill) {
                this.mClipOp = this.mClipOp == 1 ? 0 : 1;
            }
            this.mInnerBounds.setEmpty();
            this.mViewMatrix.mapRect((Rect2fc)this.mShape, this.mOuterBounds);
            if (!this.mOuterBounds.intersect(deviceBounds)) {
                this.mOuterBounds.setEmpty();
            }
            if (!this.mOuterBounds.isEmpty() && this.mViewMatrix.isAxisAligned()) {
                this.mShape.set(this.mOuterBounds);
                this.mViewMatrix.setIdentity();
                this.mInverseViewMatrix.setIdentity();
                this.mInnerBounds.set(this.mOuterBounds);
            }
            if (this.mOuterBounds.isEmpty()) {
                this.mShape.setEmpty();
                this.mInnerBounds.setEmpty();
            }
            boolean bl = this.mInverseFill = this.mClipOp == 1;
            assert (this.mShape.isEmpty() || deviceBounds.contains(this.mOuterBounds));
            assert (this.validate());
            return this;
        }

        public boolean hasPendingDraw() {
            return this.mPaintersOrder != 0;
        }

        public boolean isInvalid() {
            return this.mInvalidatedByIndex >= 0;
        }

        public void markInvalid(SaveRecord current) {
            assert (!this.isInvalid());
            this.mInvalidatedByIndex = current.firstActiveElementIndex();
        }

        public void restoreValid(SaveRecord current) {
            if (current.firstActiveElementIndex() < this.mInvalidatedByIndex) {
                this.mInvalidatedByIndex = -1;
            }
        }

        public boolean combine(ClipElement other, SaveRecord current) {
            if (this.hasPendingDraw() || other.hasPendingDraw()) {
                return false;
            }
            if (other.mClipOp != 1 || this.mClipOp != 1) {
                return false;
            }
            boolean shapeUpdated = false;
            if (this.mViewMatrix.equals(other.mViewMatrix)) {
                if (!this.mShape.intersect(other.mShape)) {
                    this.mShape.setEmpty();
                    this.markInvalid(current);
                    return true;
                }
                shapeUpdated = true;
            }
            if (shapeUpdated) {
                assert (this.mClipOp == 1 && other.mClipOp == 1);
                boolean res = this.mOuterBounds.intersect(other.mOuterBounds);
                assert (res);
                if (!this.mInnerBounds.intersect(other.mInnerBounds)) {
                    this.mInnerBounds.setEmpty();
                }
                this.mInverseFill = true;
                assert (this.validate());
                return true;
            }
            return false;
        }

        public void updateForElement(ClipElement added, SaveRecord current) {
            if (this.isInvalid()) {
                return;
            }
            switch (ClipStack.getClipGeometry(this, added)) {
                case 0: {
                    this.markInvalid(current);
                    added.markInvalid(current);
                    break;
                }
                case 1: {
                    added.markInvalid(current);
                    break;
                }
                case 2: {
                    this.markInvalid(current);
                    break;
                }
                case 3: {
                    if (!added.combine(this, current)) break;
                    this.markInvalid(current);
                }
            }
        }

        public int updateForDraw(BoundsManager boundsManager, Rect2fc drawBounds, int drawDepth) {
            assert (!this.isInvalid());
            assert (!drawBounds.isEmpty());
            if (!this.hasPendingDraw()) {
                this.mPaintersOrder = boundsManager.getMostRecentDraw(this.mOuterBounds) + 1;
                this.mUsageBounds.set(drawBounds);
                this.mMaxDepth = drawDepth;
            } else {
                this.mUsageBounds.join(drawBounds);
                this.mMaxDepth = Math.max(this.mMaxDepth, drawDepth);
            }
            return this.mPaintersOrder;
        }

        public void drawClip(GraniteDevice device) {
            assert (this.validate());
            if (!this.hasPendingDraw()) {
                assert (this.mUsageBounds.isEmpty());
                return;
            }
            assert (!this.mUsageBounds.isEmpty());
            Rect2i scissor = new Rect2i();
            this.mUsageBounds.roundOut(scissor);
            Rect2f drawBounds = new Rect2f(this.mOuterBounds);
            if (drawBounds.intersect(scissor)) {
                long order = DrawOrder.makeFromDepthAndPaintersOrder(this.mMaxDepth + 1, this.mPaintersOrder);
                Draw draw = new Draw();
                draw.mTransform = this.mViewMatrix.clone();
                draw.mGeometry = new SimpleShape(this.mShape);
                draw.mDrawBounds = drawBounds;
                draw.mTransformedShapeBounds = drawBounds;
                draw.mScissorRect = scissor;
                draw.mDrawOrder = order;
                assert (this.mClipOp == 0 && !this.mInverseFill || this.mClipOp == 1 && this.mInverseFill);
                device.drawClipShape(draw, this.mInverseFill);
            }
            this.mUsageBounds.setEmpty();
            this.mPaintersOrder = 0;
            this.mMaxDepth = 0;
        }

        @Override
        public int op() {
            return this.mClipOp;
        }

        public Rect2fc innerBounds() {
            return this.mInnerBounds;
        }

        @Override
        public Rect2fc outerBounds() {
            return this.mOuterBounds;
        }

        @Override
        public boolean contains(ClipGeometry g) {
            if (this.mInnerBounds.contains(g.outerBounds())) {
                return true;
            }
            if (!this.mOuterBounds.contains(g.outerBounds())) {
                return false;
            }
            if (this.mViewMatrix.equals(g.viewMatrix())) {
                return this.mShape.contains(g.shape());
            }
            if (this.mViewMatrix.isAxisAligned() && g.viewMatrix().isAxisAligned()) {
                Rect2f localBounds = new Rect2f(g.shape());
                g.viewMatrix().mapRect(localBounds);
                this.mInverseViewMatrix.mapRect(localBounds);
                return this.mShape.contains(localBounds);
            }
            return false;
        }

        static boolean rect_contains_rect(Rect2fc a, Matrixc aToDevice, Matrixc deviceToA, Rect2fc b, Matrixc bToDevice, boolean mixedAAMode) {
            if (!mixedAAMode && Matrix.equals(aToDevice, bToDevice)) {
                return a.contains(b);
            }
            if (bToDevice.isIdentity() && aToDevice.isAxisAligned()) {
                Rect2f bInA = new Rect2f(b);
                if (mixedAAMode) {
                    bInA.outset(0.5f, 0.5f);
                }
                boolean res = deviceToA.mapRect(bInA);
                assert (res);
                return a.contains(bInA);
            }
            Quad deviceQuad = new Quad(b, bToDevice);
            if (deviceQuad.w0() < 5.0E-5f || deviceQuad.w1() < 5.0E-5f || deviceQuad.w2() < 5.0E-5f || deviceQuad.w3() < 5.0E-5f) {
                return false;
            }
            float[] p = new float[2];
            for (int i = 0; i < 4; ++i) {
                deviceQuad.point(i, p);
                deviceToA.mapPoint(p);
                if (a.contains(p[0], p[1])) continue;
                return false;
            }
            return true;
        }

        private int clipType() {
            if (this.mShape.isEmpty()) {
                return 0;
            }
            return this.mClipOp == 1 && this.mViewMatrix.isIdentity() ? 2 : 3;
        }

        private boolean validate() {
            assert ((this.mShape.isEmpty() || !this.mOuterBounds.isEmpty()) && (this.mInnerBounds.isEmpty() || this.mOuterBounds.contains(this.mInnerBounds)));
            assert (this.mClipOp == 0 && !this.mInverseFill || this.mClipOp == 1 && this.mInverseFill);
            assert (!this.hasPendingDraw() || !this.mUsageBounds.isEmpty());
            return true;
        }
    }

    static final class ClipDraw
    implements ClipGeometry {
        final Matrix mViewMatrix = new Matrix();
        final Rect2f mShape = new Rect2f();
        final Rect2f mDrawBounds = new Rect2f();

        ClipDraw() {
        }

        public ClipDraw init(Matrixc viewMatrix, Rect2fc shape, Rect2fc drawBounds) {
            this.mViewMatrix.set(viewMatrix);
            this.mShape.set(shape);
            this.mDrawBounds.set(drawBounds);
            return this;
        }

        @Override
        public int op() {
            return 1;
        }

        @Override
        public Rect2fc shape() {
            return this.mShape;
        }

        @Override
        public Matrixc viewMatrix() {
            return this.mViewMatrix;
        }

        @Override
        public Rect2fc outerBounds() {
            return this.mDrawBounds;
        }

        @Override
        public boolean contains(ClipGeometry other) {
            assert (other instanceof SaveRecord || other instanceof ClipElement);
            return false;
        }
    }

    static final class SaveRecord
    implements ClipGeometry {
        private final Rect2f mInnerBounds;
        private final Rect2f mOuterBounds;
        final int mStartingElementIndex;
        int mOldestValidIndex;
        private int mDeferredSaveCount;
        private int mState;
        private int mOp;

        SaveRecord(Rect2ic deviceBounds) {
            this.mInnerBounds = new Rect2f(deviceBounds);
            this.mOuterBounds = new Rect2f(deviceBounds);
            this.mStartingElementIndex = 0;
            this.mOldestValidIndex = 0;
            this.mState = 1;
            this.mOp = 1;
        }

        SaveRecord(SaveRecord prior, int startingElementIndex) {
            this.mInnerBounds = new Rect2f(prior.mInnerBounds);
            this.mOuterBounds = new Rect2f(prior.mOuterBounds);
            this.mStartingElementIndex = startingElementIndex;
            this.mOldestValidIndex = prior.mOldestValidIndex;
            this.mState = prior.mState;
            this.mOp = prior.mOp;
            assert (startingElementIndex >= prior.mStartingElementIndex);
        }

        @Override
        public int op() {
            return this.mOp;
        }

        @Override
        public Rect2fc shape() {
            return this.mOuterBounds;
        }

        @Override
        public Matrixc viewMatrix() {
            return Matrix.identity();
        }

        @Override
        public Rect2fc outerBounds() {
            return this.mOuterBounds;
        }

        public Rect2fc innerBounds() {
            return this.mInnerBounds;
        }

        @Override
        public boolean contains(ClipGeometry g) {
            assert (g instanceof ClipElement || g instanceof ClipDraw);
            return this.mInnerBounds.contains(g.outerBounds());
        }

        public int firstActiveElementIndex() {
            return this.mStartingElementIndex;
        }

        public int oldestElementIndex() {
            return this.mOldestValidIndex;
        }

        public boolean canBeUpdated() {
            return this.mDeferredSaveCount == 0;
        }

        public void pushSave() {
            assert (this.mDeferredSaveCount >= 0);
            ++this.mDeferredSaveCount;
        }

        public boolean popSave() {
            --this.mDeferredSaveCount;
            assert (this.mDeferredSaveCount >= -1);
            return this.mDeferredSaveCount >= 0;
        }

        public boolean addElement(ClipElement toAdd, ArrayDeque<ClipElement> elements, GraniteDevice device) {
            assert (toAdd.validate());
            assert (this.canBeUpdated());
            if (this.mState == 0) {
                return false;
            }
            if (toAdd.shape().isEmpty()) {
                assert (toAdd.clipOp() == 1);
                this.mState = 0;
                this.removeElements(elements, device);
                return true;
            }
            switch (ClipStack.getClipGeometry(this, toAdd)) {
                case 0: {
                    this.mState = 0;
                    this.removeElements(elements, device);
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    this.replaceWithElement(toAdd, elements, device);
                    return true;
                }
            }
            if (this.mState == 1) {
                this.replaceWithElement(toAdd, elements, device);
                return true;
            }
            if (this.mOp == 1) {
                if (toAdd.op() == 1) {
                    boolean res = this.mOuterBounds.intersect(toAdd.outerBounds());
                    assert (res);
                    if (!this.mInnerBounds.intersect(toAdd.innerBounds())) {
                        this.mInnerBounds.setEmpty();
                    }
                } else {
                    ClipStack.subtract(this.mOuterBounds, toAdd.innerBounds(), this.mOuterBounds, true);
                    ClipStack.subtract(this.mInnerBounds, toAdd.outerBounds(), this.mInnerBounds, false);
                }
            } else if (toAdd.op() == 1) {
                Rect2f oldOuter = new Rect2f(this.mOuterBounds);
                ClipStack.subtract(toAdd.outerBounds(), this.mInnerBounds, this.mOuterBounds, true);
                ClipStack.subtract(toAdd.innerBounds(), oldOuter, this.mInnerBounds, false);
            } else {
                this.mOuterBounds.join(toAdd.outerBounds());
                if (toAdd.innerBounds().width() * toAdd.innerBounds().height() > this.mInnerBounds.width() * this.mInnerBounds.height()) {
                    this.mInnerBounds.set(toAdd.innerBounds());
                }
            }
            assert (!this.mOuterBounds.isEmpty() && (this.mInnerBounds.isEmpty() || this.mOuterBounds.contains(this.mInnerBounds)));
            return this.appendElement(toAdd, elements, device);
        }

        private boolean appendElement(ClipElement toAdd, ArrayDeque<ClipElement> elements, GraniteDevice device) {
            int i = elements.size() - 1;
            int youngestValid = this.mStartingElementIndex - 1;
            int oldestValid = elements.size();
            ClipElement oldestActiveInvalid = null;
            int oldestActiveInvalidIndex = elements.size();
            for (ClipElement existing : elements) {
                if (i < this.mOldestValidIndex) break;
                existing.updateForElement(toAdd, this);
                if (toAdd.isInvalid()) {
                    if (existing.isInvalid()) {
                        this.mState = 0;
                        return true;
                    }
                    return false;
                }
                if (existing.isInvalid()) {
                    if (i >= this.mStartingElementIndex) {
                        oldestActiveInvalid = existing;
                        oldestActiveInvalidIndex = i;
                    }
                } else {
                    oldestValid = i;
                    if (i > youngestValid) {
                        youngestValid = i;
                    }
                }
                --i;
            }
            assert (oldestValid == elements.size() || oldestValid >= this.mOldestValidIndex && oldestValid < elements.size());
            assert (youngestValid == this.mStartingElementIndex - 1 || youngestValid >= this.mStartingElementIndex && youngestValid < elements.size());
            assert (oldestActiveInvalid == null || oldestActiveInvalidIndex >= this.mStartingElementIndex && oldestActiveInvalidIndex < elements.size());
            assert (oldestValid >= this.mOldestValidIndex);
            this.mOldestValidIndex = Math.min(oldestValid, oldestActiveInvalidIndex);
            int n = this.mState = oldestValid == elements.size() ? toAdd.clipType() : 3;
            if (this.mOp == 0 && toAdd.op() == 1) {
                this.mOp = 1;
            }
            int targetCount = youngestValid + 1;
            if (oldestActiveInvalid == null || oldestActiveInvalidIndex >= targetCount) {
                ++targetCount;
                oldestActiveInvalid = null;
            }
            while (elements.size() > targetCount) {
                assert (oldestActiveInvalid != elements.peek());
                elements.pop().drawClip(device);
            }
            if (oldestActiveInvalid != null) {
                oldestActiveInvalid.drawClip(device);
                oldestActiveInvalid.set(toAdd);
            } else if (elements.size() < targetCount) {
                elements.push(new ClipElement(toAdd));
            } else {
                elements.element().drawClip(device);
                elements.element().set(toAdd);
            }
            return true;
        }

        private void replaceWithElement(ClipElement toAdd, ArrayDeque<ClipElement> elements, GraniteDevice device) {
            this.mInnerBounds.set(toAdd.mInnerBounds);
            this.mOuterBounds.set(toAdd.mOuterBounds);
            this.mOp = toAdd.clipOp();
            this.mState = toAdd.clipType();
            int targetCount = this.mStartingElementIndex + 1;
            while (elements.size() > targetCount) {
                elements.pop().drawClip(device);
            }
            if (elements.size() < targetCount) {
                elements.push(new ClipElement(toAdd));
            } else {
                elements.element().drawClip(device);
                elements.element().set(toAdd);
            }
            assert (elements.size() == this.mStartingElementIndex + 1);
            this.mOldestValidIndex = this.mStartingElementIndex;
        }

        public void removeElements(ArrayDeque<ClipElement> elements, GraniteDevice device) {
            while (elements.size() > this.mStartingElementIndex) {
                elements.pop().drawClip(device);
            }
        }

        public void restoreElements(ArrayDeque<ClipElement> elements) {
            int i = elements.size() - 1;
            for (ClipElement e : elements) {
                if (i < this.mOldestValidIndex) break;
                e.restoreValid(this);
                --i;
            }
        }

        public Rect2ic scissor(Rect2ic deviceBounds, Rect2fc drawBounds) {
            assert (this.mState != 0 && this.mState != 1);
            assert (deviceBounds.contains(drawBounds));
            if (this.mOp == 1) {
                if (this.mOuterBounds.contains(drawBounds)) {
                    return deviceBounds;
                }
                Rect2i res = new Rect2i();
                this.mOuterBounds.roundOut(res);
                return res;
            }
            if (!this.mOuterBounds.intersects(drawBounds)) {
                return deviceBounds;
            }
            Rect2f diff = new Rect2f();
            Rect2i res = new Rect2i();
            if (Rect2f.subtract(drawBounds, this.mInnerBounds, diff)) {
                diff.roundOut(res);
            } else {
                drawBounds.roundOut(res);
            }
            return res;
        }
    }

    public static interface ClipGeometry {
        public int op();

        public Rect2fc shape();

        public Matrixc viewMatrix();

        public Rect2fc outerBounds();

        public boolean contains(ClipGeometry var1);
    }

    public static class Element {
        final Rect2f mShape;
        final Matrix mViewMatrix;
        int mClipOp;

        Element() {
            this.mShape = new Rect2f();
            this.mViewMatrix = new Matrix();
        }

        Element(Rect2fc shape, Matrixc viewMatrix, int clipOp) {
            this.mShape = new Rect2f(shape);
            this.mViewMatrix = new Matrix(viewMatrix);
            this.mClipOp = clipOp;
        }

        public Rect2fc shape() {
            return this.mShape;
        }

        public Matrixc viewMatrix() {
            return this.mViewMatrix;
        }

        public int clipOp() {
            return this.mClipOp;
        }

        public String toString() {
            return "Element{mShape=" + this.mShape + ", mViewMatrix=" + this.mViewMatrix + ", mClipOp=" + (this.mClipOp == 1 ? "Intersect" : "Difference") + "}";
        }
    }
}

