/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine.task;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.task.Task;

public class CopyBufferTask
extends Task {
    @SharedPtr
    private Buffer mSrcBuffer;
    @SharedPtr
    private Buffer mDstBuffer;
    private final long mSrcOffset;
    private final long mDstOffset;
    private final long mSize;

    CopyBufferTask(@SharedPtr Buffer srcBuffer, @SharedPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        this.mSrcBuffer = srcBuffer;
        this.mDstBuffer = dstBuffer;
        this.mSrcOffset = srcOffset;
        this.mDstOffset = dstOffset;
        this.mSize = size;
    }

    @SharedPtr
    public static CopyBufferTask make(@SharedPtr Buffer srcBuffer, @SharedPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        assert (srcBuffer != null);
        assert (size <= srcBuffer.getSize() - srcOffset);
        assert (dstBuffer != null);
        assert (size <= dstBuffer.getSize() - dstOffset);
        return new CopyBufferTask(srcBuffer, dstBuffer, srcOffset, dstOffset, size);
    }

    @Override
    protected void deallocate() {
        this.mSrcBuffer = RefCnt.move(this.mSrcBuffer);
        this.mDstBuffer = RefCnt.move(this.mDstBuffer);
    }

    @Override
    public int prepare(RecordingContext context) {
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        if (commandBuffer.copyBuffer(this.mSrcBuffer, this.mDstBuffer, this.mSrcOffset, this.mDstOffset, this.mSize)) {
            commandBuffer.trackResource(RefCnt.create(this.mSrcBuffer));
            commandBuffer.trackResource(RefCnt.create(this.mDstBuffer));
            return 0;
        }
        return 1;
    }
}

