/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.ComputePipeline;
import icyllis.arc3d.engine.GraphicsPipeline;
import icyllis.arc3d.engine.IUniqueKey;
import icyllis.arc3d.engine.ManagedResource;
import icyllis.arc3d.engine.Resource;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SharedResourceCache {
    protected final Stats mStats = new Stats();
    @GuardedBy(value="itself")
    private final PipelineCache<@SharedPtr GraphicsPipeline> mGraphicsPipelineCache;
    @GuardedBy(value="itself")
    private final PipelineCache<@SharedPtr ComputePipeline> mComputePipelineCache;
    @GuardedBy(value="itself")
    private final ObjectArrayList<@SharedPtr Resource> mStaticResources = new ObjectArrayList();

    public SharedResourceCache() {
        this.mGraphicsPipelineCache = new PipelineCache(256);
        this.mComputePipelineCache = new PipelineCache(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PipelineCache<ManagedResource> pipelineCache = this.mGraphicsPipelineCache;
        synchronized (pipelineCache) {
            this.mGraphicsPipelineCache.values().forEach(RefCnt::unref);
            this.mGraphicsPipelineCache.clear();
        }
        pipelineCache = this.mComputePipelineCache;
        synchronized (pipelineCache) {
            this.mComputePipelineCache.values().forEach(RefCnt::unref);
            this.mComputePipelineCache.clear();
        }
        pipelineCache = this.mStaticResources;
        synchronized (pipelineCache) {
            this.mStaticResources.forEach(Resource::unref);
            this.mStaticResources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @SharedPtr
    public GraphicsPipeline findGraphicsPipeline(@Nonnull IUniqueKey key) {
        GraphicsPipeline existing;
        PipelineCache<GraphicsPipeline> pipelineCache = this.mGraphicsPipelineCache;
        synchronized (pipelineCache) {
            existing = (GraphicsPipeline)this.mGraphicsPipelineCache.get(key);
        }
        return RefCnt.create(existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @SharedPtr
    public GraphicsPipeline insertGraphicsPipeline(@Nonnull IUniqueKey key, @Nonnull @SharedPtr GraphicsPipeline pipeline) {
        GraphicsPipeline existing;
        PipelineCache<GraphicsPipeline> pipelineCache = this.mGraphicsPipelineCache;
        synchronized (pipelineCache) {
            existing = this.mGraphicsPipelineCache.putIfAbsent(key, pipeline);
        }
        if (existing != null) {
            return RefCnt.create(pipeline, existing);
        }
        return RefCnt.create(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @SharedPtr
    public ComputePipeline findComputePipeline(@Nonnull IUniqueKey key) {
        ComputePipeline existing;
        PipelineCache<ComputePipeline> pipelineCache = this.mComputePipelineCache;
        synchronized (pipelineCache) {
            existing = (ComputePipeline)this.mComputePipelineCache.get(key);
        }
        return RefCnt.create(existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @SharedPtr
    public ComputePipeline insertComputePipeline(@Nonnull IUniqueKey key, @Nonnull @SharedPtr ComputePipeline pipeline) {
        ComputePipeline existing;
        PipelineCache<ComputePipeline> pipelineCache = this.mComputePipelineCache;
        synchronized (pipelineCache) {
            existing = this.mComputePipelineCache.putIfAbsent(key, pipeline);
        }
        if (existing != null) {
            return RefCnt.create(pipeline, existing);
        }
        return RefCnt.create(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticResource(@Nonnull @SharedPtr Resource resource) {
        ObjectArrayList<Resource> objectArrayList = this.mStaticResources;
        synchronized (objectArrayList) {
            this.mStaticResources.add((Object)resource);
        }
    }

    public final Stats getStats() {
        return this.mStats;
    }

    public static class Stats {
        private final AtomicInteger mShaderCompilations = new AtomicInteger();
        private final AtomicInteger mNumInlineCompilationFailures = new AtomicInteger();
        private final AtomicInteger mNumPreCompilationFailures = new AtomicInteger();
        private final AtomicInteger mNumCompilationFailures = new AtomicInteger();
        private final AtomicInteger mNumPartialCompilationSuccesses = new AtomicInteger();
        private final AtomicInteger mNumCompilationSuccesses = new AtomicInteger();

        public int shaderCompilations() {
            return this.mShaderCompilations.get();
        }

        public void incShaderCompilations() {
            this.mShaderCompilations.getAndIncrement();
        }

        public int numInlineCompilationFailures() {
            return this.mNumInlineCompilationFailures.get();
        }

        public void incNumInlineCompilationFailures() {
            this.mNumInlineCompilationFailures.getAndIncrement();
        }

        public int numPreCompilationFailures() {
            return this.mNumPreCompilationFailures.get();
        }

        public void incNumPreCompilationFailures() {
            this.mNumPreCompilationFailures.getAndIncrement();
        }

        public int numCompilationFailures() {
            return this.mNumCompilationFailures.get();
        }

        public void incNumCompilationFailures() {
            this.mNumCompilationFailures.getAndIncrement();
        }

        public int numPartialCompilationSuccesses() {
            return this.mNumPartialCompilationSuccesses.get();
        }

        public void incNumPartialCompilationSuccesses() {
            this.mNumPartialCompilationSuccesses.getAndIncrement();
        }

        public int numCompilationSuccesses() {
            return this.mNumCompilationSuccesses.get();
        }

        public void incNumCompilationSuccesses() {
            this.mNumCompilationSuccesses.getAndIncrement();
        }

        public String toString() {
            return "SharedResourceCache.Stats{shaderCompilations=" + this.mShaderCompilations + ", numInlineCompilationFailures=" + this.mNumInlineCompilationFailures + ", numPreCompilationFailures=" + this.mNumPreCompilationFailures + ", numCompilationFailures=" + this.mNumCompilationFailures + ", numPartialCompilationSuccesses=" + this.mNumPartialCompilationSuccesses + ", numCompilationSuccesses=" + this.mNumCompilationSuccesses + "}";
        }
    }

    static class PipelineCache<T extends @SharedPtr ManagedResource>
    extends LinkedHashMap<IUniqueKey, T> {
        private final int maxEntries;

        PipelineCache(int maxEntries) {
            super(maxEntries * 2 + 2, 0.5f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<IUniqueKey, T> eldest) {
            if (this.size() > this.maxEntries) {
                ((ManagedResource)eldest.getValue()).unref();
                return true;
            }
            return false;
        }
    }
}

