/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.engine.IResourceKey;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Contract;

@Immutable
public final class SamplerDesc
implements IResourceKey {
    public static final int FILTER_NEAREST = 0;
    public static final int FILTER_LINEAR = 1;
    public static final int MIPMAP_MODE_NONE = 0;
    public static final int MIPMAP_MODE_NEAREST = 1;
    public static final int MIPMAP_MODE_LINEAR = 2;
    public static final int ADDRESS_MODE_REPEAT = 0;
    public static final int ADDRESS_MODE_MIRRORED_REPEAT = 1;
    public static final int ADDRESS_MODE_CLAMP_TO_EDGE = 2;
    public static final int ADDRESS_MODE_CLAMP_TO_BORDER = 3;
    static final int ADDRESS_MODE_LAST = 3;
    public static final SamplerDesc NEAREST = new SamplerDesc(0x1222000);
    public static final SamplerDesc DEFAULT = new SamplerDesc(0x1222011);
    private final int mState;

    SamplerDesc(int state) {
        this.mState = state;
    }

    @Contract(pure=true)
    public static SamplerDesc make(int filter) {
        assert (filter == 0 || filter == 1);
        return filter == 0 ? NEAREST : DEFAULT;
    }

    @Contract(pure=true)
    public static SamplerDesc make(int filter, int mipmap) {
        assert (filter == 0 || filter == 1);
        assert (mipmap == 0 || mipmap == 1 || mipmap == 2);
        return new SamplerDesc(0x1222000 | filter | filter << 4 | mipmap << 8);
    }

    @Contract(pure=true)
    public static SamplerDesc make(int filter, int mipmap, int address) {
        return SamplerDesc.make(filter, filter, mipmap, address, address, address);
    }

    @Contract(pure=true)
    public static SamplerDesc make(int magFilter, int minFilter, int mipmapMode, int addressModeX, int addressModeY, int addressModeZ) {
        assert (magFilter == 0 || magFilter == 1);
        assert (minFilter == 0 || minFilter == 1);
        assert (mipmapMode == 0 || mipmapMode == 1 || mipmapMode == 2);
        assert (addressModeX >= 0 && addressModeX <= 3);
        assert (addressModeY >= 0 && addressModeY <= 3);
        assert (addressModeZ >= 0 && addressModeZ <= 3);
        return new SamplerDesc(magFilter | minFilter << 4 | mipmapMode << 8 | addressModeX << 12 | addressModeY << 16 | addressModeZ << 20 | 0x1000000);
    }

    @Contract(pure=true)
    public static SamplerDesc makeAnisotropy(int addressModeX, int addressModeY, int addressModeZ, int maxAnisotropy, boolean isMipmapped) {
        assert (addressModeX >= 0 && addressModeX <= 3);
        assert (addressModeY >= 0 && addressModeY <= 3);
        assert (addressModeZ >= 0 && addressModeZ <= 3);
        return new SamplerDesc(0x11 | addressModeX << 12 | addressModeY << 16 | addressModeZ << 20 | (isMipmapped ? 512 : 0) | MathUtil.clamp(maxAnisotropy, 1, 64) << 24);
    }

    @Contract(pure=true)
    public int getMagFilter() {
        return this.mState & 0xF;
    }

    @Contract(pure=true)
    public int getMinFilter() {
        return this.mState >> 4 & 0xF;
    }

    @Contract(pure=true)
    public int getMipmapMode() {
        return this.mState >> 8 & 0xF;
    }

    @Contract(pure=true)
    public int getAddressModeX() {
        return this.mState >> 12 & 0xF;
    }

    @Contract(pure=true)
    public int getAddressModeY() {
        return this.mState >> 16 & 0xF;
    }

    @Contract(pure=true)
    public int getAddressModeZ() {
        return this.mState >> 20 & 0xF;
    }

    @Contract(pure=true)
    public boolean isMipmapped() {
        return this.getMipmapMode() != 0;
    }

    @Contract(pure=true)
    public boolean isRepeatedX() {
        int addressX = this.getAddressModeX();
        return addressX == 0 || addressX == 1;
    }

    @Contract(pure=true)
    public boolean isRepeatedY() {
        int addressY = this.getAddressModeY();
        return addressY == 0 || addressY == 1;
    }

    @Contract(pure=true)
    public boolean isRepeatedZ() {
        int addressZ = this.getAddressModeZ();
        return addressZ == 0 || addressZ == 1;
    }

    @Contract(pure=true)
    public boolean isRepeated() {
        return this.isRepeatedX() || this.isRepeatedY() || this.isRepeatedZ();
    }

    @Contract(pure=true)
    public int getMaxAnisotropy() {
        return this.mState >>> 24;
    }

    @Contract(pure=true)
    public boolean isAnisotropy() {
        return this.getMaxAnisotropy() > 1;
    }

    @Contract(pure=true)
    public SamplerDesc resetMipmapMode() {
        return new SamplerDesc(this.mState & 0xFFFFF0FF);
    }

    @Override
    public boolean isShareable() {
        return true;
    }

    @Override
    public SamplerDesc copy() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.mState;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SamplerDesc) {
            SamplerDesc desc = (SamplerDesc)o;
            return this.mState == desc.mState;
        }
        return false;
    }

    static {
        assert (DEFAULT.getMagFilter() == 1);
        assert (DEFAULT.getMinFilter() == 1);
        assert (DEFAULT.getMipmapMode() == 0);
        assert (DEFAULT.getAddressModeX() == 2);
        assert (DEFAULT.getAddressModeY() == 2);
        assert (DEFAULT.getAddressModeZ() == 2);
        assert (DEFAULT.getMaxAnisotropy() == 1);
    }
}

