/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import javax.annotation.concurrent.Immutable;
import org.lwjgl.system.NativeType;

@Immutable
public abstract class ImageDesc {
    protected final int mFlags;
    protected final int mWidth;
    protected final int mHeight;
    protected final short mDepth;
    protected final short mArraySize;
    protected final byte mMipLevelCount;
    protected final byte mSampleCount;
    protected final byte mImageType;

    protected ImageDesc(int imageType, int width, int height, int depth, int arraySize, int mipLevelCount, int sampleCount, int flags) {
        assert (width > 0 && height > 0 && depth > 0 && arraySize > 0 && mipLevelCount > 0 && sampleCount > 0);
        assert (mipLevelCount == 1 || sampleCount == 1);
        assert (imageType <= 127);
        this.mImageType = (byte)imageType;
        this.mWidth = width;
        this.mHeight = height;
        this.mDepth = (short)depth;
        this.mArraySize = (short)arraySize;
        this.mMipLevelCount = (byte)mipLevelCount;
        this.mSampleCount = (byte)sampleCount;
        this.mFlags = flags;
    }

    public abstract int getBackend();

    public final int getImageType() {
        return this.mImageType;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public final int getDepth() {
        return this.mDepth;
    }

    public final int getArraySize() {
        return this.mArraySize;
    }

    public final boolean isMipmapped() {
        return this.mMipLevelCount > 1;
    }

    public final boolean isMultisampled() {
        return this.mSampleCount > 1;
    }

    public final int getMipLevelCount() {
        return this.mMipLevelCount;
    }

    public final int getSampleCount() {
        return this.mSampleCount;
    }

    public final boolean isSampledImage() {
        return (this.mFlags & 8) != 0;
    }

    public final boolean isStorageImage() {
        return (this.mFlags & 0x10) != 0;
    }

    public final boolean isRenderable() {
        return (this.mFlags & 0x20) != 0;
    }

    public final boolean isProtected() {
        return (this.mFlags & 0x80) != 0;
    }

    @NativeType(value="GLenum")
    public int getGLFormat() {
        throw new IllegalStateException();
    }

    @NativeType(value="VkFormat")
    public int getVkFormat() {
        throw new IllegalStateException();
    }

    public int getChannelFlags() {
        throw new UnsupportedOperationException();
    }

    public boolean isSRGB() {
        throw new UnsupportedOperationException();
    }

    public int getCompressionType() {
        throw new UnsupportedOperationException();
    }

    public final boolean isCompressed() {
        return this.getCompressionType() != 0;
    }

    public int getBytesPerBlock() {
        return 0;
    }

    public int getDepthBits() {
        return 0;
    }

    public int getStencilBits() {
        return 0;
    }
}

