/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendRenderTarget;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.GpuSurface;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.Image;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public abstract class GpuRenderTarget
extends GpuSurface {
    private final int mWidth;
    private final int mHeight;
    private final int mSampleCount;
    private final int mNumColorTargets;
    protected int mSurfaceFlags = 32;

    protected GpuRenderTarget(Context context, int width, int height, int sampleCount, int numColorTargets) {
        super(context, true, false, 0L);
        this.mWidth = width;
        this.mHeight = height;
        this.mSampleCount = sampleCount;
        this.mNumColorTargets = numColorTargets;
    }

    @Override
    public final int getWidth() {
        return this.mWidth;
    }

    @Override
    public final int getHeight() {
        return this.mHeight;
    }

    @Override
    public final int getSampleCount() {
        return this.mSampleCount;
    }

    @Override
    @Nonnull
    public abstract BackendFormat getBackendFormat();

    @Nonnull
    public abstract BackendRenderTarget getBackendRenderTarget();

    @Override
    public Image asImage() {
        Image att = this.getResolveAttachment();
        if (att != null) {
            return att;
        }
        return this.getColorAttachment();
    }

    @Override
    public final GpuRenderTarget asRenderTarget() {
        return this;
    }

    @Override
    public int getSurfaceFlags() {
        return this.mSurfaceFlags;
    }

    public final int numColorTargets() {
        return this.mNumColorTargets;
    }

    @Nullable
    @RawPtr
    public abstract Image getColorAttachment();

    @Nullable
    @RawPtr
    public abstract Image getColorAttachment(int var1);

    @Nullable
    @RawPtr
    protected abstract Image[] getColorAttachments();

    @Nullable
    @RawPtr
    public abstract Image getResolveAttachment();

    @Nullable
    @RawPtr
    public abstract Image getResolveAttachment(int var1);

    @Nullable
    @RawPtr
    protected abstract Image[] getResolveAttachments();

    @Nullable
    @RawPtr
    public abstract Image getDepthStencilAttachment();

    @Override
    public abstract int getDepthBits();

    @Override
    public abstract int getStencilBits();

    protected abstract boolean canAttachStencil();

    public static final class ResourceKey
    implements IResourceKey {
        public int mWidth;
        public int mHeight;
        public int mColorFormat;
        public int mResolveFormat;
        public int mDepthStencilFormat;
        public int mColorFlags;
        public int mResolveFlags;
        public int mDepthStencilFlags;
        public int mSurfaceFlags;

        @Nonnull
        public ResourceKey compute(int width, int height, BackendFormat colorFormat, int colorSurfaceFlags, BackendFormat resolveFormat, int resolveSurfaceFlags, BackendFormat depthStencilFormat, int depthStencilSurfaceFlags, int sampleCount, int surfaceFlags) {
            assert (width > 0 && height > 0);
            this.mWidth = width;
            this.mHeight = height;
            this.mColorFormat = colorFormat != null ? colorFormat.getFormatKey() : 0;
            this.mResolveFormat = resolveFormat != null ? resolveFormat.getFormatKey() : 0;
            this.mDepthStencilFormat = depthStencilFormat != null ? depthStencilFormat.getFormatKey() : 0;
            this.mColorFlags = colorSurfaceFlags;
            this.mResolveFlags = resolveSurfaceFlags;
            this.mDepthStencilFlags = depthStencilSurfaceFlags;
            this.mSurfaceFlags = surfaceFlags & 0 | sampleCount << 16;
            return this;
        }

        @Override
        public IResourceKey copy() {
            return null;
        }

        @Override
        public int hashCode() {
            int result = this.mWidth;
            result = 31 * result + this.mHeight;
            result = 31 * result + this.mColorFormat;
            result = 31 * result + this.mResolveFormat;
            result = 31 * result + this.mDepthStencilFormat;
            result = 31 * result + this.mColorFlags;
            result = 31 * result + this.mResolveFlags;
            result = 31 * result + this.mDepthStencilFlags;
            result = 31 * result + this.mSurfaceFlags;
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResourceKey)) return false;
            ResourceKey key = (ResourceKey)o;
            if (this.mWidth != key.mWidth) return false;
            if (this.mHeight != key.mHeight) return false;
            if (this.mColorFormat != key.mColorFormat) return false;
            if (this.mResolveFormat != key.mResolveFormat) return false;
            if (this.mDepthStencilFormat != key.mDepthStencilFormat) return false;
            if (this.mColorFlags != key.mColorFlags) return false;
            if (this.mResolveFlags != key.mResolveFlags) return false;
            if (this.mDepthStencilFlags != key.mDepthStencilFlags) return false;
            if (this.mSurfaceFlags != key.mSurfaceFlags) return false;
            return true;
        }
    }
}

