/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.shaders;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Point;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Size;
import icyllis.arc3d.core.shaders.Color4fShader;
import icyllis.arc3d.core.shaders.EmptyShader;
import icyllis.arc3d.core.shaders.GradientShader;
import icyllis.arc3d.core.shaders.Shader;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Gradient1DShader
extends GradientShader {
    protected final Matrix mPtsToUnit;
    protected final int mTileMode;
    private final float[] mColors;
    private final float[] mPositions;
    private final int mColorCount;
    private final ColorSpace mColorSpace;
    private final int mInterpolation;
    final boolean mFirstStopIsImplicit;
    final boolean mLastStopIsImplicit;
    final boolean mColorsAreOpaque;

    protected Gradient1DShader(@Nonnull float[] inColors, @Nullable ColorSpace colorSpace, @Nullable float[] inPositions, int inColorCount, int tileMode, int interpolation, @Nonnull Matrix ptsToUnit) {
        ptsToUnit.getType();
        this.mPtsToUnit = ptsToUnit;
        assert (inColorCount > 1);
        this.mColorSpace = colorSpace != null ? colorSpace : ColorSpace.get(ColorSpace.Named.SRGB);
        this.mInterpolation = interpolation;
        assert (tileMode >= 0 && tileMode <= 3);
        this.mTileMode = tileMode;
        int colorCount = inColorCount;
        boolean firstStopIsImplicit = false;
        boolean lastStopIsImplicit = false;
        if (inPositions != null) {
            firstStopIsImplicit = inPositions[0] > 0.0f;
            lastStopIsImplicit = inPositions[inColorCount - 1] != 1.0f;
            colorCount += (firstStopIsImplicit ? 1 : 0) + (lastStopIsImplicit ? 1 : 0);
        }
        float[] colors = new float[colorCount * 4];
        float[] positions = inPositions != null ? new float[colorCount] : null;
        int colorIndex = 0;
        if (firstStopIsImplicit) {
            System.arraycopy(inColors, 0, colors, colorIndex, 4);
            colorIndex += 4;
        }
        System.arraycopy(inColors, 0, colors, colorIndex, inColorCount * 4);
        boolean colorsAreOpaque = true;
        for (int i = 0; i < inColorCount; ++i) {
            colorsAreOpaque &= inColors[i * 4 + 3] == 1.0f;
        }
        this.mColorsAreOpaque = colorsAreOpaque;
        if (lastStopIsImplicit) {
            System.arraycopy(inColors, (inColorCount - 1) * 4, colors, colorIndex += inColorCount * 4, 4);
        }
        if (positions != null) {
            int i;
            float prev = 0.0f;
            int positionIndex = 0;
            positions[positionIndex++] = prev;
            int startIndex = firstStopIsImplicit ? 0 : 1;
            int count = inColorCount + (lastStopIsImplicit ? 1 : 0);
            boolean uniformStops = true;
            float uniformStep = inPositions[startIndex] - prev;
            for (i = startIndex; i < count; ++i) {
                float curr = 1.0f;
                if (i != inColorCount && (curr = MathUtil.pin(inPositions[i], prev, 1.0f)) == 1.0f && lastStopIsImplicit) {
                    lastStopIsImplicit = false;
                }
                uniformStops &= Math.abs(curr - prev - uniformStep) <= 1.5258789E-5f;
                positions[positionIndex++] = prev = curr;
            }
            if (uniformStops) {
                positions = null;
            } else {
                i = 0;
                int dedupedColorCount = 0;
                for (int j = 1; j <= colorCount; ++j) {
                    boolean ignoreRightmost;
                    boolean ignoreLeftmost;
                    if (j != colorCount && positions[i] == positions[j]) continue;
                    boolean dupStop = j - i > 1;
                    boolean bl = ignoreLeftmost = dupStop && tileMode != 2 && positions[i] == 0.0f;
                    if (!ignoreLeftmost) {
                        positions[dedupedColorCount] = positions[i];
                        System.arraycopy(colors, i * 4, colors, dedupedColorCount * 4, 4);
                        ++dedupedColorCount;
                    }
                    boolean bl2 = ignoreRightmost = tileMode != 2 && positions[j - 1] == 1.0f;
                    if (dupStop && !ignoreRightmost) {
                        positions[dedupedColorCount] = positions[j - 1];
                        System.arraycopy(colors, (j - 1) * 4, colors, dedupedColorCount * 4, 4);
                        ++dedupedColorCount;
                    }
                    i = j;
                }
                colorCount = dedupedColorCount;
            }
        }
        this.mColors = colors;
        this.mPositions = positions;
        this.mColorCount = colorCount;
        this.mFirstStopIsImplicit = firstStopIsImplicit;
        this.mLastStopIsImplicit = lastStopIsImplicit;
    }

    @VisibleForTesting
    public float[] getColors() {
        return this.mColors;
    }

    @VisibleForTesting
    public float[] getPositions() {
        return this.mPositions;
    }

    public float getPos(int i) {
        assert (i < this.mColorCount);
        return this.mPositions != null ? this.mPositions[i] : (float)i / (float)(this.mColorCount - 1);
    }

    @Nonnull
    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    public int getColorCount() {
        return this.mColorCount;
    }

    public int getInterpolation() {
        return this.mInterpolation;
    }

    public int getTileMode() {
        return this.mTileMode;
    }

    @Nonnull
    public Matrixc getGradientMatrix() {
        return this.mPtsToUnit;
    }

    public boolean colorsAreOpaque() {
        return this.mColorsAreOpaque;
    }

    protected static boolean checkGradient1D(float[] colors, float[] positions, int colorCount, int tileMode) {
        return colors != null && colorCount >= 1 && colors.length >= colorCount * 4 && (positions == null || positions.length >= colorCount) && tileMode >= 0 && tileMode <= 3;
    }

    @Nullable
    @SharedPtr
    protected static Shader makeDegenerateGradient(float[] colors, @Nullable ColorSpace colorSpace, float[] positions, int colorCount, int tileMode) {
        switch (tileMode) {
            case 0: 
            case 1: {
                return new EmptyShader();
            }
            case 2: {
                int i = (colorCount - 1) * 4;
                return new Color4fShader(colors[i], colors[i + 1], colors[i + 2], colors[i + 3], colorSpace);
            }
            case 3: {
                return new EmptyShader();
            }
        }
        return null;
    }

    public static void srgb_to_hsl(int i, float[] colors, BitSet hueIsPowerless) {
        float r = colors[i * 4];
        float g = colors[i * 4 + 1];
        float b = colors[i * 4 + 2];
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        float sat = 0.0f;
        float light = (max + min) / 2.0f;
        float delta = max - min;
        if (delta != 0.0f) {
            float f = sat = light == 0.0f || light == 1.0f ? 0.0f : (max - light) / Math.min(light, 1.0f - light);
            hue = max == r ? (g - b) / delta + (float)(g < b ? 6 : 0) : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f);
            hue *= 60.0f;
        }
        if (sat == 0.0f) {
            hueIsPowerless.set(i);
        }
        colors[i * 4] = hue;
        colors[i * 4 + 1] = sat * 100.0f;
        colors[i * 4 + 2] = light * 100.0f;
    }

    public static void srgb_to_hwb(int i, float[] colors, BitSet hueIsPowerless) {
        float r = colors[i * 4];
        float g = colors[i * 4 + 1];
        float b = colors[i * 4 + 2];
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        float sat = 0.0f;
        float light = (max + min) / 2.0f;
        float delta = max - min;
        if (delta != 0.0f) {
            float f = sat = light == 0.0f || light == 1.0f ? 0.0f : (max - light) / Math.min(light, 1.0f - light);
            hue = max == r ? (g - b) / delta + (float)(g < b ? 6 : 0) : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f);
            hue *= 60.0f;
        }
        if (sat == 0.0f) {
            hueIsPowerless.set(i);
        }
        colors[i * 4] = hue;
        colors[i * 4 + 1] = min * 100.0f;
        colors[i * 4 + 2] = (1.0f - max) * 100.0f;
    }

    public static class ColorTransformer {
        public int mColorCount;
        @Nonnull
        @Size(multiple=4L)
        public float[] mColors;
        @Nullable
        public float[] mPositions;
        @Nonnull
        public ColorSpace mIntermediateColorSpace;

        public ColorTransformer(Gradient1DShader shader, ColorSpace dstCS) {
            block37: {
                int i;
                int i2;
                int colorCount;
                this.mColorCount = colorCount = shader.mColorCount;
                int interpolation = shader.mInterpolation;
                byte cs = GradientShader.Interpolation.getColorSpace(interpolation);
                boolean isPolarColorSpace = cs == 6 || cs == 7 || cs == 8 || cs == 9 || cs == 10;
                this.mPositions = shader.mPositions;
                this.mIntermediateColorSpace = ColorTransformer.intermediate_color_space(cs, dstCS);
                if (this.mIntermediateColorSpace == null) {
                    this.mIntermediateColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
                }
                if (shader.mColorSpace.equals(this.mIntermediateColorSpace)) {
                    this.mColors = Arrays.copyOf(shader.mColors, colorCount * 4);
                } else {
                    this.mColors = new float[colorCount * 4];
                    float[] col = new float[4];
                    ColorSpace.Connector connector = ColorSpace.connect(shader.mColorSpace, this.mIntermediateColorSpace);
                    for (i2 = 0; i2 < colorCount; ++i2) {
                        System.arraycopy(shader.mColors, i2 * 4, col, 0, 4);
                        System.arraycopy(connector.transform(col), 0, this.mColors, i2 * 4, 4);
                    }
                }
                BitSet hueIsPowerless = null;
                switch (cs) {
                    case 6: {
                        hueIsPowerless = new BitSet(colorCount);
                        for (int i3 = 0; i3 < colorCount; ++i3) {
                            Gradient1DShader.srgb_to_hsl(i3, this.mColors, hueIsPowerless);
                        }
                        break;
                    }
                    case 7: {
                        hueIsPowerless = new BitSet(colorCount);
                        for (int i4 = 0; i4 < colorCount; ++i4) {
                            Gradient1DShader.srgb_to_hwb(i4, this.mColors, hueIsPowerless);
                        }
                        break;
                    }
                    case 3: 
                    case 8: {
                        float[] col = new float[4];
                        ColorSpace labCS = ColorSpace.get(ColorSpace.Named.CIE_LAB);
                        for (i = 0; i < colorCount; ++i) {
                            System.arraycopy(this.mColors, i * 4, col, 0, 4);
                            System.arraycopy(labCS.fromXyz(col), 0, this.mColors, i * 4, 4);
                        }
                        if (cs != 8) break;
                        hueIsPowerless = new BitSet(colorCount);
                        for (i = 0; i < colorCount; ++i) {
                            float hue = (float)Math.toDegrees(Math.atan2(this.mColors[i * 4 + 2], this.mColors[i * 4 + 1]));
                            float chroma = Point.length(this.mColors[i * 4 + 1], this.mColors[i * 4 + 2]);
                            if (chroma <= 0.01f) {
                                hueIsPowerless.set(i);
                            }
                            this.mColors[i * 4 + 2] = this.mColors[i * 4];
                            this.mColors[i * 4] = hue >= 0.0f ? hue : hue + 360.0f;
                            this.mColors[i * 4 + 1] = chroma;
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 9: 
                    case 10: {
                        int i5;
                        for (i5 = 0; i5 < colorCount; ++i5) {
                            float l = 0.41222146f * this.mColors[i5 * 4] + 0.53633255f * this.mColors[i5 * 4 + 1] + 0.051445995f * this.mColors[i5 * 4 + 2];
                            float m = 0.2119035f * this.mColors[i5 * 4] + 0.6806995f * this.mColors[i5 * 4 + 1] + 0.10739696f * this.mColors[i5 * 4 + 2];
                            float s = 0.08830246f * this.mColors[i5 * 4] + 0.28171885f * this.mColors[i5 * 4 + 1] + 0.6299787f * this.mColors[i5 * 4 + 2];
                            l = (float)Math.cbrt(l);
                            m = (float)Math.cbrt(m);
                            s = (float)Math.cbrt(s);
                            this.mColors[i5 * 4] = 0.21045426f * l + 0.7936178f * m - 0.004072047f * s;
                            this.mColors[i5 * 4 + 1] = 1.9779985f * l - 2.4285922f * m + 0.4505937f * s;
                            this.mColors[i5 * 4 + 2] = 0.025904037f * l + 0.78277177f * m - 0.80867577f * s;
                        }
                        if (cs != 9 && cs != 10) break;
                        hueIsPowerless = new BitSet(colorCount);
                        for (i5 = 0; i5 < colorCount; ++i5) {
                            float hue = (float)Math.toDegrees(Math.atan2(this.mColors[i5 * 4 + 2], this.mColors[i5 * 4 + 1]));
                            float chroma = Point.length(this.mColors[i5 * 4 + 1], this.mColors[i5 * 4 + 2]);
                            if (chroma <= 1.0E-6f) {
                                hueIsPowerless.set(i5);
                            }
                            this.mColors[i5 * 4 + 2] = this.mColors[i5 * 4];
                            this.mColors[i5 * 4] = hue >= 0.0f ? hue : hue + 360.0f;
                            this.mColors[i5 * 4 + 1] = chroma;
                        }
                        break;
                    }
                }
                if (isPolarColorSpace && !hueIsPowerless.isEmpty()) {
                    FloatArrayList newColors = new FloatArrayList();
                    FloatArrayList newPositions = new FloatArrayList();
                    for (i = 0; i < colorCount; ++i) {
                        float curPos = shader.getPos(i);
                        if (!hueIsPowerless.get(i)) {
                            newColors.addElements(newColors.size(), this.mColors, i * 4, 4);
                            newPositions.add(curPos);
                            continue;
                        }
                        if (i != 0) {
                            newPositions.add(curPos);
                            newColors.add(this.mColors[(i - 1) * 4]);
                            newColors.add(this.mColors[i * 4 + 1]);
                            newColors.add(this.mColors[i * 4 + 2]);
                            newColors.add(this.mColors[i * 4 + 3]);
                        }
                        if (i == colorCount - 1) continue;
                        newPositions.add(curPos);
                        newColors.add(this.mColors[(i + 1) * 4]);
                        newColors.add(this.mColors[i * 4 + 1]);
                        newColors.add(this.mColors[i * 4 + 2]);
                        newColors.add(this.mColors[i * 4 + 3]);
                    }
                    this.mColors = newColors.elements();
                    this.mPositions = newPositions.elements();
                    assert (newColors.size() / 4 == newPositions.size());
                    this.mColorCount = colorCount = newPositions.size();
                }
                if (isPolarColorSpace) {
                    float delta = 0.0f;
                    block20: for (i2 = 0; i2 < colorCount - 1; ++i2) {
                        int h2;
                        float h1 = this.mColors[i2 * 4];
                        int n = h2 = (i2 + 1) * 4;
                        this.mColors[n] = this.mColors[n] + delta;
                        switch (GradientShader.Interpolation.getHueMethod(interpolation)) {
                            case 0: {
                                if (this.mColors[h2] - h1 > 180.0f) {
                                    int n2 = h2;
                                    this.mColors[n2] = this.mColors[n2] - 360.0f;
                                    delta -= 360.0f;
                                    continue block20;
                                }
                                if (!(this.mColors[h2] - h1 < -180.0f)) continue block20;
                                int n3 = h2;
                                this.mColors[n3] = this.mColors[n3] + 360.0f;
                                delta += 360.0f;
                                continue block20;
                            }
                            case 1: {
                                if (i2 == 0 && shader.mFirstStopIsImplicit || i2 == colorCount - 2 && shader.mLastStopIsImplicit) continue block20;
                                if (0.0f < this.mColors[h2] - h1 && this.mColors[h2] - h1 < 180.0f) {
                                    int n4 = h2;
                                    this.mColors[n4] = this.mColors[n4] - 360.0f;
                                    delta -= 360.0f;
                                    continue block20;
                                }
                                if (!(-180.0f < this.mColors[h2] - h1) || !(this.mColors[h2] - h1 <= 0.0f)) continue block20;
                                int n5 = h2;
                                this.mColors[n5] = this.mColors[n5] + 360.0f;
                                delta += 360.0f;
                                continue block20;
                            }
                            case 2: {
                                if (!(this.mColors[h2] < h1)) continue block20;
                                int n6 = h2;
                                this.mColors[n6] = this.mColors[n6] + 360.0f;
                                delta += 360.0f;
                                continue block20;
                            }
                            case 3: {
                                if (!(h1 < this.mColors[h2])) continue block20;
                                int n7 = h2;
                                this.mColors[n7] = this.mColors[n7] - 360.0f;
                                delta -= 360.0f;
                            }
                        }
                    }
                }
                if (!GradientShader.Interpolation.isInPremul(interpolation)) break block37;
                if (isPolarColorSpace) {
                    for (int i6 = 0; i6 < colorCount; ++i6) {
                        float a = this.mColors[i6 * 4 + 3];
                        int n = i6 * 4 + 1;
                        this.mColors[n] = this.mColors[n] * a;
                        int n8 = i6 * 4 + 2;
                        this.mColors[n8] = this.mColors[n8] * a;
                    }
                } else {
                    for (int i7 = 0; i7 < colorCount; ++i7) {
                        float a = this.mColors[i7 * 4 + 3];
                        int n = i7 * 4;
                        this.mColors[n] = this.mColors[n] * a;
                        int n9 = i7 * 4 + 1;
                        this.mColors[n9] = this.mColors[n9] * a;
                        int n10 = i7 * 4 + 2;
                        this.mColors[n10] = this.mColors[n10] * a;
                    }
                }
            }
        }

        static ColorSpace intermediate_color_space(byte cs, ColorSpace dst) {
            return switch (cs) {
                case 0 -> dst;
                case 1, 6, 7 -> ColorSpace.get(ColorSpace.Named.SRGB);
                case 2 -> ColorSpace.get(ColorSpace.Named.LINEAR_SRGB);
                case 3, 8 -> ColorSpace.get(ColorSpace.Named.CIE_XYZ);
                case 4, 5, 9, 10 -> ColorSpace.get(ColorSpace.Named.LINEAR_SRGB);
                default -> throw new AssertionError(cs);
            };
        }
    }
}

