/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.PathConsumer;
import icyllis.arc3d.core.PathIterable;
import icyllis.arc3d.core.PathStroker;

public class StrokeRec {
    public static final int kHairline_Style = 0;
    public static final int kFill_Style = 1;
    public static final int kStroke_Style = 2;
    public static final int kStrokeAndFill_Style = 3;
    private float mWidth;
    private float mMiterLimit;
    private float mResScale;
    private byte mCap;
    private byte mJoin;
    private byte mAlign;
    private boolean mStrokeAndFill;

    public StrokeRec() {
        this.mWidth = -1.0f;
        this.mMiterLimit = 4.0f;
        this.mResScale = 1.0f;
        this.mCap = 0;
        this.mJoin = 1;
        this.mAlign = 0;
        this.mStrokeAndFill = false;
    }

    public StrokeRec(Paint paint) {
        this(paint, 1.0f);
    }

    public StrokeRec(Paint paint, float resScale) {
        this.init(paint, paint.getStyle(), paint.getStrokeWidth(), resScale);
    }

    public StrokeRec(Paint paint, int style, float width) {
        this.init(paint, style, width, 1.0f);
    }

    public StrokeRec(Paint paint, int style, float width, float resScale) {
        this.init(paint, style, width, resScale);
    }

    public void init(Paint paint, int style, float width, float resScale) {
        assert (width >= 0.0f);
        this.mResScale = resScale;
        switch (style) {
            case 0: {
                this.mWidth = -1.0f;
                this.mStrokeAndFill = false;
                break;
            }
            case 1: {
                this.mWidth = width;
                this.mStrokeAndFill = false;
                break;
            }
            case 2: {
                if (width == 0.0f) {
                    this.mWidth = -1.0f;
                    this.mStrokeAndFill = false;
                    break;
                }
                this.mWidth = width;
                this.mStrokeAndFill = true;
            }
        }
        this.mMiterLimit = paint.getStrokeMiter();
        this.mCap = (byte)paint.getStrokeCap();
        this.mJoin = (byte)paint.getStrokeJoin();
        this.mAlign = (byte)paint.getStrokeAlign();
    }

    public int getStyle() {
        if (this.mWidth < 0.0f) {
            return 1;
        }
        if (this.mWidth == 0.0f) {
            return 0;
        }
        return this.mStrokeAndFill ? 3 : 2;
    }

    public boolean isFillStyle() {
        return this.mWidth < 0.0f;
    }

    public boolean isHairlineStyle() {
        return this.mWidth == 0.0f;
    }

    public boolean isStrokeStyle() {
        return this.mWidth > 0.0f;
    }

    public void setFillStyle() {
        this.mWidth = -1.0f;
        this.mStrokeAndFill = false;
    }

    public void setHairlineStyle() {
        this.mWidth = 0.0f;
        this.mStrokeAndFill = false;
    }

    public void setStrokeStyle(float width, boolean strokeAndFill) {
        assert (width >= 0.0f);
        if (strokeAndFill && width == 0.0f) {
            this.setFillStyle();
        } else {
            this.mWidth = width;
            this.mStrokeAndFill = strokeAndFill;
        }
    }

    public float getWidth() {
        return this.mWidth;
    }

    public void setWidth(float width) {
        this.mWidth = width;
    }

    public int getCap() {
        return this.mCap;
    }

    public int getJoin() {
        return this.mJoin;
    }

    public int getAlign() {
        return this.mAlign;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public void setCap(int cap) {
        this.mCap = (byte)cap;
    }

    public void setJoin(int join) {
        this.mJoin = (byte)join;
    }

    public void setAlign(int align) {
        this.mAlign = (byte)align;
    }

    public void setMiterLimit(float miterLimit) {
        assert (miterLimit >= 0.0f);
        this.mMiterLimit = miterLimit;
    }

    public void setStrokeParams(int cap, int join, int align, float miterLimit) {
        assert (miterLimit >= 0.0f);
        this.mMiterLimit = miterLimit;
        this.mCap = (byte)cap;
        this.mJoin = (byte)join;
        this.mAlign = (byte)align;
    }

    public float getResScale() {
        return this.mResScale;
    }

    public void setResScale(float resScale) {
        assert (resScale > 0.0f && Float.isFinite(resScale));
        this.mResScale = resScale;
    }

    public boolean applyToPath(PathIterable src, PathConsumer dst) {
        if (this.mWidth <= 0.0f) {
            return false;
        }
        PathStroker stroker = new PathStroker();
        stroker.init(dst, this.mWidth * 0.5f, this.mCap, this.mJoin, this.mMiterLimit, this.mResScale);
        src.forEach(stroker);
        if (this.mStrokeAndFill) {
            src.forEach(dst);
        }
        return true;
    }

    public void applyToPaint(Paint paint) {
        if (this.mWidth < 0.0f) {
            paint.setStyle(0);
            return;
        }
        paint.setStyle(this.mStrokeAndFill ? 2 : 1);
        paint.setStrokeWidth(this.mWidth);
        paint.setStrokeMiter(this.mMiterLimit);
        paint.setStrokeCap(this.mCap);
        paint.setStrokeJoin(this.mJoin);
        paint.setStrokeAlign(this.mAlign);
    }

    public float getInflationRadius() {
        return StrokeRec.getInflationRadius(this.mWidth, this.mCap, this.mJoin, this.mAlign, this.mMiterLimit);
    }

    public boolean hasSameEffect(StrokeRec other) {
        if (this.mWidth <= 0.0f) {
            return this.getStyle() == other.getStyle();
        }
        return this.mWidth == other.mWidth && (this.mJoin != 0 || this.mMiterLimit == other.mMiterLimit) && this.mCap == other.mCap && this.mJoin == other.mJoin && this.mAlign == other.mAlign && this.mStrokeAndFill == other.mStrokeAndFill;
    }

    public static float getInflationRadius(float strokeWidth, int cap, int join, int align, float miterLimit) {
        if (strokeWidth < 0.0f) {
            return 0.0f;
        }
        if (strokeWidth == 0.0f) {
            return 1.0f;
        }
        float multiplier = 1.0f;
        if (join == 0) {
            multiplier = Math.max(multiplier, miterLimit);
        }
        if (align == 0) {
            if (cap == 2) {
                multiplier = Math.max(multiplier, 1.4142135f);
            }
            multiplier *= 0.5f;
        }
        return strokeWidth * multiplier;
    }
}

