/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Blender;
import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.GlyphRunList;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.Matrix4;
import icyllis.arc3d.core.NWayCanvas;
import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.RoundRect;
import icyllis.arc3d.core.SamplingOptions;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Surface;
import icyllis.arc3d.core.TextBlob;
import icyllis.arc3d.core.Vertices;
import icyllis.arc3d.engine.RecordingContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class PaintFilterCanvas
extends NWayCanvas {
    private final Paint mFilterPaint = new Paint();

    public PaintFilterCanvas(@Nonnull @RawPtr Canvas canvas) {
        super(canvas.getImageInfo().width(), canvas.getImageInfo().height());
        Rect2i clipBounds = new Rect2i();
        canvas.getDeviceClipBounds(clipBounds);
        this.clipRect(clipBounds);
        Matrix4 localToDevice = new Matrix4();
        canvas.getLocalToDevice(localToDevice);
        this.setMatrix(localToDevice);
        this.addCanvas(canvas);
    }

    public abstract boolean onFilter(Paint var1);

    @RawPtr
    private Canvas getProxy() {
        assert (this.mSize == 1);
        return this.mList[0];
    }

    @Override
    public int getBaseLayerWidth() {
        return this.getProxy().getBaseLayerWidth();
    }

    @Override
    public int getBaseLayerHeight() {
        return this.getProxy().getBaseLayerHeight();
    }

    @Override
    @Nullable
    public RecordingContext getRecordingContext() {
        return this.getProxy().getRecordingContext();
    }

    @Override
    protected void onDrawPaint(Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawPaint(this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawPoints(mode, pts, offset, count, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawLine(x0, y0, x1, y1, cap, width, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawRect(Rect2fc r, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawRect(r, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawRoundRect(RoundRect rr, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawRoundRect(rr, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawCircle(float cx, float cy, float radius, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawCircle(cx, cy, radius, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawArc(cx, cy, radius, startAngle, sweepAngle, cap, width, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawPie(cx, cy, radius, startAngle, sweepAngle, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawChord(cx, cy, radius, startAngle, sweepAngle, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, Paint paint, int constraint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawImageRect(image, src, dst, sampling, this.mFilterPaint, constraint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawTextBlob(TextBlob blob, float originX, float originY, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawTextBlob(blob, originX, originY, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawGlyphRunList(GlyphRunList glyphRunList, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawGlyphRunList(glyphRunList, this.mFilterPaint);
        }
        this.mFilterPaint.close();
    }

    @Override
    protected void onDrawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        this.mFilterPaint.set(paint);
        if (this.onFilter(this.mFilterPaint)) {
            super.onDrawVertices(vertices, blender, this.mFilterPaint);
        } else {
            RefCnt.move(blender);
        }
        this.mFilterPaint.close();
    }

    @Override
    @Nullable
    protected Surface onNewSurface(ImageInfo info) {
        return this.getProxy().makeSurface(info);
    }

    @Override
    @Nonnull
    protected ImageInfo onGetImageInfo() {
        return this.getProxy().getImageInfo();
    }
}

