/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.IntrinsicList;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.FunctionDefinition;
import icyllis.arc3d.compiler.tree.Modifiers;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Symbol;
import icyllis.arc3d.compiler.tree.Type;
import icyllis.arc3d.compiler.tree.Variable;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FunctionDecl
extends Symbol {
    private final Modifiers mModifiers;
    private final List<Variable> mParameters;
    private final Type mReturnType;
    private boolean mBuiltin;
    private boolean mEntryPoint;
    private int mIntrinsicKind;
    private FunctionDecl mNextOverload;
    private FunctionDefinition mDefinition;

    public FunctionDecl(int position, Modifiers modifiers, String name, List<Variable> parameters, Type returnType, boolean builtin, boolean entryPoint, int intrinsicKind) {
        super(position, name);
        this.mModifiers = modifiers;
        this.mParameters = parameters;
        this.mReturnType = returnType;
        this.mBuiltin = builtin;
        this.mEntryPoint = entryPoint;
        this.mIntrinsicKind = intrinsicKind;
    }

    private static boolean checkModifiers(@Nonnull Context context, @Nonnull Modifiers modifiers) {
        boolean success = modifiers.checkLayoutFlags(context, 0);
        int permittedFlags = 0x30000 | (context.isModule() ? 32768 : 0);
        success &= modifiers.checkFlags(context, permittedFlags);
        if ((modifiers.flags() & 0x30000) == 196608) {
            context.error(modifiers.mPosition, "functions cannot be both 'inline' and 'noinline'");
            return false;
        }
        return success;
    }

    private static boolean checkReturnType(@Nonnull Context context, int pos, @Nonnull Type returnType) {
        if (returnType.isOpaque()) {
            context.error(pos, "functions may not return opaque type '" + returnType.getName() + "'");
            return false;
        }
        if (returnType.isUnsizedArray()) {
            context.error(pos, "functions may not return unsized array type '" + returnType.getName() + "'");
            return false;
        }
        return true;
    }

    private static boolean checkParameters(@Nonnull Context context, @Nonnull List<Variable> parameters, @Nonnull Modifiers modifiers) {
        boolean success = true;
        for (Variable param : parameters) {
            Type type = param.getType();
            int permittedFlags = 40;
            int permittedLayoutFlags = 0;
            if (!type.isOpaque()) {
                permittedFlags |= 0x40;
            } else if (type.isStorageImage()) {
                permittedFlags |= 0xF80;
            }
            success &= param.getModifiers().checkFlags(context, permittedFlags);
            success &= param.getModifiers().checkLayoutFlags(context, permittedLayoutFlags);
            if ((modifiers.flags() & 0x8000) == 0 || (param.getModifiers().flags() & 0x40) == 0) continue;
            context.error(param.getModifiers().mPosition, "pure functions cannot have out parameters");
            success = false;
        }
        return success;
    }

    private static boolean checkEntryPointSignature(@Nonnull Context context, int pos, @Nonnull Type returnType, @Nonnull List<Variable> parameters) {
        switch (context.getKind()) {
            case VERTEX: 
            case FRAGMENT: 
            case COMPUTE: {
                if (!returnType.matches(context.getTypes().mVoid)) {
                    context.error(pos, "entry point must return 'void'");
                    return false;
                }
                if (parameters.isEmpty()) break;
                context.error(pos, "entry point must have zero parameters");
                return false;
            }
        }
        return true;
    }

    private static int findGenericIndex(@Nonnull Type concreteType, @Nonnull Type genericType, boolean allowNarrowing) {
        Type[] types = genericType.getCoercibleTypes();
        for (int index = 0; index < types.length; ++index) {
            if (!concreteType.canCoerceTo(types[index], allowNarrowing)) continue;
            return index;
        }
        return -1;
    }

    private static boolean typeMatches(@Nonnull Type concreteType, @Nonnull Type maybeGenericType) {
        return maybeGenericType.isGeneric() ? FunctionDecl.findGenericIndex(concreteType, maybeGenericType, false) != -1 : concreteType.matches(maybeGenericType);
    }

    private static boolean parametersMatch(@Nonnull List<Variable> params, @Nonnull List<Variable> otherParams) {
        Type otherParamType;
        Type paramType;
        int i;
        if (params.size() != otherParams.size()) {
            return false;
        }
        int genericIndex = -1;
        for (i = 0; i < params.size(); ++i) {
            paramType = params.get(i).getType();
            otherParamType = otherParams.get(i).getType();
            if (!otherParamType.isGeneric()) continue;
            int genericIndexForThisParam = FunctionDecl.findGenericIndex(paramType, otherParamType, false);
            if (genericIndexForThisParam == -1) {
                return false;
            }
            if (genericIndex != -1 && genericIndex != genericIndexForThisParam) {
                return false;
            }
            genericIndex = genericIndexForThisParam;
        }
        for (i = 0; i < params.size(); ++i) {
            paramType = params.get(i).getType();
            otherParamType = otherParams.get(i).getType();
            if (otherParamType.isGeneric()) {
                otherParamType = otherParamType.getCoercibleTypes()[genericIndex];
            }
            if (paramType.matches(otherParamType)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static FunctionDecl convert(@Nonnull Context context, int pos, @Nonnull Modifiers modifiers, @Nonnull String name, @Nonnull List<Variable> parameters, @Nonnull Type returnType) {
        int intrinsicKind = context.isBuiltin() ? IntrinsicList.findIntrinsicKind(name) : -1;
        boolean isEntryPoint = name.equals(context.getOptions().mEntryPointName);
        if (!FunctionDecl.checkModifiers(context, modifiers)) {
            return null;
        }
        if (!FunctionDecl.checkReturnType(context, pos, returnType)) {
            return null;
        }
        if (!FunctionDecl.checkParameters(context, parameters, modifiers)) {
            return null;
        }
        if (isEntryPoint && !FunctionDecl.checkEntryPointSignature(context, pos, returnType, parameters)) {
            return null;
        }
        Symbol entry = context.getSymbolTable().find(name);
        if (entry != null) {
            if (!(entry instanceof FunctionDecl)) {
                context.error(pos, "symbol '" + name + "' was already defined");
                return null;
            }
            FunctionDecl chain = (FunctionDecl)entry;
            FunctionDecl existingDecl = null;
            for (FunctionDecl other = chain; other != null; other = other.getNextOverload()) {
                if (!FunctionDecl.parametersMatch(parameters, other.getParameters())) continue;
                if (!FunctionDecl.typeMatches(returnType, other.getReturnType())) {
                    FunctionDecl invalidDecl = new FunctionDecl(pos, modifiers, name, parameters, returnType, context.isBuiltin(), isEntryPoint, intrinsicKind);
                    context.error(pos, "functions '" + invalidDecl + "' and '" + other + "' differ only in return type");
                    return null;
                }
                for (int i = 0; i < parameters.size(); ++i) {
                    if (parameters.get(i).getModifiers().equals(other.getParameters().get(i).getModifiers())) continue;
                    context.error(parameters.get((int)i).mPosition, "modifiers on parameter " + (i + 1) + " differ between declaration and definition");
                    return null;
                }
                if (other.getDefinition() != null || other.isIntrinsic() || !modifiers.equals(other.getModifiers())) {
                    FunctionDecl invalidDecl = new FunctionDecl(pos, modifiers, name, parameters, returnType, context.isBuiltin(), isEntryPoint, intrinsicKind);
                    context.error(pos, "redefinition of '" + invalidDecl + "'");
                    return null;
                }
                existingDecl = other;
                break;
            }
            if (existingDecl == null && chain.isEntryPoint()) {
                context.error(pos, "redefinition of entry point");
                return null;
            }
            if (existingDecl != null) {
                return existingDecl;
            }
        }
        return context.getSymbolTable().insert(context, new FunctionDecl(pos, modifiers, name, parameters, returnType, context.isBuiltin(), isEntryPoint, intrinsicKind));
    }

    @Override
    @Nonnull
    public Node.SymbolKind getKind() {
        return Node.SymbolKind.FUNCTION_DECL;
    }

    @Override
    @Nonnull
    public Type getType() {
        throw new AssertionError();
    }

    @Nonnull
    public Type getReturnType() {
        return this.mReturnType;
    }

    public int getIntrinsicKind() {
        return this.mIntrinsicKind;
    }

    public boolean isIntrinsic() {
        return this.mIntrinsicKind != -1;
    }

    public FunctionDefinition getDefinition() {
        return this.mDefinition;
    }

    public void setDefinition(FunctionDefinition definition) {
        this.mDefinition = definition;
    }

    public List<Variable> getParameters() {
        return this.mParameters;
    }

    @Nonnull
    public String getMangledName() {
        if (this.isIntrinsic() || this.isEntryPoint()) {
            return this.getName();
        }
        StringBuilder mangledName = new StringBuilder(this.getName());
        for (Variable p : this.mParameters) {
            mangledName.append('_').append(p.getType().getDesc());
        }
        return mangledName.toString();
    }

    @Nullable
    public FunctionDecl getNextOverload() {
        return this.mNextOverload;
    }

    public void setNextOverload(FunctionDecl overload) {
        assert (overload == null || overload.getName().equals(this.getName()));
        this.mNextOverload = overload;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public boolean isBuiltin() {
        return this.mBuiltin;
    }

    public boolean isEntryPoint() {
        return this.mEntryPoint;
    }

    @Nullable
    public Type resolveParameterTypes(@Nonnull List<Expression> arguments, List<Type> outParameterTypes) {
        List<Variable> parameters = this.mParameters;
        assert (parameters.size() == arguments.size());
        int genericIndex = -1;
        for (int i = 0; i < arguments.size(); ++i) {
            Type parameterType = parameters.get(i).getType();
            if (!parameterType.isGeneric()) {
                outParameterTypes.add(parameterType);
                continue;
            }
            if (genericIndex == -1 && (genericIndex = FunctionDecl.findGenericIndex(arguments.get(i).getType(), parameterType, true)) == -1) {
                return null;
            }
            outParameterTypes.add(parameterType.getCoercibleTypes()[genericIndex]);
        }
        Type returnType = this.mReturnType;
        if (returnType.isGeneric()) {
            if (genericIndex == -1) {
                return null;
            }
            return returnType.getCoercibleTypes()[genericIndex];
        }
        return returnType;
    }

    @Override
    @Nonnull
    public String toString() {
        String header = this.mModifiers.toString() + this.mReturnType.getName() + " " + this.getName() + "(";
        StringJoiner joiner = new StringJoiner(", ");
        for (Variable p : this.mParameters) {
            joiner.add(p.toString());
        }
        return header + joiner + ")";
    }
}

