/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Symbol;
import icyllis.arc3d.compiler.tree.Type;
import icyllis.arc3d.compiler.tree.Variable;
import javax.annotation.Nonnull;

public final class AnonymousField
extends Symbol {
    private final Variable mContainer;
    private final int mFieldIndex;

    public AnonymousField(int position, Variable container, int fieldIndex) {
        super(position, container.getType().getFields()[fieldIndex].name());
        this.mContainer = container;
        this.mFieldIndex = fieldIndex;
    }

    @Override
    @Nonnull
    public Node.SymbolKind getKind() {
        return Node.SymbolKind.ANONYMOUS_FIELD;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.mContainer.getType().getFields()[this.mFieldIndex].type();
    }

    public int getFieldIndex() {
        return this.mFieldIndex;
    }

    public Variable getContainer() {
        return this.mContainer;
    }

    @Override
    @Nonnull
    public String toString() {
        return this.mContainer.toString() + "." + this.getName();
    }
}

