/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.lex;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface NFAState {
    public boolean accept(char var1);

    public @Unmodifiable IntList next();

    @Nonnull
    public static NFAState Accept(int token) {
        return new Accept(token);
    }

    @Nonnull
    public static NFAState Filter(IntPredicate filter, @Unmodifiable IntList next) {
        return new Filter(filter, next);
    }

    @Nonnull
    public static NFAState Replace(@Unmodifiable IntList shadow) {
        return new Replace(shadow);
    }

    public static class Accept
    implements NFAState {
        public final int mToken;

        private Accept(int token) {
            this.mToken = token;
        }

        @Override
        public boolean accept(char c) {
            return false;
        }

        @Override
        public IntList next() {
            return IntList.of();
        }
    }

    public static class Filter
    implements NFAState {
        private final IntPredicate mFilter;
        private final @Unmodifiable IntList mNext;

        private Filter(IntPredicate filter, @Unmodifiable IntList next) {
            this.mFilter = filter;
            this.mNext = next;
        }

        @Override
        public boolean accept(char c) {
            return this.mFilter.test(c);
        }

        @Override
        public IntList next() {
            return this.mNext;
        }
    }

    public static class Replace
    implements NFAState {
        public final @Unmodifiable IntList mShadow;

        private Replace(@Unmodifiable IntList shadow) {
            this.mShadow = shadow;
        }

        @Override
        public boolean accept(char c) {
            throw new IllegalStateException();
        }

        @Override
        public IntList next() {
            throw new IllegalStateException();
        }
    }
}

