/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.lex;

import icyllis.arc3d.compiler.lex.NFAState;
import icyllis.arc3d.compiler.lex.RegexNode;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class NFA {
    private final List<NFAState> mStates = new ArrayList<NFAState>();
    private int mTokenIndex = 0;
    final IntList mStartStates = new IntArrayList();

    public void add(@Nonnull RegexNode node) {
        int token = ++this.mTokenIndex;
        int state = this.add(NFAState.Accept(token));
        this.mStartStates.addAll(node.transition(this, IntList.of((int)state)));
    }

    public int add(NFAState state) {
        int index = this.mStates.size();
        this.mStates.add(state);
        return index;
    }

    public NFAState get(int index) {
        return this.mStates.get(index);
    }

    public IntList replace(int index, IntList shadow) {
        assert (this.mStates.get(index) == null);
        this.mStates.set(index, NFAState.Replace(shadow));
        return shadow;
    }

    public int match(@Nonnull String s) {
        IntList states = this.mStartStates;
        for (int p = 0; p < s.length(); ++p) {
            IntArrayList n = new IntArrayList();
            IntListIterator intListIterator = states.iterator();
            while (intListIterator.hasNext()) {
                int index = (Integer)intListIterator.next();
                NFAState state = this.get(index);
                if (!state.accept(s.charAt(p))) continue;
                IntListIterator intListIterator2 = state.next().iterator();
                while (intListIterator2.hasNext()) {
                    int i = (Integer)intListIterator2.next();
                    NFAState nFAState = this.get(i);
                    if (nFAState instanceof NFAState.Replace) {
                        NFAState.Replace replace = (NFAState.Replace)nFAState;
                        n.addAll(replace.mShadow);
                        continue;
                    }
                    n.add(i);
                }
            }
            if (n.isEmpty()) {
                return -1;
            }
            states = n;
        }
        int accept = -1;
        IntListIterator intListIterator = states.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            NFAState nFAState = this.get(index);
            if (!(nFAState instanceof NFAState.Accept)) continue;
            NFAState.Accept e = (NFAState.Accept)nFAState;
            if (accept != -1 && e.mToken >= accept) continue;
            accept = e.mToken;
        }
        return accept;
    }
}

